<?php
/**
 * Dimensions attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;

class Advanced_Dimensions_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_ADVANCED,
			Attribute::SECTION_DIMENSIONS,
			[
				Attribute::create(
					'width',
					[
						'type'         => 'text',
						'title'        => 'Width',
						'inline_label' => true,
						'units'        => kalium_get_default_units(),
						'responsive'   => true,
					]
				),
				Attribute::create(
					'height',
					[
						'type'         => 'text',
						'title'        => 'Height',
						'inline_label' => true,
						'units'        => kalium_get_default_units(),
						'separator'    => false,
						'responsive'   => true,
					]
				),
				Attribute::create(
					'min_width',
					[
						'type'         => 'text',
						'title'        => 'Min Width',
						'inline_label' => true,
						'units'        => kalium_get_default_units(),
						'responsive'   => true,
					]
				),
				Attribute::create(
					'min_height',
					[
						'type'         => 'text',
						'title'        => 'Min Height',
						'inline_label' => true,
						'separator'    => false,
						'units'        => kalium_get_default_units(),
						'responsive'   => true,
					]
				),
			]
		);
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		$element = $this->get_element();

		$element->add_style(
			[
				// Self
				'&' => [
					// Dimensions
					'width'      => $element->get_attribute( 'width' ),
					'height'     => $element->get_attribute( 'height' ),

					// Min dimensions
					'min-width'  => $element->get_attribute( 'min_width' ),
					'min-height' => $element->get_attribute( 'min_height' ),
				],
			]
		);
	}
}
