<?php
/**
 * Laborator Builder.
 *
 * Elements container class.
 */

namespace Laborator_Builder;

class Elements {

	/**
	 * Elements.
	 *
	 * @var Element[]
	 */
	public $elements = [];

	/**
	 * Create instance.
	 *
	 * @param Element|Element[]
	 */
	public static function create( $elements ) {
		return new self( $elements );
	}

	/**
	 * Constructor.
	 *
	 * @param Element|Element[]
	 */
	public function __construct( $elements = [] ) {
		$this->add_element( $elements );
	}

	/**
	 * Add element or list of elements.
	 *
	 * @param Element|Element[] $elements
	 */
	public function add_element( $elements ) {
		if ( ! is_array( $elements ) ) {
			$elements = [ $elements ];
		}

		// Add elements to container
		foreach ( $elements as $element ) {
			if ( $element instanceof Element ) {
				$this->elements[] = $element;
			}
		}
	}

	/**
	 * Check if it has elements.
	 *
	 * @return bool
	 */
	public function has_elements() {
		return 0 < count( $this->elements );
	}

	/**
	 * Get elements array.
	 *
	 * @return Element[]
	 */
	public function get_elements() {
		return $this->elements;
	}
}
