<?php
/**
 * Laborator Builder.
 *
 * Exporter to JSON for element and attribute.
 */

namespace Laborator_Builder;

trait Exporter {

	/**
	 * Export attribute to JSON.
	 *
	 * @param Attribute $attribute
	 *
	 * @return array
	 */
	public function attribute_export( $attribute ) {
		$json = [

			// Mandatory attribute options
			'type'             => $attribute->get_type(),
			'name'             => $attribute->get_name(),

			// Attribute data
			'title'            => $attribute->get_title(),
			'description'      => $attribute->get_description(),
			'inlineLabel'      => $attribute->is_inline_label(),
			'separator'        => $attribute->has_separator(),
			'tooltip'          => $attribute->get_tooltip(),
			'tooltipPlacement' => $attribute->get_tooltip_placement(),
			'order'            => $attribute->get_order(),
			'tab'              => $attribute->get_tab(),
			'section'          => $attribute->get_section(),

			// Attribute input data
			'default'          => $attribute->get_default_value(),
			'responsive'       => $attribute->is_responsive(),
			'reset'            => $attribute->is_resetable(),
			'choices'          => $attribute->get_choices(),
			'contextual'       => $attribute->is_contextual(),
			'validate'         => $attribute->get_validate_rules(),
			'dependency'       => $attribute->get_dependency_rules(),

			// Other options
			// ...$attribute->get_options()
		];

		// Attribute type specific options
		foreach ( $attribute->get_options() as $key => $value ) {
			$key = $this->to_camelcase( $key );

			if ( ! isset( $json[ $key ] ) ) {
				$json[ $key ] = $value;
			}
		}

		// Attribute assigned value
		$json['value'] = $this->value_object_to_json( $attribute->get_value_object() );

		return $json;
	}

	/**
	 * Export value object to JSON.
	 *
	 * @param Value|Responsive_Value $value
	 *
	 * @return mixed|array
	 */
	public function value_object_to_json( $value ) {
		if ( $value instanceof Responsive_Value ) {
			return $value->get_all_values();
		}

		return $value->value();
	}

	/**
	 * Camel case property names.
	 *
	 * @param string $str
	 * @param bool   $capitalize_first_character
	 *
	 * @return string
	 */
	private function to_camelcase( $str, $capitalize_first_character = false ) {
		$str = str_replace( ' ', '', ucwords( strtr( $str, '_-', ' ' ) ) );

		if ( ! $capitalize_first_character ) {
			$str = lcfirst( $str );
		}

		return $str;
	}
}
