/**
 * @package kalium
 * @version 4.4.3
 * @author  Laborator
 * @see     {@link https://kaliumtheme.com}
 * @build   1763930971
 */
!function(){"use strict";var t=window.jQuery||window.top.jQuery;class e{constructor({name:t="",style:n="normal",weight:i="normal",unicodeRange:s="",display:a="inherit",data:o={},font:r=null}={}){this.name,this.style,this.weight,this.display,this.unicodeRange,this.fontFiles={},this.instanceId="variant-"+e.instanceCounter++,this.data=o,this.font,this.setName(t),this.setStyle(n),this.setWeight(i),this.setDisplay(a),this.setUnicodeRange(s),this.setFont(r)}setName(t){this.name=t}setStyle(t){this.style="italic"===t?t:"normal"}setWeight(t){this.weight=isNaN(+t)?_.contains(["bold","bolder","lighter"],t)?t:"normal":+t,400===this.weight&&(this.weight="normal")}setDisplay(t){this.display=_.contains(["inherit","auto","block","fallback","optional"],t)?t:"swap"}setUnicodeRange(t){this.unicodeRange=this.formatUnicodeRange(t)}setFont(t){this.font=t}getFontFiles(){return this.fontFiles}addFontFile(t,e){t=t.toLowerCase(),_.contains(["woff2","woff","ttf","svg","eot"],t)&&(this.fontFiles[t]=e)}removeFontFile(t){t=t.toLowerCase(),_.contains(["woff2","woff","ttf","svg","eot"],t)&&delete this.fontFiles[t]}getInstanceId(){return this.instanceId}isRegular(){return"normal"===this.weight}isItalic(){return"italic"===this.style}equals(t){const n=["name","style","weight","display","unicodeRange","fontFiles"];if(!t instanceof e)return!1;for(const e of n){let n=this[e],i=t[e];if("object"==typeof n){for(let t in n)if(n[t]!==i[t])return!1}else if(n!==i)return!1}return!0}formatUnicodeRange(t){return t&&0!==t.trim().length?t.split(",").map(t=>"U+"+t.replace("U+","").replace(/\s/g,"")).join(","):""}generateFontFace(t=""){if(!(t=t||this.name))return null;t=t.replace(/\'/g,"\\'");let e=["@font-face {"];e.push(`\tfont-family: '${this.name||t}';`),e.push(`\tfont-style: ${this.style};`),e.push(`\tfont-weight: ${this.weight};`),e.push(`\tfont-display: ${this.display};`);let n=this.getFontFiles(),i={eot:"embedded-opentype",ttf:"truetype"},s=[];for(const t in n)s.push(`url('${n[t]}') format('${i[t]||t}')`);return s.length&&e.push(`\tsrc: ${s.join(", ")};`),this.unicodeRange&&e.push(`\tunicode-range: ${this.unicodeRange};`),e.push("}"),e.join("\n")}getNicename(){if(this.data.niceName)return this.data.niceName;let t=[];return 100===this.weight?t.push("Thin"):200===this.weight?t.push("Extra Light"):300===this.weight?t.push("Light"):400===this.weight||"normal"===this.weight?t.push("Regular"):500===this.weight?t.push("Medium"):600===this.weight?t.push("Semi Bold"):700===this.weight||"bold"===this.weight?t.push("Bold"):800===this.weight?t.push("Extra Bold"):900===this.weight&&t.push("Black"),!this.isRegular()&&this.weight.toString().match(/^[0-9]+$/)&&t.push(this.weight),this.isItalic()&&(this.isRegular()?t=["Italic"]:t.push("italic")),t.join(" ")}toString(t=null){return t?t.getVariantValue(this):this.font?this.font.getVariantValue(this):[this.weight,this.style].join("-")}export(){return{style:this.style,weight:this.weight,unicodeRange:this.unicodeRange,display:this.display,src:this.fontFiles}}}e.instanceCounter=1,e.createFromGoogleFormat=function(t,e){let n=t.match(/(?<weight>[0-9]+)(?<italic>italic)?/),i="normal",s="normal";return"italic"===t&&(s="italic"),n&&(i=parseInt(n.groups.weight,10),n.groups.italic&&(s="italic")),400===i&&(i="normal"),new this({style:s,weight:i,font:e})},e.createFromLaboratorFontFormat=function(t,e){return this.createFromGoogleFormat(t,e)},e.createFromSystemFontFormat=function(t,e){return this.createFromGoogleFormat(t,e)},e.createFromAdobeFormat=function(t,e){let n=t.split(""),i="i"===n[0]?"italic":"normal",s=Number(n[1]);return s*=100,new this({style:i,weight:s,font:e})};class n extends Array{constructor(t){super(),t instanceof Array&&t.forEach(t=>this.push(t))}}class i{constructor(t){_.each(t,(t,e)=>{this[e]=t}),this.variants=new n,this.ready()}getSource(){return this.source}getFontFamily(){return this.font_family}setFontFamily(t){this.font_family=t}getVariants(){return this.variants}setVariants(t){this.variants=new n,t instanceof e?(t.setFont(this),this.variants.push(t)):t.forEach(t=>{t instanceof e&&(t.setFont(this),this.variants.push(t))}),this.trigger("variants-updated",this.variants)}getVariantValue(t){let e=[];return t.isRegular()?e.push(t.isItalic()?"italic":"regular"):(e.push(t.weight),t.isItalic()&&e.push("italic")),e.join("")}getAvailableVariants(){return this.getVariants()}getDefaultVariant(){let t=this.getAvailableVariants(),e=null;return t.length&&(e=t[0],t.some(t=>!(!t.isRegular()||t.isItalic())&&(e=t,!0))),e}getVariantsValue(t=!1){let e=this.getVariants().map(t=>t.toString());return t?e:e.join(",")}ready(){}}i.prototype.source="none",_.extend(i.prototype,Backbone.Events);class s{constructor(e,n,s){this.fontConstructor=i,this.fontsList=e,this.$container=t("#font_variants_select_and_preview"),this.$fontSelector=n,this.font=null,this.data=s,this.ready()}getFontProvider(){return this.fontProvider}getFontsList(){return this.fontsList}getFont(){return this.font}getContainer(){return this.$container}getData(){return this.data}ready(){}selected(){}select(t){this.font=new this.fontConstructor(t)}preview(){}change(){}}function a(){return typolab_settings.previewText||"Almost before we knew it, we had left the ground."}function o(t){return t.replace(/\s+/g,"+")}function r(t){t=_.defaults(t,{family:"",variants:[],display:"swap",text:null});let e=!1,n=[],i=[],s=t=>1===n.length&&400===n[0]?i.length>1||1===i.length&&400!==i[0]?[1,t].join(","):1:[1,t].join(","),a=t=>n.length&&i.length?1===i.length&&400===i[0]?0:[0,t].join(","):t;const r=["family=",o(t.family)];return t.variants.forEach(t=>{t.isRegular()||(e=!0),t.isRegular()?t.isItalic()?n.push(400):i.push(400):t.isItalic()?n.push(t.weight):i.push(t.weight)}),n=_.uniq(n).sort(),i=_.uniq(i).sort(),(i.length>1||n.length>0||1===i.length&&400!==i[0])&&(r.push(":"),n.length>0&&r.push("ital"),(i.length>0&&(i.length>1||400!==i[0])||e)&&(r.push(n.length?",":""),r.push("wght")),r.push("@"),r.push(i.map(a).join(";")),r.push(i.length&&n.length?";":""),r.push(n.map(s).join(";"))),t.display&&(r.push("&"),r.push(`display=${t.display}`)),t.text&&(r.push("&"),r.push(`text=${o(t.text)}`)),r.unshift("https://fonts.googleapis.com/css2?"),r.join("")}function l(t,e){let n=[];t.getAvailableVariants().forEach((t,i)=>{let s=e.eq(i),a=s.find('input[type="checkbox"]').is(":checked");s[a?"addClass":"removeClass"]("is-checked"),a&&n.push(t)}),t.setVariants(n)}s.prototype.fontProvider="none";const c=[{value:"normal",title:"Normal"},{value:"italic",title:"Italic"}],h=[{value:"100",title:"Thin (100)"},{value:"200",title:"Extra Light (200)"},{value:"300",title:"Light (300)"},{value:"normal",title:"Normal (400)"},{value:"500",title:"Medium (500)"},{value:"600",title:"Semi Bold (600)"},{value:"bold",title:"Bold (700)"},{value:"800",title:"Extra Bold (800)"},{value:"900",title:"Black (900)"}],u=[{value:"inherit",title:"Inherit"},{value:"auto",title:"Auto"},{value:"swap",title:"Swap"},{value:"block",title:"Block"},{value:"fallback",title:"Fallback"},{value:"optional",title:"Optional"}],p=typolab_settings.units,d={...p},f={...p},g=typolab_settings.defaultUnit;function m(t,e){let n="normal"===t.weight?400:+t.weight,i="normal"===e.weight?400:+e.weight;return t.isItalic()&&(n+=1),e.isItalic()&&(i+=1),n-i}class v extends i{setVariants(t){"string"==typeof t&&(t=t.split(",")),t instanceof e?super.setVariants(t):super.setVariants(t.map(t=>t instanceof e?t:e.createFromGoogleFormat(t,this)))}getAvailableVariants(){return this.font_data.variants.map(t=>e.createFromGoogleFormat(t,this)).sort(m)}getVariantsPreviewList(){return this.getAvailableVariants().map(t=>({value:t.toString(),title:t.getNicename(),fontFamily:this.getFontFamily(),style:t.style,weight:t.weight}))}getStylesheet(){return r({family:this.getFontFamily()})}getVersion(){return this.font_data.version}getLastModifiedDate(){return this.font_data.lastModified}categoryNicename(){let t=this.category;switch(t){case"display":t="Display";break;case"handwriting":t="Handwriting";break;case"monospace":t="Monospace";break;case"sans-serif":t="Sans Serif";break;case"serif":t="Serif"}return t}}v.prototype.source="google";class y extends s{ready(){this.fontConstructor=v}selected(){let t=this.getData();t.selected_variants&&t.selected_variants.length&&this.getFont().setVariants(t.selected_variants)}preview(){let t=this.getFont(),e=this.getContainer(),n=wp.template("font-variants-select-container"),i=wp.template("select-font-variants"),s=wp.template("font-details-footer"),c=[],h=r({family:t.getFontFamily(),variants:t.getAvailableVariants(),display:"block",text:a()}),u=[`<a href="https://fonts.google.com/specimen/${o(t.getFontFamily())}" target="_blank" rel="noopener">Font Details</a>`,`Category: ${t.categoryNicename()}`,`Last Update: ${t.getLastModifiedDate()}`];t.getVariants().length||t.setVariants(t.getDefaultVariant()),c.push(i({stylesheet:h,previewText:a(),variants:t.getVariantsPreviewList(),selected:t.getVariantsValue(!0),footer:s({details:u})})),e.html(n({content:c.join("\n")})),e.find('input[type="checkbox"]').on("change",n=>l(t,e.find(".variant-entry"))),e.find('link[rel="stylesheet"]').on("load",t=>{e.find(".variant-preview-text").addClass("is-loaded")})}}y.prototype.fontProvider="google-fonts";class w extends i{setVariants(t){"string"==typeof t&&(t=t.split(",")),t instanceof e?super.setVariants(t):super.setVariants(t.map(t=>t instanceof e?t:e.createFromLaboratorFontFormat(t,this)))}getAvailableVariants(){return this.font_data.variants.map(t=>e.createFromLaboratorFontFormat(t,this))}getVariantsPreviewList(){return this.getAvailableVariants().map(t=>({value:t.toString(),title:t.getNicename(),image:this.font_data.images[t.toString()]}))}getFontAuthorUrl(){return this.font_data.url}getPackageSize(){return this.font_data.packageSize}categoryNicename(){return this.font_data.category}}w.prototype.source="laborator";class V extends s{ready(){this.fontConstructor=w}selected(){let t=this.getData();t.selected_variants&&t.selected_variants.length&&this.getFont().setVariants(t.selected_variants)}preview(){let e=this.getFont(),n=this.getContainer(),i=wp.template("font-variants-select-container"),s=wp.template("select-font-variants"),o=wp.template("font-details-footer"),r=[],c=[`<a href="${e.getFontAuthorUrl()}" target="_blank" rel="noopener">Font Details</a>`,`Category: ${e.categoryNicename()}`,`Package Size: ${e.getPackageSize()}`];e.getVariants().length||e.setVariants(e.getDefaultVariant()),r.push(s({previewText:a(),variants:e.getVariantsPreviewList(),selected:e.getVariantsValue(!0),footer:o({details:c})})),n.html(i({content:r.join("\n")})),n.find('input[type="checkbox"]').on("change",t=>l(e,n.find(".variant-entry"))),n.find(".variant-preview-image img").on("load",e=>{t(e.currentTarget).addClass("is-loaded")})}}V.prototype.fontProvider="laborator-fonts";class F extends i{getVariantValue(t){let e=[t.isItalic()?"i":"n",parseInt(+t.weight/100,10)];return isNaN(e[1])&&(e[1]=4),e.join("")}getAvailableVariants(){return this.font_data.variations.map(t=>e.createFromAdobeFormat(t,this))}getVariantsPreviewList(){return this.getAvailableVariants().map(t=>({value:t.toString(),title:t.getNicename(),fontFamily:this.getFontFamily(),style:t.style,weight:t.weight,disabled:!0}))}getKitID(){return this.font_data.kit_id}getKitName(){return this.font_data.kit_name}getFontSlug(){return this.font_data.slug}getPublishedDate(){return this.font_data.published}}F.prototype.source="adobe";class S extends s{ready(){this.fontConstructor=F,this.$kitId=t('.font-option-field[name="kit_id"]')}preview(){let e=this.getFont(),n=this.getContainer(),i=wp.template("font-variants-select-container"),s=wp.template("select-font-variants"),o=wp.template("font-details-footer"),r=[],l=['<a href="#" title="Reload Adobe Fonts" class="font-refresh-link"><span class="kalium-admin-icon-refresh"></span></a>',`Kit ID: ${e.getKitID()}`,`Kit Name: ${e.getKitName()}`,`Last Modified: ${e.getPublishedDate()}`];e.setVariants(e.getAvailableVariants()),this.$kitId.val(e.getKitID()),r.push(s({stylesheet:`https://use.typekit.net/${e.getKitID()}.css?cachebust=${e.getFontSlug()}`,previewText:a(),variants:e.getVariantsPreviewList(),selected:e.getVariantsValue(!0),footer:o({details:l})})),n.html(i({content:r.join("\n")})),n.find('link[rel="stylesheet"]').on("load",t=>{n.find(".variant-preview-text").addClass("is-loaded")}),n.find(".font-refresh-link").on("click",e=>{let i=t(e.currentTarget);if(e.preventDefault(),!i.hasClass("is-loading")&&confirm("Reloading Adobe Fonts will refresh this page. Proceed?")){i.addClass("is-loading"),n.fadeTo(500,.6);let t=new FormData;t.append("action","typolab_reload_adobe_fonts"),fetch(ajaxurl,{method:"POST",body:t}).then(t=>t.json()).then(t=>{t.success?window.location.reload():(i.removeClass("is-loading"),alert(t.data))})}})}}S.prototype.fontProvider="adobe-fonts";class b extends i{getFontFamilyStack(){return this.font_data.font_stack}getAvailableVariants(){return this.font_data.variants.map(t=>e.createFromSystemFontFormat(t,this)).sort(m)}getVariantsPreviewList(){return this.getAvailableVariants().map(t=>({value:t.toString(),title:t.getNicename(),fontFamily:this.getFontFamilyStack(),style:t.style,weight:t.weight,disabled:!0}))}}b.prototype.source="system";class k extends s{ready(){this.fontConstructor=b}selected(){}preview(){let t=this.getFont(),e=this.getContainer(),n=wp.template("font-variants-select-container"),i=wp.template("select-font-variants"),s=[];t.setVariants(t.getAvailableVariants()),s.push(i({previewText:a(),variants:t.getVariantsPreviewList(),selected:t.getVariantsValue(!0)})),e.html(n({content:s.join("\n")})),e.find(".variant-preview-text").addClass("is-loaded")}}k.prototype.fontProvider="system-fonts";const $={"google-fonts":y,"laborator-fonts":V,"adobe-fonts":S,"system-fonts":k};let x=class{constructor({fontListSelectContainer:e,fontListSelectOptions:n}){this.$container=t(e),this.fontProvider=n.provider,this.selected=null,this.$tabsList=this.$container.find(".alphabet a"),this.$search=this.$container.find('input[name="search-fonts"]'),this.$filterCategories=this.$container.find('select[name="search-category"]'),this.$fontsList=this.$container.find(".font-list"),this.$value=this.$container.find(".font-list-selector-value"),this.$noResults=t('<div class="no-records">Nothing found!</div>'),this.fontsList=n.items,this.valueProp=n.value_prop,this.data=n.data,this.fontSourceProvider=null,this.lastActiveTab=null,this.init()}init(){this.renderFontsList(),this.setActiveTab(),this.fontSourceProvider=new $[this.fontProvider](this.fontsList,this.$container,this.data),this.$value.val()&&(this.selectValue(this.$value.val()),this.selected instanceof i&&(this.lastActiveTab!==this.firstLetter(this.selected.getFontFamily())&&this.setActiveTab(this.firstLetter(this.selected.getFontFamily())),this.$fontsList.scrollTop()<this.selected.$el.position().top&&this.$fontsList.scrollTop(this.selected.$el.position().top-this.$fontsList.height()/2+this.selected.$el.outerHeight()/2),this.fontSourceProvider.selected(),this.fontSourceProvider.preview())),this.$tabsList.on("click",e=>{e.preventDefault();let n=t(e.currentTarget).data("tab");this.setActiveTab(n)}),this.$filterCategories.on("change",()=>{let t=this.$filterCategories.val(),e={category:t};t||(e.tab=this.lastActiveTab),this.filterFontsListDOM(e)}),this.$search.on("keyup",()=>{let t=this.$search.val(),e={search:t};t||(e.tab=this.lastActiveTab),this.filterFontsListDOM(e)}),this.$fontsList.on("click",".font-selector-item",e=>{let n=t(e.currentTarget).data("item");e.preventDefault(),this.select(n),this.fontSourceProvider.preview()})}getFontSourceProvider(){return this.fontSourceProvider}getSelectedFont(){return this.selected}escapeRegExp(t){return t.toString().replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}firstLetter(t){return t.toString().substring(0,1).toUpperCase()}filterFontsList(t={search:"",category:"",tab:""}){return this.fontsList.filter(e=>{let n=!0;if(t.tab&&(n=e.font_family.toUpperCase().match(new RegExp(`^${this.firstLetter(t.tab)}`,"i"))),n&&t.category&&(n=e.category===t.category),n&&t.search){let i=[`(^${this.escapeRegExp(t.search)})`,`(\\s${this.escapeRegExp(t.search)})`,`(${this.escapeRegExp(t.search)}(\\s|$))`];n=e.font_family.match(new RegExp(`(${i.join("|")})`,"i"))}return n})}filterFontsListDOM(t={search:"",category:"",tab:""}){this.fontsList.map(this.setDeactiveFontIterator);var e=this.filterFontsList(t).map(this.setActiveFontIterator).length>0;this.$noResults[e?"removeClass":"addClass"]("active"),this.$fontsList.scrollTop(0)}renderFontsList(){let e=wp.template("font-selector-item");this.$fontsList.html(""),this.fontsList.map(n=>{n.$el=t(e({title:n.title?n.title:n.font_family})),n.$el.data("item",n),this.$fontsList.append(n.$el)}),this.$noResults.appendTo(this.$fontsList)}setDeactiveFontIterator(t){t.$el.removeClass("active")}setActiveFontIterator(t){t.$el.addClass("active")}getDefaultTab(){let e=this.$container.data("active-tab");if(e){let n=this.$tabsList.filter((n,i)=>e===t(i).data("tab"));if(0<n.length)return n.data("tab")}return this.$tabsList.first().data("tab")}setActiveTab(t=""){t||(t=this.getDefaultTab()),0===this.$tabsList.length&&(t=""),this.filterFontsListDOM({tab:t}),this.$tabsList.removeClass("current").filter((e,n)=>t===n.dataset.tab).addClass("current"),this.lastActiveTab=t}select(t){"object"==typeof t&&(this.fontsList.map(e=>e.$el[e===t?"addClass":"removeClass"]("current")),this.fontSourceProvider.select(t),this.selected=this.fontSourceProvider.getFont(),this.$value.val(this.selected[this.valueProp]),this.fontSourceProvider.change(),this.trigger("font-select",this.getSelectedFont()))}selectValue(t){for(let e of this.fontsList)if(t===e[this.valueProp])return void this.select(e)}};_.extend(x.prototype,Backbone.Events);class C extends i{isValid(){return 0<this.getFontFamily().length&&0<this.getVariants().filter(t=>null!==t.generateFontFace(this.getFontFamily())).length}}C.prototype.source="hosted";class B{constructor({fontFamilyNameInput:e,fontVariantsContainer:n,fontVariants:i}){this.$fontFamilyNameInput=t(e),this.$fontVariantsContainer=t(n),this.$fontPreviewContainer=t("#font_variants_select_and_preview"),this.font=new C,this.font.setVariants(this.createFontVariants(i)),this.init()}init(){this.setFontFamilyName(this.getFontFamilyNameFromInput()),this.renderVariants(),this.$fontVariantsContainer.sortable({update:()=>{const t=[];this.$fontVariantsContainer.children().each((e,n)=>{t.push(n.variantReference)}),this.font.setVariants(t),this.preview()}}),this.$fontFamilyNameInput.on("input",t=>{this.setFontFamilyName(this.getFontFamilyNameFromInput())}),t("#add-font-variant").on("click",t=>{t.preventDefault(),this.getFontVariants().push(new e),this.renderVariants(),this.preview()})}getFont(){return this.font}getFontFamilyName(){return this.font.getFontFamily()}setFontFamilyName(t){this.font.setFontFamily(t),this.preview()}getFontVariants(){return this.font.getVariants()}getFontFamilyNameFromInput(){return this.$fontFamilyNameInput.val()}createFontVariants(t){let n=[];return t instanceof Array&&t.forEach(t=>{if(t instanceof e)n.push(t);else{let i=new e({style:t.style,weight:t.weight,unicodeRange:t.unicode_range,display:t.display,font:this.getFont()});_.each(t.src,(t,e)=>i.addFontFile(e,t)),n.push(i)}}),n}openMediaFrame(t,e){let n=wp.media({title:`Select or upload ${t.toUpperCase()}  font file`,multiple:!1,library:{type:["font","application"]}}),i=e[0].selectedAttachment;n.on("open",()=>{e[0].selectedAttachment&&n.state().get("selection").add(i)}),n.on("select",()=>{let t=n.state().get("selection").first(),i=t.toJSON();e.val(i.url).trigger("input"),e[0].selectedAttachment=t}),n.open()}bindVariant(e,n){let i={style:n.find(".select-font-style"),weight:n.find(".select-font-weight"),unicodeRange:n.find(".input-font-unicode-range"),display:n.find(".select-font-display"),src:{woff2:n.find('.font-file-woff2 input[type="text"]'),woff:n.find('.font-file-woff input[type="text"]'),ttf:n.find('.font-file-ttf input[type="text"]'),svg:n.find('.font-file-svg input[type="text"]'),eot:n.find('.font-file-eot input[type="text"]')}},s=t=>{e.setStyle(i.style.val()),e.setWeight(i.weight.val()),e.setDisplay(i.display.val()),e.setUnicodeRange(i.unicodeRange.val()),_.each(i.src,(t,n)=>{let i=t.val();e.removeFontFile(n),i&&e.addFontFile(n,i)}),this.preview(),this.trigger("variant-updated",e)};n[0].variantReference=e,i.style.on("change",s),i.weight.on("change",s),i.display.on("change",s),i.unicodeRange.on("input",s),_.each(i.src,(t,e)=>{t.on("input",s),t.next().on("click",n=>this.openMediaFrame(e,t))}),n.on("click",".typolab-toggle-body",t=>{t.preventDefault();let i="typolab-toggle--toggled";n.toggleClass(i),e._isToggled=n.hasClass(i)}),n.on("click",".show-advanced-options",i=>{i.preventDefault();let s=t(i.currentTarget),a=n.find(".advanced-option"),o="is-visible";a.hasClass(o)?s.text(s.data("show-text")):s.text(s.data("hide-text")),a.toggleClass(o),e._advancedOptionsVisible=a.hasClass(o)}),n.on("click",".delete",t=>{t.preventDefault(),confirm("Confirm delete?")&&this.removeVariant(e)})}removeVariant(t){this.font.setVariants(this.font.getVariants().filter(e=>t!==e)),this.renderVariants(),this.preview()}renderVariants(){let e=wp.template("font-variant-form"),n=wp.template("select-options-list");this.$fontVariantsContainer.html("");for(let i of this.getFontVariants()){let s=i.getFontFiles(),a=e({id:i.getInstanceId(),fontStyleOptions:n({optionsList:c,selected:i.style}),fontWeightOptions:n({optionsList:h,selected:i.weight,default:"normal"}),fontDisplayOptions:n({optionsList:u,selected:i.display,default:"swap"}),files:{woff2:s.woff2,woff:s.woff,ttf:s.ttf,svg:s.svg,eot:s.eot},unicodeRange:i.unicodeRange.replace(/U\+/g,""),advancedOptionsVisible:i._advancedOptionsVisible,isToggled:i._isToggled}),o=t(a);this.bindVariant(i,o),this.$fontVariantsContainer.append(o)}}preview(){let t=this.getFontFamilyName(),e=[],n=[];if(this.getFontVariants().forEach(i=>{const s=i.generateFontFace(t);s&&(e.push(s),n.push({title:i.getNicename(),fontFamily:t,style:i.style,weight:i.weight}))}),e.length){let t=wp.template("font-variants-select-container"),i=wp.template("select-font-variants"),s=[];this.$fontPreviewContainer.html(""),s.push(i({style:`<style>${e.join("\n")}</style>`,previewText:a(),variants:n})),this.$fontPreviewContainer.html(t({content:s.join("\n")})).find(".variant-preview-text").addClass("is-loaded")}}}_.extend(B.prototype,Backbone.Events);class I extends i{getStylesheetURL(){return this.stylesheetURL}setStylesheetURL(t){this.stylesheetURL=t}isValid(){return 0<this.getFontFamily().length&&0<this.getVariants().filter(t=>null!==t.generateFontFace(this.getFontFamily())).length}}I.prototype.source="external",I.prototype.stylesheetURL=null;var R=/\/\*[^*]*\*+([^/*][^*]*\*+)*\//g;function L(t,e){e=e||{};var n=1,i=1;function s(t){var e=t.match(/\n/g);e&&(n+=e.length);var s=t.lastIndexOf("\n");i=~s?t.length-s:i+t.length}function a(){var t={line:n,column:i};return function(e){return e.position=new o(t),d(),e}}function o(t){this.start=t,this.end={line:n,column:i},this.source=e.source}o.prototype.content=t;var r=[];function l(s){var a=new Error(e.source+":"+n+":"+i+": "+s);if(a.reason=s,a.filename=e.source,a.line=n,a.column=i,a.source=t,!e.silent)throw a;r.push(a)}function c(){return p(/^{\s*/)}function h(){return p(/^}/)}function u(){var e,n=[];for(d(),f(n);t.length&&"}"!=t.charAt(0)&&(e=k()||$());)!1!==e&&(n.push(e),f(n));return n}function p(e){var n=e.exec(t);if(n){var i=n[0];return s(i),t=t.slice(i.length),n}}function d(){p(/^\s*/)}function f(t){var e;for(t=t||[];e=g();)!1!==e&&t.push(e);return t}function g(){var e=a();if("/"==t.charAt(0)&&"*"==t.charAt(1)){for(var n=2;""!=t.charAt(n)&&("*"!=t.charAt(n)||"/"!=t.charAt(n+1));)++n;if(n+=2,""===t.charAt(n-1))return l("End of comment missing");var o=t.slice(2,n-2);return i+=2,s(o),t=t.slice(n),i+=2,e({type:"comment",comment:o})}}function m(){var t=p(/^([^{]+)/);if(t)return E(t[0]).replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*\/+/g,"").replace(/"(?:\\"|[^"])*"|'(?:\\'|[^'])*'/g,function(t){return t.replace(/,/g,"‌")}).split(/\s*(?![^(]*\)),\s*/).map(function(t){return t.replace(/\u200C/g,",")})}function v(){var t=a(),e=p(/^(\*?[-#\/\*\\\w]+(\[[0-9a-z_-]+\])?)\s*/);if(e){if(e=E(e[0]),!p(/^:\s*/))return l("property missing ':'");var n=p(/^((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^\)]*?\)|[^};])+)/),i=t({type:"declaration",property:e.replace(R,""),value:n?E(n[0]).replace(R,""):""});return p(/^[;\s]*/),i}}function y(){var t,e=[];if(!c())return l("missing '{'");for(f(e);t=v();)!1!==t&&(e.push(t),f(e));return h()?e:l("missing '}'")}function w(){for(var t,e=[],n=a();t=p(/^((\d+\.\d+|\.\d+|\d+)%?|[a-z]+)\s*/);)e.push(t[1]),p(/^,\s*/);if(e.length)return n({type:"keyframe",values:e,declarations:y()})}var _,V=b("import"),F=b("charset"),S=b("namespace");function b(t){var e=new RegExp("^@"+t+"\\s*([^;]+);");return function(){var n=a(),i=p(e);if(i){var s={type:t};return s[t]=i[1].trim(),n(s)}}}function k(){if("@"==t[0])return function(){var t=a();if(e=p(/^@([-\w]+)?keyframes\s*/)){var e,n=e[1];if(!(e=p(/^([-\w]+)\s*/)))return l("@keyframes missing name");var i,s=e[1];if(!c())return l("@keyframes missing '{'");for(var o=f();i=w();)o.push(i),o=o.concat(f());return h()?t({type:"keyframes",name:s,vendor:n,keyframes:o}):l("@keyframes missing '}'")}}()||function(){var t=a(),e=p(/^@media *([^{]+)/);if(e){var n=E(e[1]);if(!c())return l("@media missing '{'");var i=f().concat(u());return h()?t({type:"media",media:n,rules:i}):l("@media missing '}'")}}()||function(){var t=a(),e=p(/^@custom-media\s+(--[^\s]+)\s*([^{;]+);/);if(e)return t({type:"custom-media",name:E(e[1]),media:E(e[2])})}()||function(){var t=a(),e=p(/^@supports *([^{]+)/);if(e){var n=E(e[1]);if(!c())return l("@supports missing '{'");var i=f().concat(u());return h()?t({type:"supports",supports:n,rules:i}):l("@supports missing '}'")}}()||V()||F()||S()||function(){var t=a(),e=p(/^@([-\w]+)?document *([^{]+)/);if(e){var n=E(e[1]),i=E(e[2]);if(!c())return l("@document missing '{'");var s=f().concat(u());return h()?t({type:"document",document:i,vendor:n,rules:s}):l("@document missing '}'")}}()||function(){var t=a();if(p(/^@page */)){var e=m()||[];if(!c())return l("@page missing '{'");for(var n,i=f();n=v();)i.push(n),i=i.concat(f());return h()?t({type:"page",selectors:e,declarations:i}):l("@page missing '}'")}}()||function(){var t=a();if(p(/^@host\s*/)){if(!c())return l("@host missing '{'");var e=f().concat(u());return h()?t({type:"host",rules:e}):l("@host missing '}'")}}()||function(){var t=a();if(p(/^@font-face\s*/)){if(!c())return l("@font-face missing '{'");for(var e,n=f();e=v();)n.push(e),n=n.concat(f());return h()?t({type:"font-face",declarations:n}):l("@font-face missing '}'")}}()}function $(){var t=a(),e=m();return e?(f(),t({type:"rule",selectors:e,declarations:y()})):l("selector missing")}return N((_=u(),{type:"stylesheet",stylesheet:{source:e.source,rules:_,parsingErrors:r}}))}function E(t){return t?t.replace(/^\s+|\s+$/g,""):""}function N(t,e){var n=t&&"string"==typeof t.type,i=n?t:e;for(var s in t){var a=t[s];Array.isArray(a)?a.forEach(function(t){N(t,i)}):a&&"object"==typeof a&&N(a,i)}return n&&Object.defineProperty(t,"parent",{configurable:!0,writable:!0,enumerable:!1,value:e||null}),t}class A{constructor({stylesheetUrlInput:e,fontVariantsContainer:n,fontVariants:i}){this.$stylesheetUrlInput=t(e),this.$fontVariantsContainer=t(n),this.$fontPreviewContainer=t("#font_variants_select_and_preview"),this.font=new I,this.setFontVariants(this.createFontVariants(i)),this.init()}init(){this.setStylesheetURL(this.getStylesheetURLFromInput()),this.$stylesheetUrlInput.on("input",t=>{this.setStylesheetURL(this.getStylesheetURLFromInput())}),this.renderVariants(),this.getFontVariants().length&&this.preview(),this.$fontVariantsContainer.sortable({update:()=>{const t=[];this.$fontVariantsContainer.children().each((e,n)=>{t.push(n.variantReference)}),this.setFontVariants(t),this.preview()}}),t("#add-font-variant").on("click",t=>{t.preventDefault(),this.getFontVariants().push(new e),this.renderVariants()}),t("#fetch-font-variants").on("click",t=>{t.preventDefault(),(0===this.getFontVariants().length||confirm("Fetching font variants will override existing ones?"))&&this.fetchVariantsFromStylesheet()})}getFont(){return this.font}getFontVariants(){return this.font.getVariants()}setFontVariants(t){_.each(t,t=>{t.data.niceName="",t.data.niceName=[t.name,t.getNicename()].join(" - ")}),this.font.setVariants(t)}getStylesheetURL(){return this.font.getStylesheetURL()}setStylesheetURL(t){this.font.setStylesheetURL(t),0===this.getFontVariants().length&&t.match(/^https?.*?(\.css|\\?)/)&&this.fetchVariantsFromStylesheet()}getStylesheetURLFromInput(){return this.$stylesheetUrlInput.val()}createFontVariants(t){let n=[];return t instanceof Array&&t.forEach(t=>{if(t instanceof e)n.push(t);else{let i=new e({name:t.name,style:t.style,weight:t.weight});n.push(i)}}),n}fetchVariantsFromStylesheet(){let n=this.getStylesheetURL(),i=t("#fetch-font-variants"),s=t=>{i[t?"addClass":"removeClass"]("is-loading"),this.$stylesheetUrlInput[t?"addClass":"removeClass"]("is-loading")};if(!n)return alert("Please enter Stylesheet URL!"),void this.$stylesheetUrlInput.focus();s(!0),fetch(n).then(t=>t.text()).then(t=>{let n=L(t),i=[];s(!1),"stylesheet"===n.type&&(_.each(n.stylesheet.rules,t=>{if("font-face"===t.type){let n,s,a;if(_.each(t.declarations,t=>{t.value&&("font-family"===t.property?n=t.value.replace(/['"]/g,""):"font-style"===t.property?s=t.value:"font-weight"===t.property&&(a=t.value))}),n&&s&&a){let t=new e({name:n,style:s,weight:a});i.push(t)}}}),1<i.length&&(i=_.reduce(i,(t,e)=>{let n=t instanceof Array?t:[t];for(let t of n)if(t.equals(e))return n;return n.push(e),n})),i=i.sort(m),this.setFontVariants(i),this.renderVariants(),this.preview()),i.length||alert("No font variants found in the given stylesheet URL!")}).catch(t=>{s(!1),alert("Error:\n"+t.message)})}bindVariant(t,e){let n={name:e.find(".input-font-name"),style:e.find(".select-font-style"),weight:e.find(".select-font-weight")},i=e=>{t.setName(n.name.val()),t.setStyle(n.style.val()),t.setWeight(n.weight.val()),t.data.niceName="",t.data.niceName=[t.name,t.getNicename()].join(" - "),this.preview(),this.trigger("variant-updated",t)};e[0].variantReference=t,n.name.on("input",i),n.style.on("change",i),n.weight.on("change",i),e.on("click",".typolab-toggle-body",n=>{n.preventDefault();let i="typolab-toggle--toggled";e.toggleClass(i),t._isToggled=e.hasClass(i)}),e.on("click",".delete",e=>{e.preventDefault(),this.removeVariant(t)})}removeVariant(t){this.setFontVariants(this.font.getVariants().filter(e=>t!==e)),this.renderVariants(),this.preview()}renderVariants(){let e=wp.template("custom-font-variant-form"),n=wp.template("select-options-list");this.$fontVariantsContainer.html("");for(let i of this.getFontVariants()){let s=e({id:i.getInstanceId(),fontFamily:i.name,fontStyleOptions:n({optionsList:c,selected:i.style}),fontWeightOptions:n({optionsList:h,selected:i.weight,default:"normal"}),isToggled:i._isToggled}),a=t(s);this.bindVariant(i,a),this.$fontVariantsContainer.append(a)}}preview(){let t=[],e=[];if(this.getFontVariants().forEach(n=>{const i=n.generateFontFace();i&&(t.push(i),e.push({title:n.getNicename(),fontFamily:n.name,style:n.style,weight:n.weight}))}),this.$fontPreviewContainer.html(""),t.length){let n=wp.template("font-variants-select-container"),i=wp.template("select-font-variants"),s=[];s.push(i({stylesheet:this.getStylesheetURL(),style:`<style>${t.join("\n")}</style>`,previewText:a(),variants:e,selected:this.getFont().getVariantsValue(!0)})),this.$fontPreviewContainer.html(n({content:s.join("\n")})).find(".variant-preview-text").addClass("is-loaded")}}}_.extend(A.prototype,Backbone.Events);class T{constructor({type:t,operator:e,value:n}={}){this.type=t||null,this.operator=e||"equals",this.value=n||null}}class U{constructor({conditionalStatementsContainer:e,conditionalStatements:n}){this.$container=t(e),this.$placeholder=this.$container.find(".no-statements").clone(),this.options=n.options,this.statements=[],n.statements.forEach(t=>this.addStatementEntry(t)),this.init()}init(){t("#add-new-conditional-statement").on("click",t=>{t.preventDefault(),this.addStatementEntry()})}getStatements(){return this.statements}removeStatement(t){this.statements=this.statements.filter(e=>e!==t),0===this.statements.length&&this.$placeholder.appendTo(this.$container.find("tbody"))}bindStatement(t,e,n){let i={type:e.find(".select-statement-type"),operator:e.find(".select-statement-operator"),value:e.find(".select-statement-value")},s=wp.template("select-options-list"),a=t=>{let e=[];t||(t=i.type.val()),_.each(this.options,n=>{n.forEach(n=>{t===n.name&&_.each(n.values,(t,n)=>e.push({title:t,value:n}))})}),i.value.html(s({optionsList:e}))},o=e=>{!0===e&&a(),t.type=i.type.val(),t.operator=i.operator.val(),t.value=i.value.val()};_.each(this.options,(t,e)=>{let n=t.map(t=>({value:t.name,title:t.title}));i.type.append(`<optgroup label="${e}">${s({optionsList:n})}</optgroup>`)}),o(!0),n&&(a(n.type),i.type.find("option").filter((t,e)=>e.value===n.type).prop("selected",!0),i.operator.find("option").filter((t,e)=>e.value===n.operator).prop("selected",!0),i.value.find("option").filter((t,e)=>e.value===n.value).prop("selected",!0),o()),i.type.on("change",t=>o(!0)),i.operator.on("change",t=>o()),i.value.on("change",t=>o()),e.on("click",".remove-conditional-statement",n=>{n.preventDefault(),this.removeStatement(t),e.remove()})}addStatementEntry(e=null){let n=new T,i=wp.template("conditional-statement-entry"),s=wp.template("select-options-list"),a=this.$container.find("tbody"),o=t(i({id:"statement-"+U.instanceId++,operatorOptions:s({optionsList:[{value:"equals",title:"is"},{value:"not-equals",title:"is not"}]})}));this.bindStatement(n,o,e),this.getStatements().push(n),a.find(".no-statements").remove(),a.append(o)}}U.instanceId=1;class z{constructor({type:t,id:e,variant:n,include:i}){this.type=t,this.id=e,this.variant=n,this.include=i}getId(){return this.id}isBaseSelector(){return"base-selector"===this.type}doInclude(){return this.include}}class D{constructor({fontBaseSelectorsContainer:e,fontBaseSelectors:n,font:i}){this.$fontBaseSelectorsContainer=t(e),this.baseSelectors=n.selectors,this.selectedValues=n.values.map(t=>new z({type:t.type,id:t.id,variant:t.variant,include:t.include})),this.font=i,this.init()}init(){_.each(this.baseSelectors,(e,n)=>{e.$baseSelector=t(`.font-base-selector[data-id="${n}"]`),e.$checkbox=e.$baseSelector.find('input[type="checkbox"]'),e.$selectElement=e.$baseSelector.find(".select-font-variant")}),this.selectedValues.forEach(t=>{let e=this.baseSelectors[t.getId()];e&&(t.doInclude()&&(e.$checkbox.prop("checked",!0),e.$baseSelector.addClass("checked")),e.selectedValue=t.variant)});let e=this.getFont();e&&!e.hasOwnProperty("fetched")&&this.resetVariants(),_.each(this.getBaseSelectors(),t=>{t.$baseSelector.on("click",e=>{e.target===t.$baseSelector[0]&&t.$checkbox.click()}),t.$selectElement.on("change",e=>{this.setCurrentSelectedVariantValue(t),t.$checkbox.prop("checked",!0).trigger("change")}),t.$checkbox.on("change",e=>{t.$baseSelector[t.$checkbox.is(":checked")?"addClass":"removeClass"]("checked")})})}getBaseSelectors(){return this.baseSelectors}getFont(){return this.font}setFont(t){this.font=t}getCurrentSelectedVariantValue(t,e){return _.contains(e,t.selectedValue)?t.selectedValue:null}setCurrentSelectedVariantValue(t){t.selectedValue=t.$selectElement.val()}resetVariants(){let t=this.getFont(),e=t.getVariants(),n=e.map(e=>e.toString(t)),i=t.getDefaultVariant(),s=wp.template("select-options-list");_.each(this.getBaseSelectors(),a=>{let o=this.getCurrentSelectedVariantValue(a,n),r=e.map(e=>({value:e.toString(t),title:e.getNicename()}));!o&&i&&(a.selectedValue=o=i.toString(t)),a.$selectElement.html(s({optionsList:r,selected:o}))})}}const P={};let O=class extends Backbone.View{preinitialize(){this.template=wp.template("button-group-button")}initialize(t){this.model.on("change:checked",t=>{const e="button-primary",n="button-alt";this.$el.removeClass([e,n].join(" ")).addClass(t.isChecked()?e:n)}),this.render()}render(){this.setElement(this.template(this.model.attributes))}};_.extend(P,{Button_Group_Button:O});let G=class extends Backbone.View{preinitialize(){this.tagName="div",this.className="button-group"}initialize(t){t=_.defaults(t,{collection:null,classes:[],allowNone:!1,type:"checkbox",input:null}),this.collection=t.collection,this.allowNone=t.allowNone,this.isRadio="radio"===t.type,this.input=t.input,this.optionViews=[],t.classes.length&&this.$el.addClass(t.classes.join(" ")),this.render(),this.setupEvents()}render(){return this.$el.empty(),this.collection.forEach(t=>{let e=new P.Button_Group_Button({model:t});t.get("tooltip")&&"function"==typeof tippy&&tippy(e.$el[0],{content:t.get("tooltip")}),this.$el.append(e.el),this.optionViews.push(e)}),this.input&&(this.$input=t("<input>",{type:"hidden",name:this.input,value:this.getValue()}),this.$input.prependTo(this.$el)),this}setupEvents(){this.optionViews.forEach(t=>{t.$el.on("click",e=>{e.preventDefault(),this.setValue(t.model.id)})})}getValue(){let t=[];return this.optionViews.forEach(e=>{e.model.isChecked()&&t.push(e.model.id)}),this.isRadio?t[0]?t[0]:null:t}setValue(t,e=!1){let n=this.getValue();this.optionViews.forEach(e=>{if(t===e.model.id||_.contains(t,e.model.id)){let t=!0;this.allowNone&&(t=!e.model.isChecked()),this.isRadio&&this.optionViews.forEach(t=>{t.model.id!==e.model.id&&t.model.set("checked",!1)}),e.model.set("checked",t)}}),!t&&this.allowNone&&this.optionViews.forEach(t=>{t.model.set("checked",!1)});let i=this.getValue();!1===_.isEqual(n,i)&&(this.input&&this.$input.val(i),e||this.trigger("change",i))}};_.extend(P,{Button_Group:G});class j extends Backbone.View{preinitialize(){this.template=wp.template("size-unit-input")}initialize(t){t=_.defaults(t,{input:null,units:{},defaultUnit:null,value:null,min:null,max:null,step:"any"}),this.model=new Backbone.Model({value:null,unit:null}),this.input=t.input,this.units=t.units,this.defaultUnit=t.defaultUnit,this.value=t.value,this.min=t.min,this.max=t.max,this.step=t.step,this.model.set("unit",this.defaultUnit),this.render()}getValue(t){let e=this.model.toJSON();return t?[e.value,e.unit].join(""):e}setValue(t,e=!1){let n,i;if("string"==typeof t)for(let e in this.units){let s=t.match(new RegExp(`^(?<value>[0-9.]*)(?<unit>${e})$`));if(s){n=s.groups.value,i=s.groups.unit;break}}else t&&"object"==typeof t&&t.hasOwnProperty("value")&&t.hasOwnProperty("unit")&&(n=t.value,i=t.unit);this.$value.val(n),this.$unitSelect.val(i),this.renderUnitText(),this.updateModelValue(e)}render(){let e=t(this.template({value:this.value,units:this.units,min:this.min,max:this.max,step:this.step}));this.$value=e.find(".value-input"),this.$unitText=e.find(".unit-text"),this.$unitSelect=e.find(".units-select"),this.$unitSelect.val(this.model.get("unit")),this.input&&(this.$input=t("<input>",{type:"hidden",name:this.input,value:this.getValue(!0)}),this.$input.prependTo(e)),this.renderUnitText(),this.setElement(e),this.$value.on("input",()=>this.updateModelValue()),this.$unitSelect.on("change",()=>this.updateModelValue()),this.$unitSelect.on("change",()=>this.renderUnitText())}updateModelValue(t=!1){this.model.set({value:this.$value.val(),unit:this.$unitSelect.val()||this.$unitSelect.find("option:first-child").val()}),this.input&&this.$input.val(this.getValue(!0)),t||this.trigger("change",this.getValue())}renderUnitText(){this.$unitText.html(this.$unitSelect.find("option:selected").html())}}_.extend(P,{Size_Unit_Input:j});class M extends Backbone.View{preinitialize(){this.className="responsive-input"}initialize(t){this.model=new Backbone.Model({}),this.responsiveBreakpoints=t.responsiveBreakpoints,this.value=t.value,this.renderInput=t.renderInput,this.responsiveBreakpoints.forEach(t=>{let e=this.value?this.value[t.id]:null;this.model.set(t.id,e)}),this.render(),this.showCurrentBreakpointEntry(),this.responsiveBreakpoints.bind("change",()=>this.showCurrentBreakpointEntry()),this.model.on("change",()=>{this.trigger("change",this.getValue())})}showCurrentBreakpointEntry(){this.responsiveBreakpointElements.forEach(t=>{t.responsiveBreakpoint.isSelected()?t.$el.addClass("current"):t.$el.removeClass("current")})}getValue(){let t={};return this.responsiveBreakpoints.forEach(e=>{let n=e.id,i=this.getResponsiveValue(n),s=this.getInheritValue(e);t[n]=i||s}),t}updateValue(){_.each(this.getValue(),(t,e)=>{this.value[e]=t})}getResponsiveValue(t){return this.model.get(t)}setResponsiveValue(t,e){this.model.set(t,e),this.responsiveBreakpointElements.forEach(t=>{let e=t.responsiveBreakpoint;if(!this.getResponsiveValue(e.id)){let n=this.getInheritValue(e);t.inputView.trigger("inherit-value",n),this.updateValue()}})}getInheritValue(t){let e=t?t.get("inherit"):null;if(e){let t=this.getResponsiveValue(e);return t||this.getInheritValue(this.responsiveBreakpoints.findWhere({id:e}))}return null}render(){this.responsiveBreakpointElements=[],this.responsiveBreakpoints.forEach(e=>{let n=t("<div>",{class:["responsive-input-entry",`responsive-input-entry-${e.id}`].join(" ")}),i=e.id,s=this.renderInput(e,()=>this.getValue()[i],t=>this.setResponsiveValue(i,t));n.append(s.el),this.responsiveBreakpointElements.push({$el:n,inputView:s,responsiveBreakpoint:e}),n.appendTo(this.$el)})}}_.extend(P,{Responsive_Input:M});const q={};class J extends Backbone.Model{defaults(){return{id:"",name:"",icon:"",min_size:"",max_size:"",default:"",inherit:"",selected:!1}}initialize(t){t.default&&this.set("selected",!0)}isSelected(){return this.get("selected")}prepareForButtonGroup(){return{id:this.id,tooltip:this.get("name"),icon:this.get("icon"),checked:this.get("default")}}}_.extend(q,{Responsive_Breakpoint:J});class H extends Backbone.Collection{initialize(){this.model=J}}_.extend(q,{Responsive_Breakpoints:H});let K=class extends Backbone.Model{defaults(){return{selectors:"",fontVariant:"",textTransform:{},fontSize:{},lineHeight:{},letterSpacing:{}}}initialize(t){q.Custom_Selector.hasOwnProperty("instanceIterator")||(q.Custom_Selector.instanceIterator=0),q.Custom_Selector.instanceIterator++,this.set("id",`custom-selector-${q.Custom_Selector.instanceIterator}`)}};_.extend(q,{Custom_Selector:K});let W=class extends Backbone.Collection{initialize(t){this.model=K}};_.extend(q,{Custom_Selectors:W});class Q extends Backbone.Model{defaults(){return{id:null,text:"",tooltip:"",icon:"",active:!1}}isChecked(){return this.has("checked")&&this.get("checked")}}_.extend(q,{Button_Group_Button:Q});class X extends Backbone.Collection{preinitialize(t,e){this.model=Q}}_.extend(q,{Button_Group:X});let Y=class extends Backbone.Model{defaults(){return{id:"",groupId:"",title:"",value:null}}getValue(t="",e=null){let n=this.get("value");return n&&(n=t?n.get(t):n.attributes),n||(n=e),n}};_.extend(q,{Font_Appearance_Element:Y});class Z extends Backbone.Collection{initialize(t){this.model=Y}modelId(t){return t.group_id+"_"+t.id}}_.extend(q,{Font_Appearance_Elements:Z});let tt=class extends Backbone.Model{defaults(){return{id:"",name:"",elements:{}}}preinitialize(t){let e=t.id;t.elements=new q.Font_Appearance_Elements(_.map(t.elements,(t,n)=>({id:n,groupId:e,...t})))}getElements(){return this.get("elements")}};_.extend(q,{Font_Appearance_Group:tt});class et extends Backbone.Collection{preinitialize(){this.model=tt}}_.extend(q,{Font_Appearance_Groups:et});class nt extends Backbone.Model{defaults(){return{id:"",groupId:"",fontSize:{},lineHeight:{},letterSpacing:{},textTransform:{}}}}_.extend(q,{Font_Appearance_Element_Value:nt});class it extends Backbone.Collection{preinitialize(){this.model=nt}}_.extend(q,{Font_Appearance_Element_Values:it});class st extends Backbone.View{preinitialize(){this.template=wp.template("custom-selector"),this.events={"click .remove-custom-selector":"remove"}}initialize(t){t=_.defaults(t,{customSelectorsInstance:null}),this.customSelectorsInstance=t.customSelectorsInstance,this.render()}getResponsiveBreakpoints(){return this.customSelectorsInstance.responsiveBreakpoints}getPredefinedSelectors(){return this.customSelectorsInstance.predefinedSelectors}filterOtherSelectors(t){let e=[],n=_.pluck(this.getPredefinedSelectors(),"value");return _.each(t,t=>{_.contains(n,t)||e.push({value:t,name:t})}),e}getCurrentFont(){return this.customSelectorsInstance.currentFont}getFontVariantsOptions(){if(!this.getCurrentFont())return null;let t=this.getCurrentFont().getVariants().map(t=>({value:t.toString(),title:t.getNicename()}));return wp.template("select-options-list")({optionsList:[{value:"",title:"- Inherit -"},...t],selected:this.model.get("fontVariant")})}remove(t){t.preventDefault(),this.customSelectorsInstance.collection.remove(this.model)}render(){let e=t(this.template(this.model.toJSON())),n=this.model,i=n.id,s=n.get("selectors"),a=n.get("fontVariant"),o=n.get("textTransform"),r=n.get("fontSize"),l=n.get("lineHeight"),c=n.get("letterSpacing"),h=(t,e)=>`font_custom_selectors[${i}][${t}]`+(e?`[${e}]`:""),u=t(wp.template("custom-selectors-input")({inputName:h("selectors")+"[]",predefinedSelectors:[...this.getPredefinedSelectors(),...this.filterOtherSelectors(s)]}));s&&u.val(s),e.find(".column-selectors").append(u);let m=t("<select>",{name:h("variant"),class:"font-variant-select"});m.html(this.getFontVariantsOptions()),e.find(".column-font-variant").append(m);let v=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:o,renderInput:(t,e,n)=>{let i=new P.Button_Group({allowNone:!0,type:"radio",collection:new q.Button_Group([new q.Button_Group_Button({id:"uppercase",text:"TT",tooltip:"Uppercase"}),new q.Button_Group_Button({id:"capitalize",text:"Tt",tooltip:"Capitalize"}),new q.Button_Group_Button({id:"lowercase",text:"tt",tooltip:"Lowercase"})]),input:h("text_transform",t.id)});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",t=>n(t)),i}});e.find(".column-font-case").append(v.el);let y=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:r,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:h("font_size",t.id),units:p,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-font-size").append(y.el);let w=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:l,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:h("line_height",t.id),units:d,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-line-height").append(w.el);let _=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:c,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:h("letter_spacing",t.id),units:f,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-letter-spacing").append(_.el),this.setElement(e),u.select2({tags:!0,placeholder:"Choose from predefined or add your own CSS selectors"}),u.on("change",t=>{u.children().each((t,e)=>{let n=e.value.split(",");1<n.length&&(n.forEach(t=>{t=t.trim();let e=new Option(t,t,!0,!0);u.append(e)}),e.remove())})}),this.customSelectorsInstance.on("variants-updated",()=>{m.html(this.getFontVariantsOptions(a))}),u.on("change",t=>{n.set("selectors",u.val())}),m.on("change",t=>{n.set("fontVariant",m.val())}),v.on("change",t=>{n.set("textTransform",t)}),y.on("change",t=>{n.set("fontSize",t)}),w.on("change",t=>{n.set("lineHeight",t)}),_.on("change",t=>{n.set("letterSpacing",t)})}}_.extend(P,{Custom_Selector:st});class at extends Backbone.View{preinitialize(){this.el=t(".font-custom-selectors"),this.events={"click #add-new-selector":"addNewSelector"},this.customSelectorViews=[]}initialize(t){t=_.defaults(t,{responsiveBreakpoints:null,predefinedSelectors:null,collection:null,currentFont:null}),this.collection=t.collection,this.responsiveBreakpoints=t.responsiveBreakpoints,this.predefinedSelectors=t.predefinedSelectors,this.currentFont=t.currentFont,this.$tbody=this.$el.find("tbody"),this.render(),this.collection.comparator="index",this.$tbody.sortable({axis:"y",handle:".column-sort a",update:t=>{this.$tbody.children().each((t,e)=>{this.collection.at(e.index).set("index",t)}),this.collection.sort()}}),this.collection.bind("add",()=>this.render()),this.collection.bind("remove",()=>this.render()),this.collection.bind("reset",()=>this.render())}getCurrentResponsiveBreakpont(){for(let t of this.responsiveBreakpoints)if(t.isSelected())return t;return this.responsiveBreakpoints.at(0)}addNewSelector(t){t.preventDefault(),this.collection.add(new q.Custom_Selector({})),this.resetIndexes()}resetIndexes(){this.collection.forEach((t,e)=>{t.set("index",e)})}render(){if(this.customSelectorViews=[],this.$tbody.empty(),this.collection.forEach((t,e)=>{const n=new P.Custom_Selector({model:t,customSelectorsInstance:this});n.el.index=e,this.$tbody.append(n.el),this.customSelectorViews.push(n)}),this.resetIndexes(),0===this.collection.length){const t=wp.template("custom-selector-empty");this.$tbody.append(t())}}}_.extend(P,{Custom_Selectors:at});class ot extends Backbone.View{initialize(t){t=_.defaults(t,{responsiveBreakpoints:null}),this.responsiveBreakpoints=t.responsiveBreakpoints,this.render()}getGroupId(){return this.model.id}render(){this.setElement(t(`.font-appearance-group[data-group-id="${this.getGroupId()}"]`)),this.$tbody=this.$el.find(".typolab-table tbody"),this.$tbody.empty(),this.model.getElements().forEach(t=>{let e=new P.Font_Appearance_Element({model:t,fontAppearanceGroupInstance:this});this.$tbody.append(e.el)})}}_.extend(P,{Font_Appearance_Group:ot});class rt extends Backbone.View{preinitialize(){this.template=wp.template("font-appearance-element")}initialize(t){t=_.defaults(t,{fontAppearanceGroupInstance:null}),this.fontAppearanceGroupInstance=t.fontAppearanceGroupInstance,this.render()}getGroupId(){return this.fontAppearanceGroupInstance.getGroupId()}getResponsiveBreakpoints(){return this.fontAppearanceGroupInstance.responsiveBreakpoints}render(){let e=t(this.template(this.model.toJSON())),n=this.model,i=n.id,s=n.getValue("fontSize",{}),a=n.getValue("lineHeight",{}),o=n.getValue("letterSpacing",{}),r=n.getValue("textTransform",{}),l=(t,e)=>`font_appearance_groups[${this.getGroupId()}][${i}][${t}]`+(e?`[${e}]`:""),c=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:s,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:l("font_size",t.id),units:p,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-font-size").append(c.el);let h=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:a,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:l("line_height",t.id),units:d,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-line-height").append(h.el);let u=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:o,renderInput:(t,e,n)=>{let i=new P.Size_Unit_Input({input:l("letter_spacing",t.id),units:f,defaultUnit:g,min:0});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",()=>{n(i.getValue(!0))}),i}});e.find(".column-letter-spacing").append(u.el);let m=new P.Responsive_Input({responsiveBreakpoints:this.getResponsiveBreakpoints(),value:r,renderInput:(t,e,n)=>{let i=new P.Button_Group({allowNone:!0,type:"radio",collection:new q.Button_Group([new q.Button_Group_Button({id:"uppercase",text:"TT",tooltip:"Uppercase"}),new q.Button_Group_Button({id:"capitalize",text:"Tt",tooltip:"Capitalize"}),new q.Button_Group_Button({id:"lowercase",text:"tt",tooltip:"Lowercase"})]),input:l("text_transform",t.id)});return null!==e()&&i.setValue(e()),i.on("inherit-value",t=>{i.setValue(t,!0)}),i.on("change",t=>n(t)),i}});e.find(".column-font-case").append(m.el),this.setElement(e),this.$el.on("click",".column-element label",t=>{e.find(".column-font-size .value-input").focus()})}}_.extend(P,{Font_Appearance_Element:rt});class lt{constructor({customSelectorsContainer:e,customSelectors:n,font:i}){this.$customSelectorsContainer=t(e),this.responsiveBreakpoints=new q.Responsive_Breakpoints(_.map(n.responsive,(t,e)=>({id:e,...t}))),this.customSelectors=new q.Custom_Selectors(_.map(n.values,t=>({selectors:t.selectors,fontVariant:t.variant,textTransform:t.text_transform,fontSize:t.font_size,lineHeight:t.line_height,letterSpacing:t.letter_spacing}))),this.predefinedSelectors=_.map(n.predefined_selectors,(t,e)=>({...t,value:`:${e}:`})),this.font=i,this.init()}init(){let t=new q.Button_Group(this.responsiveBreakpoints.map(t=>t.prepareForButtonGroup()));this.responsiveBreakpointsButtons=new P.Button_Group({collection:t,classes:["responsive-devices"],type:"radio"}),this.responsiveBreakpointsButtons.on("change",t=>this.responsiveBreakpoints.forEach(e=>{let n=t===e.id,i=`font-custom-selectors--${e.id}`;this.$customSelectorsContainer[n?"addClass":"removeClass"](i),e.set("selected",n)})),this.$customSelectorsContainer.prepend(this.responsiveBreakpointsButtons.el),this.customSelectorsTable=new P.Custom_Selectors({responsiveBreakpoints:this.responsiveBreakpoints,predefinedSelectors:this.predefinedSelectors,collection:this.customSelectors,currentFont:this.font})}getFont(){return this.font}setFont(t){this.font=t}resetVariants(){this.customSelectorsTable.currentFont=this.getFont(),this.customSelectorsTable.trigger("variants-updated")}}class ct{constructor(){this.selectedFont,this.init(),ct.trigger("ready",this)}init(){let t=document.querySelector(".fonts-list-select"),n=this.parseJSON("font_selector_fonts_list");if(t){let e=new x({fontListSelectContainer:t,fontListSelectOptions:n});e.on("font-select",t=>this.setSelectedFont(t)),this.setSelectedFont(e.getSelectedFont())}let i=document.querySelector(".font-face-variants"),s=this.parseJSON("font_face_variants"),a=document.querySelector("#font_family");if(a&&i){s.length||s.push(new e);let t=new B({fontFamilyNameInput:a,fontVariantsContainer:i,fontVariants:s});t.on("variant-updated",t=>this.variantsUpdated()),this.setSelectedFont(t.getFont())}let o=document.querySelector("#stylesheet_url");if(o&&i){let t=new A({stylesheetUrlInput:o,fontVariantsContainer:i,fontVariants:s});t.on("variant-updated",t=>this.variantsUpdated()),this.setSelectedFont(t.getFont())}let r=document.querySelector(".font-base-selectors"),l=this.parseJSON("font_base_selectors");if(r&&l){let t=new D({fontBaseSelectorsContainer:r,fontBaseSelectors:l,font:this.getSelectedFont()});ct.on("font-variants-updated",e=>{t.setFont(this.getSelectedFont()),t.resetVariants()})}let c=document.querySelector(".font-custom-selectors"),h=this.parseJSON("font_custom_selectors");if(c&&h){let t=new lt({customSelectorsContainer:c,customSelectors:h,font:this.getSelectedFont()});ct.on("font-variants-updated",e=>{t.setFont(this.getSelectedFont()),t.resetVariants()})}let u=document.querySelector(".font-conditional-loading"),p=this.parseJSON("conditional_statements");u&&p&&new U({conditionalStatementsContainer:u,conditionalStatements:p})}getSelectedFont(){return this.selectedFont}setSelectedFont(t){t&&(this.selectedFont=t,this.selectedFont.off("variants-updated"),this.selectedFont.on("variants-updated",()=>this.variantsUpdated()))}variantsUpdated(){let t=this.getSelectedFont();t&&ct.trigger("font-variants-updated",t.getVariants())}parseJSON(t,e=null){return ct.parseJSON(t,e)}}_.extend(ct,Backbone.Events),ct.parseJSON=function(t,e=null){let n=document.querySelector(`#${t}`);if(n){let t=JSON.parse(n.innerHTML);if(t)return t}return e},ct.on("ready",function(){let e=t('.typolab .button-primary[type="submit"]');if(e.each((n,i)=>{t(i).closest("form").on("submit",t=>{e.addClass("is-loading")})}),t(".typolab .components-form-toggle").each((e,n)=>{let i=t(n),s=i.find("input");s.on("change",t=>{i[s.is(":checked")?"addClass":"removeClass"]("is-checked")})}),t(".change-source").length){let e=t(".change-source"),n=t(".typolab-dropdown.font-source-select"),i=()=>{let t=e.position();t.top+=e.outerHeight()+10,n.css(t)};i(),e.on("click",t=>{t.preventDefault(),i(),n.add(e).toggleClass("visible")}),t(document).on("mouseup",t=>{n.hasClass("visible")&&(e.is(t.target)||n.is(t.target)||n.has(t.target).length||n.add(e).removeClass("visible"))}),n.on("click","a",t=>{confirm("Confirm font source change?")?n.add(e).removeClass("visible"):t.preventDefault()})}}),ct.on("ready",function(){let e=t(".typolab-select-font-source");if(e.length){let n=e.find("tbody tr"),i=function(e){t(".font-source-description").removeClass("selected").filter(".font-source-description-"+e).addClass("selected")};n.on("click",function(){let e=t(this).find('input[type="radio"]'),s=e.val();n.removeClass("hover"),e.prop("checked",!0),t(this).addClass("hover"),i(s)});let s=n.find("input:checked");s.closest("tr").addClass("hover"),i(s.val())}}),ct.on("ready",function(){let e=t(".typolab-fonts-list"),n=e.find("table.fonts");e.length&&(n.on("click",".delete a",t=>{confirm("Are you sure you want to delete this font?")||t.preventDefault()}),n.on("click",".flush a",t=>{confirm("Confirm font reinstall?\nThis will download font files again and create new stylesheet file.")||t.preventDefault()}),e.on("submit",t=>{let n=e.find(".check-column input:checked").map((t,e)=>e.value);0<n.length&&"delete"===e.find('select[name="action"]').val()&&!confirm("Are you sure you want to delete selected fonts?")&&t.preventDefault(),0<n.length&&"flush"===e.find('select[name="action"]').val()&&!confirm("Confirm fonts reinstall?\nThis will download font files again and create new stylesheet file for each font.")&&t.preventDefault()}))}),ct.on("ready",function(){let e=t("#edit-font-form");if(e.length){let t=e.find("#typolab-toggle-advanced-options"),n=e.find("#typolab-advanced-options");t.on("click",e=>{e.preventDefault(),n.add(t).toggleClass("visible")});let i=e.find("#font_status"),s=()=>{let t=i.closest(".grouped-input");t.removeClass("red green"),"active"===i.val()?t.addClass("green"):t.addClass("red")};s(),i.on("change",s)}});class ht{constructor({fontAppearance:t}){this.fontAppearanceGroups=new q.Font_Appearance_Groups(t.groups),this.responsiveBreakpoints=new q.Responsive_Breakpoints(_.map(t.responsive,(t,e)=>({id:e,...t}))),this.values=new q.Font_Appearance_Element_Values(_.map(t.values,t=>({id:t.id,groupId:t.group_id,fontSize:t.font_size,lineHeight:t.line_height,letterSpacing:t.letter_spacing,textTransform:t.text_transform}))),this.init()}getResponsiveBreakpoints(){return new q.Responsive_Breakpoints(this.responsiveBreakpoints.toJSON())}init(){this.assignElementValues(),this.fontAppearanceGroups.forEach(t=>{let e=this.getResponsiveBreakpoints(),n=new q.Button_Group(e.map(t=>t.prepareForButtonGroup())),i=new P.Button_Group({collection:n,classes:["responsive-devices"],type:"radio"}),s=new P.Font_Appearance_Group({responsiveBreakpoints:e,model:t});i.on("change",t=>e.forEach(e=>{let n=t===e.id,i=`font-appearance-group--${e.id}`;s.$el[n?"addClass":"removeClass"](i),e.set("selected",n)})),s.$el.find("tr.heading th").append(i.el)})}assignElementValues(){this.fontAppearanceGroups.forEach(t=>{t.getElements().forEach(t=>this.assignElementValue(t))})}assignElementValue(t){let e=this.values.where({id:t.get("id"),groupId:t.get("groupId")});1===e.length&&t.set("value",e[0])}}ct.on("ready",function(){let t=ct.parseJSON("font_appearance");t&&new ht({fontAppearance:t})}),ct.on("ready",function(){if(t(".typolab #typolab-settings-form").length){let e=t(".font-export-import"),n=e.find(".font-export-import--export"),i=e.find(".font-export-import--import"),s=()=>{let t={};return n.find('[name="font_export"]').each((e,n)=>{t[n.value]=n.checked?1:0}),t};n.on("click",".button",e=>{e.preventDefault();let i=t(e.currentTarget),a=n.find("tbody"),o=n.find(".font-export-checkboxes"),r=n.find(".font-export-loading"),l=n.find(".font-export-data"),c=l.find("#font_export_data");l.on("focus","textarea",t=>{t.target.select()}),i.addClass("disabled"),a.css("height",a.height()),o.hide(),r.fadeTo(300,1),t.post(ajaxurl,{action:"typolab_export",exports:s()}).done(t=>{t.success?(c.val(t.data),a.css("height",""),r.hide(),l.fadeTo(300,1,()=>c.select()),navigator.clipboard.writeText(t.data)):alert("An error occurred while exporting fonts!")})}),i.on("click",".button",e=>{e.preventDefault();let n=t(e.currentTarget),s=i.find("tbody"),a=i.find(".font-import-data"),o=i.find("#font_import"),r=i.find(".font-import-loading"),l=r.find(".progress"),c=i.find(".font-import-finished"),h=0,u=0;const p=(e,n)=>{let i=n.hasOwnProperty(e);return("install_fonts"===e&&n.fonts||"preload_fonts"===e&&n.fonts)&&(i=!0),i&&h++,function(){return new Promise((s,a)=>{i?t.post(ajaxurl,{action:"typolab_import",type:e,data:JSON.stringify(n[e])}).done(s).fail(a).always(()=>{let t=u/h*100,e=++u/h*100;((t,e,n,i,s="",a="")=>{let o=null;const r=l=>{o||(o=l);const c=Math.min((l-o)/i,1);t.innerHTML=s+Math.floor(c*(n-e)+e)+a,c<1&&window.requestAnimationFrame(r)};window.requestAnimationFrame(r)})(l[0],t,e,200,"(","%)")}):s()})}};try{const t=JSON.parse(o.val());n.addClass("disabled"),s.css("height",s.height()),a.hide(),r.fadeTo(300,1),(t=>new Promise((e,n)=>{let i=p("font_settings",t),s=p("font_appearance",t),a=p("fonts",t),o=p("install_fonts",t),r=p("preload_fonts",t);i().then(s).then(a).then(o).then(r).then(e)}))(t).then(()=>setTimeout(()=>{s.css("height",""),r.hide(),c.fadeTo(300,1)},1e3))}catch(t){alert("Please enter valid JSON data")}})}}),document.addEventListener("DOMContentLoaded",()=>{new ct})}();
