<?php
/**
 * Kalium WordPress Theme
 *
 * Post Page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_post_types_blog_post',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Post Page',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'single' ),
	]
);

/**
 * Section: Post Page.
 */

// Section
kalium_customize_register_section(
	'single',
	[
		'title' => 'Post Page',
	]
);

// Layout
kalium_customize_register_control(
	'blog_post_layout',
	[
		'type'        => 'kalium-radio-image',
		'label'       => 'Layout',
		'reset'       => true,
		'choices'     => [
			'narrow'        => [
				'label' => 'Narrow',
				'image' => kalium()->assets_url( 'admin/images/theme-options/post-layout-narrow.svg' ),
			],
			'normal'        => [
				'label' => 'Normal',
				'image' => kalium()->assets_url( 'admin/images/theme-options/post-layout-normal.svg' ),
			],
			'sidebar-left'  => [
				'label' => 'Sidebar Left',
				'image' => kalium()->assets_url( 'admin/images/theme-options/post-layout-sidebar-left.svg' ),
			],
			'sidebar-right' => [
				'label' => 'Sidebar Right',
				'image' => kalium()->assets_url( 'admin/images/theme-options/post-layout-sidebar-right.svg' ),
			],
		],
		'show_labels' => false,
		'tooltips'    => true,
	]
);

// Narrow Container Width
kalium_customize_register_control(
	'blog_post_narrow_container_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Narrow Width',
		'reset'            => true,
		'min'              => 600,
		'max'              => 900,
		'placeholder'      => 750,
		'initial_position' => 750,
		'units'            => kalium_get_default_units(
			[
				'px',
				'%' => [
					'min' => 30,
					'max' => 60,
				],
			]
		),
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'blog_post_layout' => 'narrow',
		],
	]
);

// Wide alignment offset
kalium_customize_register_control(
	'blog_post_wide_align_offset',
	[
		'type'             => 'kalium-range',
		'label'            => 'Wide Alignment Offset',
		'description'      => 'This option will apply only to those elements that have wide alignment option.',
		'reset'            => true,
		'min'              => 20,
		'max'              => 200,
		'placeholder'      => 120,
		'initial_position' => 120,
		'units'            => kalium_get_default_units( [ 'px' ] ),
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'blog_post_layout' => [
				'narrow',
				'normal',
			],
		],
	]
);

// Sidebar Widgets
kalium_customize_register_control(
	'_kalium_blog_post_sidebar_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Sidebar Widgets',
		'section_link' => kalium()->customize->section_id( 'widgets', false ),
		'dependency'   => [
			'blog_post_layout' => [
				'sidebar-left',
				'sidebar-right',
			],
		],
	]
);

// Featured image
kalium_customize_register_control(
	'blog_single_thumbnails',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Post Options',
		'label'         => 'Featured Image',
		'separator'     => true,
		'default'       => true,
		'section_link'  => kalium()->customize->section_id( 'featured_image' ),
	]
);

// Post title
kalium_customize_register_control(
	'blog_single_title',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Title',
		'default' => true,
	]
);

// Post Meta
kalium_customize_register_control(
	'blog_single_post_meta',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Post Meta',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'post_meta' ),
	]
);

// Social Sharing
kalium_customize_register_control(
	'blog_post_social_share',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Social Sharing',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'social_sharing' ),
	]
);

// Author Box
kalium_customize_register_control(
	'blog_author_info',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Author Box',
		'reset'        => true,
		'section_link' => kalium()->customize->section_id( 'author_info' ),
	]
);

// Post Navigation
kalium_customize_register_control(
	'blog_post_navigation',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Navigation',
		'help'         => 'Allow Next/Previous buttons to navigate through posts.',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'navigation' ),
	]
);

// Comments
kalium_customize_register_control(
	'blog_comments',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Comments',
		'help'    => 'Allow visitors to leave comments and show comments on your posts.',
		'default' => true,
	]
);

// Related Posts
kalium_customize_register_control(
	'blog_related_posts',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Page Elements',
		'label'         => 'Related Posts',
		'separator'     => true,
		'section_link'  => kalium()->customize->section_id( 'related_posts' ),
	]
);

/**
 * Subsection: Featured Image.
 */

// Subsection: Featured image
kalium_customize_register_section(
	'featured_image',
	[
		'title' => 'Featured Image',
	]
);

// General tab
kalium_customize_general_tab();

// Featured image placement
kalium_customize_register_control(
	'blog_featured_image_placement',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Layout',
		'choices'       => [
			'container'      => [
				'label' => 'Boxed',
				'image' => kalium()->assets_url( 'admin/images/theme-options/featured-image-boxed.svg' ),
			],
			'container-wide' => [
				'label'      => 'Wide',
				'image'      => kalium()->assets_url( 'admin/images/theme-options/featured-image-wide.svg' ),
				'dependency' => [
					'blog_post_layout' => [
						'narrow',
						'normal',
					],
				],
			],
			'full-width'     => [
				'label' => 'Full Width',
				'image' => kalium()->assets_url( 'admin/images/theme-options/featured-image-full.svg' ),
			],
		],
		'aspect_ratio'  => '207:154',
		'columns'       => 'auto',
	]
);

// Show above
kalium_customize_register_control(
	'blog_featured_image_sidebar_below',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Sidebar Below',
		'dependency' => [
			'blog_post_layout'              => [
				'sidebar-left',
				'sidebar-right',
			],
			'blog_featured_image_placement' => [
				'value'   => 'full-width',
				'compare' => '!=',
			],
		],
	]
);

// Image size
kalium()->customize->register_image_size_settings(
	'blog_featured_image',
	[
		'default' => 'large',
	]
);

// Aspect ratio
kalium()->customize->register_aspect_ratio_settings( 'blog_featured_image' );

// Gallery Auto Play
kalium_customize_register_control(
	'blog_gallery_autoswitch',
	[
		'type'           => 'kalium-text',
		'label'          => 'Gallery Auto Play',
		'separator'      => true,
		'separator_type' => 3,
		'input_style'    => 'width: 80px',
		'input_type'     => 'number',
		'min'            => 1,
		'max'            => 100,
		'suffix'         => 's',
		'help'           => 'Auto-switch interval for gallery images',
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Image style
kalium()->customize->register_style_settings(
	'blog_featured_image',
	[
		'settings'              => [
			'border_radius',
		],
		'setting_border_radius' => [
			'default' => [
				'link' => true,
			],
		],
		'css_var_prefix'        => 'pi',
		'css_selector'          => '.single-post .post-image',
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Post meta.
 */

// Subsection: Post Meta
kalium_customize_register_section(
	'post_meta',
	[
		'title' => 'Post Meta',
	]
);

// Post Date
kalium_customize_register_control(
	'blog_post_date_single',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Date',
		'default' => true,
	]
);

// Post Category
kalium_customize_register_control(
	'blog_category_single',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Category',
		'default' => true,
	]
);

// Post tags
kalium_customize_register_control(
	'blog_tags',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Tags',
		'default' => true,
	]
);

// Icon
kalium_customize_register_control(
	'blog_single_post_meta_icon',
	[
		'type'           => 'kalium-toggle',
		'label'          => 'Display Icon',
		'separator'      => true,
		'separator_type' => 3,
		'default'        => true,
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Related posts.
 */

// Subsection: Related Posts
kalium_customize_register_section(
	'related_posts',
	[
		'title' => 'Related Posts',
	]
);

// General tab
kalium_customize_general_tab();

// Criteria
kalium_customize_register_control(
	'blog_related_posts_criteria',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Posts',
		'label'         => 'Relate Group',
		'input_style'   => 'width:120px',
		'reset'         => true,
		'choices'       => [
			'any'      => 'Any',
			'category' => 'Category',
			'tag'      => 'Tag',
		],
		'default'       => 'category',
	]
);

// Posts Count
kalium_customize_register_control(
	'blog_related_posts_per_page',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Posts to Show',
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 12,
		'default'     => 3,
	]
);

// Columns
kalium_customize_register_control(
	'blog_related_posts_columns',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Columns',
		'responsive'  => true,
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 4,
		'default'     => [
			'desktop' => 3,
			'tablet'  => 2,
			'mobile'  => 1,
		],
	]
);

// Post Description and Meta
kalium_customize_register_control(
	'blog_related_posts_details',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Post Meta',
	]
);

// Inherit container
kalium_customize_register_control(
	'blog_related_posts_inherit_container',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Container',
		'label'         => 'Inherit Container Size',
		'separator'     => true,
		'default'       => true,
	]
);

// Title
kalium_customize_register_control(
	'blog_related_posts_title',
	[
		'type'        => 'kalium-text',
		'label'       => 'Title',
		'input_style' => 'width: 120px',
		'default'     => __( 'Related posts', 'kalium' ),
	]
);

// Visibility
kalium_customize_register_control(
	'blog_related_posts_visibility',
	[
		'type'    => 'kalium-checkbox-button',
		'label'   => 'Visibility',
		'reset'   => true,
		'choices' => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'default' => [
			'desktop',
			'tablet',
			'mobile',
		],
	]
);

// End general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Style settings
kalium()->customize->register_style_settings(
	'blog_related_posts',
	[
		'settings'          => [
			'bg',
			'vpadding',
		],
		'css_var_prefix'    => 'related-posts',
		'css_selector'      => '.related-posts',
		'add_padding_class' => true,
	]
);

// End style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Social Sharing.
 */

// Subsection: Social Sharing
kalium_customize_register_section(
	'social_sharing',
	[
		'title' => 'Social Sharing',
	]
);

// Layout
kalium_customize_register_control(
	'blog_post_social_share_style',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Style',
		'choices' => [
			'plain' => 'Labels',
			'icons' => 'Icons',
		],
		'default' => 'icons',
	]
);

// Share Networks
kalium_customize_register_control(
	'blog_post_social_share_networks',
	[
		'type'            => 'laborator-builder',
		'label'           => 'Share Networks',
		'separator'       => true,
		'separator_type'  => 3,
		'content_type_id' => 'social_share_networks',
		'default'         => static function () {
			return laborator_builder_get_content_type( 'social_share_networks' )->get_default_content();
		},
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Author Info
 */

// Subsection: Author Info
kalium_customize_register_section(
	'author_info',
	[
		'title' => 'Author Info',
	]
);

// General tab
kalium_customize_general_tab();

// Author Image
kalium_customize_register_control(
	'blog_author_info_avatar',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Author Avatar',
		'default' => true,
	]
);

// Author Description
kalium_customize_register_control(
	'blog_author_info_description',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Author Description',
		'default' => true,
	]
);

// End general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Author box style settings
kalium()->customize->register_style_settings(
	'blog_author_info',
	[
		'css_selector'      => '.entry-author',
		'css_var_prefix'    => 'author',
		'add_padding_class' => true,
		'setting_text'      => [
			'default' => kalium_color_reference( 'theme_colors_text.normal' ),
		],
		'setting_headings'  => [
			'default' => kalium_color_reference( 'theme_colors_headings' ),
		],
		'setting_link'      => [
			'default' => [
				'normal' => kalium_color_reference( 'theme_colors_link.normal' ),
				'hover'  => kalium_color_reference( 'theme_colors_link.hover' ),
			],
		],
	]
);

// End style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Navigation.
 */

// Section start
kalium_customize_register_section(
	'navigation',
	[
		'title' => 'Navigation',
	]
);

// Post Navigation settings
kalium()->customize->register_post_navigation_settings(
	'blog_post_navigation',
	[
		'post_type'    => 'post',
		'layout_types' => [
			'type-1',
			'type-2',
			'type-3',
		],
		'defaults'     => [
			'subtitle_position' => 'below',
		],
	]
);

// End section
kalium_customize_end_section();

// End of parent section (kalium_post_types_blog_post)
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Narrow width
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'blog_post_layout',
			'blog_post_narrow_container_width',
			'blog_post_wide_align_offset',
		],
		'content' => '
        :root {
            <# if ( "narrow" === data.blog_post_layout && data.blog_post_narrow_container_width ) { #>
                {{ data.api.cssVarName( "content-narrow-width" ) }}: {{ data.blog_post_narrow_container_width }};
            <# } #>
            
            <# if ( data.blog_post_wide_align_offset ) { #>
                {{ data.api.cssVarName( "wide-align-offset" ) }}: {{ data.blog_post_wide_align_offset }};
            <# } #>
        }
		',
	]
);

// Aspect ratio
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'blog_featured_image_aspect_ratio',
			'blog_featured_image_aspect_ratio_custom',
		],
		'content' => <<<EOD
{{{ data.api.printInlineStyle( {
	selector: '.single-post .post-image',
	varName: 'custom-aspect-ratio',
	value: data.blog_featured_image_aspect_ratio,
	parser: function( value ) {
		if ( 'custom' === value ) {
			return data.api.currentResponsiveValue( data.blog_featured_image_aspect_ratio_custom );
		}
		
		return 'auto' === value ? null : value;
	},
} ) }}}
EOD,
	]
);
