<?php
/**
 * Kalium WordPress Theme
 *
 * Custom JavaScript.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_general_custom_js',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Custom JavaScript',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'custom_js' ),
	]
);

/**
 * Section: Custom JavaScript.
 */

// Section
kalium_customize_register_section(
	'custom_js',
	[
		'title' => 'Custom JavaScript',
	]
);

// Header JavaScript
kalium_customize_register_control(
	'user_custom_js_head',
	[
		'type'      => 'kalium-textarea',
		'label'     => 'Header JavaScript',
		'help'      => 'Accepts JavaScript code and HTML markup that is valid inside the &lt;/head&gt; tag.',
		'rows'      => 7,
		'monospace' => true,
	]
);

// Footer JavaScript
kalium_customize_register_control(
	'user_custom_js',
	[
		'type'      => 'kalium-textarea',
		'label'     => 'Footer JavaScript',
		'help'      => 'Accepts JavaScript code and HTML markup that is valid inside the &lt;/body&gt; tag.',
		'rows'      => 7,
		'monospace' => true,
	]
);

// End of current section
kalium_customize_end_section();
