<?php
/**
 * Kalium WordPress Theme
 *
 * Integrations.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_general_integrations',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Integrations',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'integrations' ),
	]
);

/**
 * Section: Integrations.
 */

// Section
kalium_customize_register_section(
	'integrations',
	[
		'title' => 'Integrations',
	]
);

// Google Maps API Key
kalium_customize_register_control(
	'google_maps_api',
	[
		'type'         => 'kalium-text',
		'label'        => 'Google Maps API Key',
		'inline_label' => false,
		'help'         => 'Google requires a unique API key for each website that wants to show Google Maps. Learn how to <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">generate a Google API Key</a>.',
	]
);

// End of current section
kalium_customize_end_section();
