<?php
/**
 * Kalium WordPress Theme
 *
 * Lightbox.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Section link control
kalium_customize_register_control(
	'kalium_general_lightbox',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Lightbox',
		'priority'     => kalium()->customize->get_next_priority(),
		'section_link' => kalium()->customize->section_id( 'lightbox' ),
	]
);

/**
 * Section: Lightbox Settings.
 */

// Section
kalium_customize_register_section(
	'lightbox',
	[
		'title' => 'Lightbox Settings',
	]
);

// Lightbox Skin
kalium_customize_register_control(
	'lightbox_color_scheme',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Color Scheme',
		'choices' => [
			'dark'  => 'Dark',
			'light' => 'Light',
		],
	]
);

// Backdrop image
kalium_customize_register_control(
	'lightbox_backdrop_image',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Blurred Backdrop Image',
		'default' => false,
	]
);

// Captions
kalium_customize_register_control(
	'lightbox_captions',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'General Settings',
		'label'         => 'Captions',
		'separator'     => true,
		'default'       => true,
	]
);

// Fullscreen
kalium_customize_register_control(
	'lightbox_fullscreen',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Fullscreen Toggle',
		'default' => true,
	]
);

// Download
kalium_customize_register_control(
	'lightbox_download',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Download',
	]
);

// Counter
kalium_customize_register_control(
	'lightbox_counter',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Counter',
		'default' => true,
	]
);

// Hide Controls Delay
kalium_customize_register_control(
	'lightbox_hide_controls',
	[
		'type'        => 'kalium-text',
		'label'       => 'Hide Controls Delay',
		'input_type'  => 'number',
		'input_style' => 'width:80px',
		'placeholder' => 3,
		'min'         => 0,
		'suffix'      => 's',
	]
);

// Thumbnails
kalium_customize_register_control(
	'lightbox_thumbnails',
	[
		'type'      => 'kalium-toggle',
		'label'     => 'Thumbnails',
		'separator' => true,
		'separator_type' => 3,
		'default'   => true,
	]
);

// Expand Thumbnails
kalium_customize_register_control(
	'lightbox_collapse_thumbnails',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Collapsed',
		'default'    => true,
		'dependency' => [
			'lightbox_thumbnails' => true,
		],
	]
);

// Autoplay
kalium_customize_register_control(
	'lightbox_autoplay',
	[
		'type'      => 'kalium-toggle',
		'label'     => 'Autoplay',
		'separator' => true,
		'separator_type' => 3,
		'default'   => true,
	]
);

// Autoplay Interval
kalium_customize_register_control(
	'lightbox_autoplay_interval',
	[
		'type'        => 'kalium-text',
		'label'       => 'Interval',
		'input_type'  => 'number',
		'input_style' => 'width:80px',
		'placeholder' => 5,
		'min'         => 0,
		'suffix'      => 's',
		'dependency'  => [
			'lightbox_autoplay' => true,
		],
	]
);

// Zoom
kalium_customize_register_control(
	'lightbox_zoom',
	[
		'type'      => 'kalium-toggle',
		'label'     => 'Zoom',
		'separator' => true,
		'separator_type' => 3,
		'default'   => true,
	]
);

// Zoom Scale
kalium_customize_register_control(
	'lightbox_zoom_scale',
	[
		'type'        => 'kalium-text',
		'label'       => 'Max. Scale',
		'input_type'  => 'number',
		'input_style' => 'width:80px',
		'placeholder' => 1,
		'min'         => 0,
		'dependency'  => [
			'lightbox_zoom' => true,
		],
	]
);

// Main Image Size
kalium_customize_register_control(
	'lightbox_image_size_main',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Image Size',
		'label'         => 'Main Image',
		'separator'     => true,
		'input_style'   => 'width:130px',
		'choices'       => static function () {
			return kalium_get_image_size_names();
		},
		'default'       => 'full',
	]
);

// Thumbnail Image Size
kalium_customize_register_control(
	'lightbox_image_size_thumbnail',
	[
		'type'        => 'kalium-select',
		'label'       => 'Thumbnail',
		'input_style' => 'width:130px',
		'choices'     => static function () {
			return kalium_get_image_size_names(
				[
					'exclude' => [
						'full',
					],
				]
			);
		},
		'default'     => 'thumbnail',
		'dependency'  => [
			'lightbox_thumbnails' => true,
		],
	]
);

// Autoplay videos
kalium_customize_register_control(
	'lightbox_autoplay_videos',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Video Settings',
		'label'         => 'Autoplay Videos',
		'separator'     => true,
		'default'       => true,
	]
);


// End of current section
kalium_customize_end_section();
