<?php
/**
 * Kalium WordPress Theme
 *
 * Sticky Header options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Subsection: Sticky Header
kalium_customize_register_section(
	'sticky_header',
	[
		'title' => 'Sticky Header',
	]
);

// General tab
kalium_customize_general_tab();

// Sticky rows
kalium_customize_register_control(
	'sticky_header_rows',
	[
		'type'          => 'kalium-select',
		'label'         => 'Sections',
		'heading_title' => 'Sticky Behavior',
		'input_style'   => 'width:160px',
		'choices'       => [
			'all'  => 'All Rows',
			'main' => 'Main Row',
			'top'  => 'Top Row',
		],
		'default'       => 'main',
		'help'          => 'Choose which parts of the header become sticky when scrolling down the page.',
	]
);

// Sticky Mode
kalium_customize_register_control(
	'sticky_header_mode',
	[
		'type'        => 'kalium-radio-button',
		'label'       => 'Mode',
		'input_style' => 'width:160px',
		'choices'     => [
			'standard' => 'Standard',
			'autohide' => 'Auto Hide',
		],
	]
);

// Effect
kalium_customize_register_control(
	'sticky_header_effect',
	[
		'type'        => 'kalium-select',
		'label'       => 'Effect',
		'input_style' => 'width:160px',
		'choices'     => [
			'none'          => 'None',
			'slide'         => 'Slide',
			'fade'          => 'Fade',
			'slide-fade'    => 'Slide and Fade',
			'slide-fade-up' => 'Slide and Fade Up',
		],
		'help'        => 'Selecting an effect will disable the Progress with Scroll behavior, since the header will automatically appear in its active state.',
	]
);

// Progress on Scroll
kalium_customize_register_control(
	'sticky_header_progress_with_scroll',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Progress with Scroll',
		'help'       => 'Links effects animation to scrolling. Otherwise, uses a standard animation.When enabled, the sticky header will smoothly follow your scrolling. When disabled, it will simply appear or disappear instantly.',
		'default'    => true,
		'dependency' => [
			'sticky_header_effect' => 'none',
		],
	]
);

// Animation Duration
kalium_customize_register_control(
	'sticky_header_animation_duration',
	[
		'type'        => 'kalium-text',
		'label'       => 'Animation Duration',
		'input_style' => 'width:90px',
		'input_type'  => 'number',
		'min'         => 0,
		'max'         => 10,
		'placeholder' => 0.3,
		'suffix'      => 's',
		'dependency'  => [
			[
				'name'     => 'sticky_header_progress_with_scroll',
				'value'    => false,
				'relation' => 'OR',
			],
			[
				'name'    => 'sticky_header_effect',
				'value'   => 'none',
				'compare' => '!=',
			],
		],
	]
);

// Offset
kalium_customize_register_control(
	'sticky_header_offset',
	[
		'type'        => 'kalium-text',
		'label'       => 'Offset',
		'input_style' => 'width:90px',
		'placeholder' => 0,
		'help'        => 'Controls the distance from the top where sticky behavior begins. You can enter a number in pixels (e.g., 50), or a CSS selector (e.g., .top-header-bar) to set the offset after another element.',
	]
);

// Shrink logo
kalium_customize_register_control(
	'sticky_header_shrink_logo',
	[
		'type'          => 'kalium-range',
		'heading_title' => 'Logo',
		'label'         => 'Shrink Logo',
		'min'           => 0,
		'slider_max'    => 100,
		'suffix'        => '%',
		'help'          => 'The shrinking percentage is relative to the assigned site logo width.',
		'separator'     => true,
	]
);

// Custom logo
kalium_customize_register_control(
	'sticky_header_custom_logo',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Custom Logo',
		'help'  => 'Use custom logo when sticky header is active.',
	]
);

// Logo Image
kalium_customize_register_control(
	'sticky_header_custom_logo_image',
	[
		'type'           => 'kalium-media',
		'label'          => 'Logo Image',
		'select_label'   => 'Select Custom Logo',
		'library_params' => [
			'type' => 'image',
		],
		'height'         => 80,
		'dependency'     => [
			'sticky_header_custom_logo' => true,
		],
	]
);

// Responsive
kalium_customize_register_control(
	'sticky_header_responsive',
	[
		'type'          => 'kalium-checkbox-button',
		'heading_title' => 'Responsive',
		'label'         => 'Enable On',
		'separator'     => true,
		'reset'         => true,
		'inline_label'  => false,
		'choices'       => [
			'desktop' => [
				'label' => 'Desktop',
				'icon'  => 'desktop',
			],
			'tablet'  => [
				'label' => 'Tablet',
				'icon'  => 'tablet',
			],
			'mobile'  => [
				'label' => 'Mobile',
				'icon'  => 'mobile',
			],
		],
		'default'       => [
			'desktop',
			'tablet',
			'mobile',
		],
		'help'          => 'Select in which device types the sticky header will be active.',
	]
);

// End of general
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Background
kalium_customize_register_control(
	'sticky_header_background_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Container',
		'label'         => 'Background',
		'reset'         => true,
		'enable_clear'  => true,
		'help'          => 'Apply background color when sticky header is active.',
	]
);

// Border
kalium_customize_register_control(
	'sticky_header_border',
	[
		'type'         => 'kalium-border',
		'label'        => 'Border Bottom',
		'reset'        => true,
		'border_style' => true,
		'slider'       => true,
	]
);

// Shadow
kalium_customize_register_control(
	'sticky_header_shadow',
	[
		'type'         => 'kalium-box-shadow',
		'label'        => 'Shadow',
		'enable_clear' => true,
		'reset'        => true,
		'units'        => kalium_get_default_units( 'length' ),
	]
);

// Vertical Padding
kalium_customize_register_control(
	'sticky_header_vertical_padding',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Padding',
		'reset'       => true,
		'value_props' => [
			'top'    => 'Top',
			'bottom' => 'Bottom',
		],
		'units'       => kalium_get_default_units( 'box-size' ),
		'default'     => [
			'top'    => 10,
			'bottom' => 10,
			'link'   => true,
		],
	]
);

// Links
kalium_customize_register_control(
	'sticky_header_links_color',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Other Elements',
		'label'         => 'Links',
		'separator'     => true,
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'       => [
			'normal' => kalium_color_reference( 'header_style_links.normal' ),
			'hover'  => kalium_color_reference( 'header_style_links.normal' ),
			'active' => kalium_color_variant_active( 'header_style_links.hover' ),
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Menu trigger
kalium_customize_register_control(
	'sticky_header_menu_trigger',
	[
		'type'    => 'kalium-color',
		'label'   => 'Hamburger Menu',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default' => [
			'normal' => kalium_color_reference( 'sticky_header_links_color.normal' ),
			'hover'  => kalium_color_reference( 'sticky_header_links_color.hover' ),
			'active' => kalium_color_variant_active( 'sticky_header_links_color.active' ),
		],
		'tooltip' => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Text color
kalium_customize_register_control(
	'sticky_header_text_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Text',
		'reset'   => true,
		'default' => kalium_color_reference( 'header_style_text' ),
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Pill background color
kalium_customize_register_control(
	'sticky_header_pill_bg_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Pill Background',
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'    => [
			'hover'  => kalium_color_reference( 'header_menu_pill_background.hover' ),
			'active' => kalium_color_reference( 'sticky_header_pill_bg_color.hover' ),
		],
		'reset'      => true,
		'tooltip'    => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
		],
	]
);

// Pill text color
kalium_customize_register_control(
	'sticky_header_pill_color',
	[
		'type'       => 'kalium-color',
		'label'      => 'Pill Color',
		'choices'    => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'default'    => [
			'normal' => kalium_color_reference( 'sticky_header_links_color.normal' ),
			'hover'  => kalium_color_reference( 'sticky_header_links_color.hover' ),
			'active' => kalium_color_reference( 'sticky_header_links_color.active' ),
		],
		'tooltip'    => true,
		'reset'      => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'header_menu_pills' => true,
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

// Preview
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'sticky_header_links_color',
			'sticky_header_text_color',
			'sticky_header_pill_bg_color',
			'sticky_header_pill_color',
		],
		'content' => <<<'EOD'
<#
var stickyState = '.sticky-element-fully-active';
#>

{{{ data.api.printInlineStyle( {
	selector: stickyState,
	value: data.sticky_header_links_color,
	varName: 'header',
	parser: function ( value ) {
		return {
			'link-color': data.api.parseColor( value.normal ),
			'link-hover-color': data.api.parseColor( value.hover ),
			'link-active-color': data.api.parseColor( value.active ),
		};
	},
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState,
	value: data.sticky_header_text_color,
	varName: 'header-color',
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState + ' .nav-pills',
	value: data.sticky_header_pill_bg_color,
	varName: 'pill',
	parser: function ( value ) {
		return {
			'bg': data.api.parseColor( value.normal ),
			'bg-hover': data.api.parseColor( value.hover ),
			'bg-active': data.api.parseColor( value.active ),
		};
	},
} ) }}}

{{{ data.api.printInlineStyle( {
	selector: stickyState + ' .nav-pills',
	value: data.sticky_header_pill_color,
	varName: 'pill',
	parser: function ( value ) {
		return {
			'color': data.api.parseColor( value.normal ),
			'color-hover': data.api.parseColor( value.hover ),
			'color-active': data.api.parseColor( value.active ),
		};
	},
} ) }}}
EOD,
	]
);
