<?php
/**
 * Kalium WordPress Theme
 *
 * Transparent Header options.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Subsection: Transparent Header
kalium_customize_register_section(
	'header_transparent',
	[
		'title' => 'Transparent Header',
	]
);

// General tab
kalium_customize_general_tab();

// Header spacing
kalium_customize_register_control(
	'header_spacing',
	[
		'type'             => 'kalium-range',
		'label'            => 'Spacing',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'max'              => 600,
		'initial_position' => 0,
		'placeholder'      => 0,
		'suffix'           => 'PX',
		'setting'          => [
			'transport' => 'postMessage',
		],
	]
);

// Custom logo
kalium_customize_register_control(
	'header_transparent_custom_logo',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Custom Logo',
		'help'  => 'Use custom logo when transparent header is active.',
	]
);

// Logo Image
kalium_customize_register_control(
	'header_transparent_custom_logo_image',
	[
		'type'           => 'kalium-media',
		'label'          => 'Logo Image',
		'select_label'   => 'Select Custom Logo',
		'library_params' => [
			'type' => 'image',
		],
		'height'         => 80,
		'dependency'     => [
			'header_transparent_custom_logo' => true,
		],
	]
);

// Logo width
kalium_customize_register_control(
	'header_transparent_logo_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Logo Width',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'slider_max'       => 500,
		'suffix'           => 'px',
		'placeholder'      => kalium_get_theme_option( 'custom_logo_max_width', true ),
		'initial_position' => kalium_get_responsive_value( kalium_get_theme_option( 'custom_logo_max_width', true ) ),
		'dependency'       => [
			'header_transparent_custom_logo' => true,
		],
	]
);

// Display conditions
kalium_customize_register_control(
	'header_transparent_display_conditions',
	[
		'type'                => 'kalium-conditions',
		'label'               => 'Display Conditions',
		'separator'           => true,
		'empty_state_message' => 'No display conditions set. You must set at least one condition to enable the transparent header.',
	]
);

// End of general
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Links
kalium_customize_register_control(
	'header_transparent_style_links',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Menu',
		'label'         => 'Links',
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'tooltip'       => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Hamburger Menu Trigger Button
kalium_customize_register_control(
	'header_transparent_style_menu_trigger',
	[
		'type'    => 'kalium-color',
		'label'   => 'Hamburger Menu',
		'reset'   => true,
		'choices' => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'tooltip' => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Text
kalium_customize_register_control(
	'header_transparent_style_text',
	[
		'type'  => 'kalium-color',
		'label' => 'Text',
		'reset' => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Pill background
kalium_customize_register_control(
	'header_transparent_pill_background',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Pill Navigation',
		'separator'     => true,
		'label'         => 'Background',
		'reset'         => true,
		'choices'       => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear'  => true,
		'tooltip'       => true,
		'dependency'    => [
			'header_menu_pills' => true,
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Pill color
kalium_customize_register_control(
	'header_transparent_pill_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Color',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'dependency'   => [
			'header_menu_pills' => true,
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Submenu
kalium_customize_register_control(
	'header_transparent_style_submenu_bg',
	[
		'type'          => 'kalium-color',
		'heading_title' => 'Submenu',
		'label'         => 'Background',
		'separator'     => true,
		'reset'         => true,
		'enable_clear'  => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Submenu Pill background
kalium_customize_register_control(
	'header_transparent_pill_submenu_bg',
	[
		'type'         => 'kalium-color',
		'label'        => 'Pill Background',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear' => true,
		'tooltip'      => true,
		'dependency'   => [
			'header_menu_pills' => true,
		],
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// Submenu Links
kalium_customize_register_control(
	'header_transparent_style_submenu_links',
	[
		'type'         => 'kalium-color',
		'label'        => 'Links',
		'reset'        => true,
		'choices'      => [
			'normal' => 'Normal',
			'hover'  => 'Hover',
			'active' => 'Active',
		],
		'enable_clear' => true,
		'tooltip'      => true,
	]
);

// Submenu Border
kalium_customize_register_control(
	'header_transparent_style_submenu_border',
	[
		'type'         => 'kalium-border-box',
		'label'        => 'Border',
		'reset'        => true,
		'border_style' => true,
		'setting'       => [
			'transport' => 'postMessage',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Preview updates.
 */

// Header spacing
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_transparent',
			'header_spacing',
		],
		'content' => <<<'EOD'
		<# if ( data.header_transparent ) { #>
			{{{ data.api.printInlineStyle( {
				selector: '.wrapper',
				prop: 'padding-top', 
				value: data.header_spacing,
				addUnit: 'px',
			} ) }}}
		<# } #>
EOD,
	]
);

// Style
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'header_transparent',
			'header_menu_pills',
			'header_transparent_style_links',
			'header_transparent_style_menu_trigger',
			'header_transparent_style_text',
			'header_transparent_pill_background',
			'header_transparent_pill_color',
			'header_transparent_style_submenu_bg',
			'header_transparent_pill_submenu_bg',
			'header_transparent_style_submenu_border',
		],
		'content' => <<<'EOD'
		<# if ( data.header_transparent ) { #>
			{{{ data.api.printInlineStyle( {
				selector: '.site-header',
				value: data.header_transparent_style_links,
				varName: 'header',
				parser: function ( value ) {
					return {
						'link-color': data.api.parseColor( value.normal ),
						'link-hover-color': data.api.parseColor( value.hover ),
						'link-active-color': data.api.parseColor( value.active ),
					};
				},
			} ) }}}

			{{{ data.api.printInlineStyle( {
				selector: '.site-header',
				value: data.header_transparent_style_menu_trigger,
				varName: 'header-menu-trigger',
				parser: function ( value ) {
					return {
						'color': data.api.parseColor( value.normal ),
						'hover-color': data.api.parseColor( value.hover ),
						'active-color': data.api.parseColor( value.active ),
					};
				},
			} ) }}}

			{{{ data.api.printInlineStyle( {
				selector: '.site-header',
				value: data.header_transparent_style_text,
				prop: 'color',
			} ) }}}

			{{{ data.api.printInlineStyle( {
				selector: '.site-header',
				value: data.header_transparent_style_submenu_bg,
				varName: 'header-submenu-bg',
			} ) }}}

			<# if ( data.header_menu_pills ) { #>
			html .nav-pills {
				{{ data.api.cssVarName( "pill-color" ) }}:  {{ data.api.parseColor( data.header_transparent_pill_color.normal ) }};
				{{ data.api.cssVarName( "pill-color-hover" ) }}: {{ data.api.parseColor( data.header_transparent_pill_color.hover ) }};
				{{ data.api.cssVarName( "pill-color-active" ) }}: {{ data.api.parseColor( data.header_transparent_pill_color.active ) }};
				
				{{ data.api.cssVarName( "pill-bg" ) }}:  {{ data.api.parseColor( data.header_transparent_pill_background.normal ) }};
				{{ data.api.cssVarName( "pill-bg-hover" ) }}: {{ data.api.parseColor( data.header_transparent_pill_background.hover ) }};
				{{ data.api.cssVarName( "pill-bg-active" ) }}: {{ data.api.parseColor( data.header_transparent_pill_background.active ) }};
				
				<# if ( data.header_transparent_pill_submenu_bg ) { #>
				.sub-menu {
					{{ data.api.cssVarName( "pill-bg" ) }}:  {{ data.api.parseColor( data.header_transparent_pill_submenu_bg.normal ) || "transparent" }};
					{{ data.api.cssVarName( "pill-bg-hover" ) }}: {{ data.api.parseColor( data.header_transparent_pill_submenu_bg.hover ) || "transparent" }};
					{{ data.api.cssVarName( "pill-bg-active" ) }}: {{ data.api.parseColor( data.header_transparent_pill_submenu_bg.active ) || "transparent" }};
				}
				<# } #>
			}
			<# } #>

			<# var border = data.api.toBorderBox( data.header_transparent_style_submenu_border ); #>
			html .standard-menu .menu ul {
				<# [ "width", "style", "color" ].forEach( function ( borderProp ) { #>
					<# if ( border[ borderProp ] ) { #>
					{{ data.api.cssVarName( "submenu-border-" + borderProp ) }}: {{ border[ borderProp ] }};
					<# } #>
				<# } ); #>
			}
		<# } #>
		EOD,
	]
);
