<?php
/**
 * Kalium WordPress Theme
 *
 * Cart and checkout.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/** @var WP_Customize_Manager $wp_customize */
global $wp_customize;

// Checkout section
if ( isset( $wp_customize ) ) {
	$woocommerce_checkout_section = $wp_customize->get_section( 'woocommerce_checkout' );
	$woocommerce_checkout_control = $wp_customize->get_control( 'woocommerce_checkout' );

	if ( $woocommerce_checkout_section ) {
		$woocommerce_checkout_section->title    = $woocommerce_checkout_control->label = 'Cart & Checkout';
		$woocommerce_checkout_control->priority = 30;
	}
}

// Section start
kalium()->customize->start_section( 'woocommerce_checkout' );

// Order review style
kalium_customize_register_control(
	'shop_order_review_style',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Order Review Style',
		'choices'       => [
			'invoice-cut'  => [
				'label' => 'Invoice Cut',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/invoice-cutout.svg' ),
			],
			'invoice-flat' => [
				'label' => 'Invoice Flat',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/invoice-flat.svg' ),
			],
		],
		'show_labels'   => false,
		'tooltips'      => true,
	]
);

// Sticky
kalium_customize_register_control(
	'shop_order_review_sticky',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Sticky',
		'help'  => 'Makes the order review section sticky on the cart page only.',
	]
);

// Steps
kalium_customize_register_control(
	'shop_checkout_steps',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Steps',
		'label'         => 'Multi Steps',
		'separator'     => true,
	]
);

// Step numbers
kalium_customize_register_control(
	'shop_checkout_step_numbers',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Step Numbers',
		'default'    => true,
		'dependency' => [
			'shop_checkout_steps' => true,
		],
	]
);

// Checkout Product Image
kalium_customize_register_control(
	'shop_checkout_product_image',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Checkout',
		'label'         => 'Product Image',
		'separator'     => true,
		'default'       => true,
	]
);

// Link to product
kalium_customize_register_control(
	'shop_checkout_link_to_product',
	[
		'type'  => 'kalium-toggle',
		'label' => 'Link to Product',
		'help'  => 'Product name in order review will be linked to the product',
	]
);

// Custom HTML content
kalium_customize_register_control(
	'shop_checkout_separator',
	[
		'type' => 'kalium-html',
		'html' => '<div class="kalium-customize-control__separator"></div>',
	]
);

// End current section
kalium_customize_end_section();
