<?php
/**
 * Kalium WordPress Theme
 *
 * Mini cart.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Mini Cart
kalium_customize_register_control(
	'kalium_woocommerce_mini_cart',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Mini Cart',
		'section_link' => kalium()->customize->section_id( 'mini_cart' ),
	]
);

/**
 * Subsection: Mini cart / cart drawer.
 */

// Subsection: Mini cart
kalium_customize_register_section(
	'mini_cart',
	[
		'title' => 'Mini Cart',
	]
);

// General tab
kalium_customize_general_tab();

// Type
kalium_customize_register_control(
	'shop_mini_cart_type',
	[
		'type'        => 'kalium-radio-image',
		'label'       => 'Type',
		'choices'     => [
			'drawer' => [
				'label' => 'Drawer',
				'image' => kalium()->assets_url( 'admin/images/theme-options/mini-cart-drawer.svg' ),
			],
			'popup'  => [
				'label' => 'Popup',
				'image' => kalium()->assets_url( 'admin/images/theme-options/mini-cart-popup.svg' ),
			],
		],
		'show_labels' => false,
		'tooltips'    => true,
	]
);

// Animation
kalium_customize_register_control(
	'shop_mini_cart_animation',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Animation',
		'choices'    => [
			'slide' => 'Slide',
			'fade'  => 'Fade',
		],
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// Go to cart button
kalium_customize_register_control(
	'shop_mini_cart_page_link',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Cart Button',
		'default'    => true,
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// Max width
kalium_customize_register_control(
	'shop_mini_cart_max_width',
	[
		'type'             => 'kalium-range',
		'label'            => 'Max Width',
		'reset'            => true,
		'min'              => 300,
		'max'              => 700,
		'initial_position' => 450,
		'placeholder'      => 450,
		'suffix'           => 'PX',
		'setting'          => [
			'transport' => 'postMessage',
		],
		'dependency'       => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Separator color
kalium_customize_register_control(
	'shop_mini_cart_separators_color',
	[
		'type'         => 'kalium-color',
		'label'        => 'Separators',
		'reset'        => true,
		'enable_clear' => true,
		'default'      => kalium_color_reference( 'theme_colors.color-8' ),
		'setting'      => [
			'transport' => 'postMessage',
		],
		'dependency'   => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// Style settings
kalium()->customize->register_style_settings(
	'shop_mini_cart',
	[
		'settings'              => [
			'bg',
			'headings',
			'text',
			'padding',
			'border',
			'border_radius',
			'box_shadow',
		],
		'setting_bg'            => [
			'default' => kalium_color_reference( 'theme_colors_body' ),
		],
		'setting_headings'      => [
			'default' => kalium_color_reference( 'theme_colors_headings' ),
		],
		'setting_text'          => [
			'default' => kalium_color_reference( 'theme_colors_text.normal' ),
		],
		'setting_padding'       => [
			'css_var' => 'drawer-padding',
			'default' => [
				'link' => true,
			],
		],
		'setting_border_radius' => [
			'default' => [
				'link' => true,
			],
		],
		'css_var_prefix'        => 'oc',
		'css_selector'          => '.mini-cart-drawer',
		'dependency'            => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// Offset
kalium_customize_register_control(
	'shop_mini_cart_offset',
	[
		'type'        => 'kalium-multi-numeric',
		'label'       => 'Offset',
		'reset'       => true,
		'responsive'  => true,
		'placeholder' => 0,
		'value_props' => [
			'y' => 'Vertical',
			'x' => 'Horizontal',
		],
		'units'       => kalium_get_default_units( 'length' ),
		'setting'     => [
			'transport' => 'postMessage',
		],
		'dependency'  => [
			'shop_mini_cart_type' => 'drawer',
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

/**
 * Update preview.
 */

// Cart drawer
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'shop_mini_cart_animation',
			'shop_mini_cart_max_width',
			'shop_mini_cart_separators_color',
			'shop_mini_cart_offset',
		],
		'content' => <<<EOD
<# 
var selector = '.mini-cart-drawer';
var miniCart = document.querySelector( selector );

// Reset offset vars
data.api.cssVarReset( [
	data.api.cssVarName( 'oc-offset-y' ),
	data.api.cssVarName( 'oc-offset-x' ),
] );
#>
{{{ data.api.printInlineStyle( { selector: selector, varName: 'oc-max-width', setting: 'shop_mini_cart_max_width', addUnit: 'px' } ) }}}
{{{ data.api.printInlineStyle( { selector: selector, varName: 'oc-offset', setting: 'shop_mini_cart_offset', parser: ( value ) => ( { x: data.api.getMultiNumericProp( value, 'x' ), y: data.api.getMultiNumericProp( value, 'y' ) } ) } ) }}}
{{{ data.api.printInlineStyle( { selector: selector, varName: 'drawer-separators-color', setting: 'shop_mini_cart_separators_color' } ) }}}
EOD,
	]
);

// Open cart drawer
kalium_customize_register_preview_update(
	[
		'type'    => 'js',
		'vars'    => [
			'shop_mini_cart_max_width',
			'shop_mini_cart_bg',
			'shop_mini_cart_headings',
			'shop_mini_cart_text',
			'shop_mini_cart_padding',
			'shop_mini_cart_border',
			'shop_mini_cart_border_radius',
			'shop_mini_cart_box_shadow',
			'shop_mini_cart_offset',
		],
		'content' => <<<EOD
kalium( 'call-function', 'WooCommerce_Mini_Cart.show' );
EOD,
	]
);
