<?php
/**
 * Kalium WordPress Theme
 *
 * My account.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// My account section link
kalium_customize_register_control(
	'kalium_woocommerce_my_account',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'My Account',
		'section_link' => kalium()->customize->section_id( 'my_account' ),
		'priority'     => 40,
	]
);

/**
 * Subsection: My Account.
 */

// My account section
kalium_customize_register_section(
	'my_account',
	[
		'title' => 'My Account',
	]
);

// Login/Register image
kalium_customize_register_control(
	'shop_my_account_login_image',
	[
		'type'           => 'kalium-media',
		'label'          => 'Login/Register Image',
		'library_params' => [
			'type' => 'image',
		],
	]
);

// Image alignment
kalium_customize_register_control(
	'shop_my_account_login_image_align',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Align',
		'reset'      => true,
		'choices'    => [
			'left'  => 'Left',
			'right' => 'Right',
		],
		'default'    => 'right',
		'dependency' => [
			'shop_my_account_login_image' => [
				'validate' => 'is_number',
				'key_path' => 'id',
			],
		],
	]
);

// End of current section
kalium_customize_end_section();
