<?php
/**
 * Kalium WordPress Theme
 *
 * Product page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Product page section link
kalium_customize_register_control(
	'kalium_woocommerce_product_page',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Product Page',
		'section_link' => kalium()->customize->section_id( 'product_page' ),
	]
);

/**
 * Section: Product page.
 */

// Section
kalium_customize_register_section(
	'product_page',
	[
		'title' => 'Product Page',
	]
);

// Product gallery size (width)
kalium_customize_register_control(
	'shop_single_gallery_size',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Product Image Width',
		'choices'       => [
			'small'     => [
				'label' => 'Small',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-image-small.svg' ),
			],
			'medium'    => [
				'label' => 'Medium',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-image-medium.svg' ),
			],
			'large'     => [
				'label' => 'Large',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-image-large.svg' ),
			],
			'container' => [
				'label' => 'Container width',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-image-full-width.svg' ),
			],
			'full'      => [
				'label' => 'Full width',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/product-image-full-width-window.svg' ),
			],
		],
		'default'       => 'medium',
		'show_labels'   => false,
		'tooltips'      => true,
	]
);

// Inverted gallery position
kalium_customize_register_control(
	'shop_single_gallery_inverted',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Flip Horizontally',
		'help'       => 'Inverts the layout by moving the image to the right and content to the left',
		'dependency' => [
			'shop_single_gallery_size' => [
				'small',
				'medium',
				'large',
			],
		],
	]
);

// Sticky description gallery
kalium_customize_register_control(
	'shop_single_sticky_description',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Sticky Description',
		'dependency' => [
			'shop_single_gallery_size' => [
				'small',
				'medium',
				'large',
			],
		],
	]
);

// Product Summary gap
kalium_customize_register_control(
	'shop_single_product_summary_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Gallery / Summary Gap',
		'responsive'       => true,
		'reset'            => true,
		'units'            => kalium_get_default_units(
			[
				'px' => [
					'min' => 0,
					'max' => 200,
				],
				'%'  => [
					'min' => 0,
					'max' => 30,
				],
			]
		),
		'initial_position' => 30,
		'dependency'       => [
			'shop_single_gallery_size' => [
				'small',
				'medium',
				'large',
			],
		],
	]
);

// Gallery type
kalium_customize_register_control(
	'shop_single_gallery_type',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Gallery',
		'separator'     => true,
		'choices'       => [
			'type-1' => [
				'label' => 'Thumbnails Bottom',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-thumbnails-bottom.svg' ),
			],
			'type-2' => [
				'label' => 'Thumbnails Right',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-thumbnails-right.svg' ),
			],
			'type-3' => [
				'label' => 'Thumbnails Left',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-thumbnails-left.svg' ),
			],
			'type-4' => [
				'label' => 'Grid 1',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-grid-1.svg' ),
			],
			'type-5' => [
				'label' => 'Grid 2',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-grid-2.svg' ),
			],
			'type-6' => [
				'label' => 'Grid 3',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-grid-3.svg' ),
			],
			'type-7' => [
				'label' => 'Grid 4',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-grid-4.svg' ),
			],
			'type-8' => [
				'label' => 'Simple',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-simple.svg' ),
			],
			'type-9' => [
				'label' => 'Carousel',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/gallery-carousel.svg' ),
			],
		],
		'show_labels'   => false,
		'tooltips'      => true,
		'columns'       => 3,
	]
);

// Enlarge icon
kalium_customize_register_control(
	'shop_single_gallery_image_enlarge',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Enlarge Icon',
		'default' => true,
	]
);

// Gallery image click
kalium_customize_register_control(
	'shop_single_gallery_image_click',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Mouse/Touch Behavior',
		'default' => true,
	]
);

// Gallery image click action
kalium_customize_register_control(
	'shop_single_gallery_image_click_action',
	[
		'type'         => 'kalium-radio-button',
		'input_style'  => 'margin-top: -10px',
		'inline_label' => false,
		'choices'      => [
			'zoom'     => 'Zoom',
			'lightbox' => 'Lightbox',
		],
		'dependency'   => [
			'shop_single_gallery_image_click' => true,
		],
	]
);

// Gallery gap
kalium_customize_register_control(
	'shop_single_gallery_gap',
	[
		'type'             => 'kalium-range',
		'label'            => 'Gap',
		'reset'            => true,
		'responsive'       => true,
		'min'              => 0,
		'max'              => 100,
		'initial_position' => 30,
		'placeholder'      => 30,
		'units'            => kalium_get_default_units( 'box-size' ),
		'dependency'       => [
			'shop_single_gallery_type' => [
				'value'   => 'type-8',
				'compare' => '!=',
			],
		],
	]
);

// Gallery Auto Play
kalium_customize_register_control(
	'shop_single_gallery_autoplay',
	[
		'type'        => 'kalium-text',
		'label'       => 'Gallery Auto Play',
		'input_style' => 'width: 80px',
		'input_type'  => 'number',
		'min'         => 1,
		'max'         => 100,
		'default'     => 5,
		'suffix'      => 's',
		'help'        => 'Auto-switch interval for gallery images',
		'dependency'  => [
			'shop_single_gallery_type' => [
				'type-1',
				'type-2',
				'type-3',
				'type-8',
				'type-9',
			],
		],
	]
);

// Stretch gallery
kalium_customize_register_control(
	'shop_single_gallery_stretch',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Stretch',
		'dependency' => [
			'shop_single_gallery_size' => [
				'small',
				'medium',
				'large',
			],
			'shop_single_gallery_type' => [
				'type-4',
				'type-5',
				'type-6',
				'type-7',
			],
		],
	]
);

// Carousel mobile gallery
kalium_customize_register_control(
	'shop_single_gallery_carousel_mobile',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Carousel on Mobile',
		'default'    => true,
		'dependency' => [
			'shop_single_gallery_type' => [
				'type-4',
				'type-5',
				'type-6',
				'type-7',
			],
		],
	]
);

// Gallery Navigation
kalium_customize_register_control(
	'shop_single_gallery_navigation',
	[
		'type'       => 'kalium-checkbox-button',
		'label'      => 'Navigation',
		'choices'    => [
			'arrows' => 'Arrows',
			'dots'   => 'Dots',
		],
		'default'    => [ 'arrows' ],
		'dependency' => [
			[
				'name'     => 'shop_single_gallery_type',
				'value'    => [
					'type-1',
					'type-2',
					'type-3',
					'type-8',
					'type-9',
				],
				'relation' => 'OR',
			],
			[
				'name'  => 'shop_single_gallery_carousel_mobile',
				'value' => true,
			],
			[
				'name'  => 'shop_single_gallery_type',
				'value' => [
					'type-4',
					'type-5',
					'type-6',
					'type-7',
				],
			],
		],
	]
);

// Gallery image click action
kalium_customize_register_control(
	'shop_single_gallery_carousel_animation',
	[
		'type'       => 'kalium-radio-button',
		'label'      => 'Animation',
		'choices'    => [
			'slide' => 'Slide',
			'fade'  => 'Fade',
		],
		'dependency' => [
			[
				'name'  => 'shop_single_gallery_type',
				'value' => [
					'type-1',
					'type-2',
					'type-3',
					'type-8',
				],
				'relation' => 'OR',
			],
			[
				'name'  => 'shop_single_gallery_carousel_mobile',
				'value' => true,
			],
			[
				'name'  => 'shop_single_gallery_type',
				'value' => [
					'type-4',
					'type-5',
					'type-6',
					'type-7',
				],
			],
		],
	]
);

// Gallery Item Max Width
kalium_customize_register_control(
	'shop_single_gallery_item_max_width',
	[
		'type'       => 'kalium-range',
		'label'      => 'Item Max Width',
		'reset'      => true,
		'responsive' => true,
		'min'        => 100,
		'max'        => 2000,
		'default'    => kalium()->woocommerce->get_single_image_width(),
		'suffix'     => 'PX',
		'dependency' => [
			'shop_single_gallery_type' => 'type-9',
		],
	]
);

// Thumbnails carousel
kalium_customize_register_control(
	'shop_single_gallery_thumbnails_carousel',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Carousel Thumbnails',
		'default'    => true,
		'dependency' => [
			'shop_single_gallery_type' => [
				'type-1',
				'type-2',
				'type-3',
			],
		],
	]
);

// Thumbnails per view auto
kalium_customize_register_control(
	'shop_single_gallery_thumbnails_per_view_auto',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Auto Thumbnails Per View',
		'dependency' => [
			'shop_single_gallery_type'                => [
				'type-2',
				'type-3',
			],
			'shop_single_gallery_thumbnails_carousel' => true,
		],
	]
);

// Thumbnails per view
kalium_customize_register_control(
	'shop_single_gallery_thumbnails_per_view',
	[
		'type'        => 'kalium-range',
		'label'       => 'Thumbnails Per View',
		'reset'       => true,
		'responsive'  => true,
		'min'         => 2,
		'max'         => 6,
		'placeholder' => 4,
		'dependency'  => [
			[
				'name'     => 'shop_single_gallery_type',
				'value'    => 'type-1',
				'relation' => 'OR',
			],
			[
				'name'    => 'shop_single_gallery_type',
				'value'   => [
					'type-2',
					'type-3',
				],
				'compare' => 'IN',
			],
			[
				'name'  => 'shop_single_gallery_thumbnails_carousel',
				'value' => true,
			],
			[
				'name'  => 'shop_single_gallery_thumbnails_per_view_auto',
				'value' => false,
			],
		],
	]
);

// Gallery Items Limit
kalium_customize_register_control(
	'shop_single_gallery_items_limit',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Max Items',
		'reset'       => true,
		'placeholder' => 'All',
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 6,
	]
);

// Sidebar
kalium_customize_register_control(
	'shop_single_sidebar',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Sidebar',
		'separator'    => true,
		'section_link' => kalium()->customize->section_id( 'sidebar' ),
	]
);

// Breadcrumb
kalium_customize_register_control(
	'shop_single_breadcrumb',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Breadcrumb',
		'section_link' => kalium()->customize->section_id( 'breadcrumb' ),
	]
);

// Product Navigation
kalium_customize_register_control(
	'shop_single_product_navigation',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Product Navigation',
		'section_link' => kalium()->customize->section_id( 'product_navigation' ),
	]
);

// Tabs type
kalium_customize_register_control(
	'shop_single_tabs_type',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Tabs',
		'separator'     => true,
		'choices'       => [
			'tabs'      => [
				'label' => 'Tabs',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/tabs-normal.svg' ),
			],
			'accordion' => [
				'label' => 'Accordions',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/tabs-accordions.svg' ),
			],
			'stacked'   => [
				'label' => 'Stacked',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/tabs-stacked.svg' ),
			],
		],
		'show_labels'   => false,
		'tooltips'      => true,
		'columns'       => 3,
	]
);

// Tabs heading
kalium_customize_register_control(
	'shop_single_tabs_headings',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Titles',
		'default' => true,
	]
);

// Tabs style
kalium_customize_register_control(
	'shop_single_tabs_style',
	[
		'type'       => 'kalium-select',
		'label'      => 'Style',
		'choices'    => [
			'style-1' => 'Pills',
			'style-2' => 'Underline',
		],
		'dependency' => [
			'shop_single_tabs_type' => 'tabs',
		],
	]
);

// Tabs orientation
kalium_customize_register_control(
	'shop_single_tabs_orientation',
	[
		'type'       => 'kalium-select',
		'label'      => 'Orientation',
		'choices'    => [
			'horizontal' => 'Horizontal',
			'vertical'   => 'Vertical',
		],
		'dependency' => [
			'shop_single_tabs_type' => 'tabs',
		],
	]
);

// Accordion in summary content
kalium_customize_register_control(
	'shop_single_accordion_in_summary',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Show in Summary',
		'dependency' => [
			'shop_single_tabs_type' => 'accordion',
		],
	]
);

// Collapse all accordions
kalium_customize_register_control(
	'shop_single_accordion_in_summary_collapse',
	[
		'type'       => 'kalium-toggle',
		'label'      => 'Collapse All',
		'default'    => true,
		'dependency' => [
			'shop_single_tabs_type' => 'accordion',
		],
	]
);

// Meta SKU
kalium_customize_register_control(
	'shop_single_meta_sku',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Product Meta',
		'label'         => 'SKU',
		'separator'     => true,
		'default'       => true,
	]
);

// Meta categories
kalium_customize_register_control(
	'shop_single_meta_categories',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Categories',
		'default' => true,
	]
);

// Meta brands
kalium_customize_register_control(
	'shop_single_meta_brands',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Brands',
		'default' => true,
	]
);

// Meta tags
kalium_customize_register_control(
	'shop_single_meta_tags',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Tags',
		'default' => true,
	]
);

// Social sharing
kalium_customize_register_control(
	'shop_single_social_share',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Social Sharing',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'social_share' ),
	]
);

// Rating style
kalium_customize_register_control(
	'shop_single_reviews_rating_style',
	[
		'type'          => 'kalium-select',
		'heading_title' => 'Reviews',
		'label'         => 'Rating Style',
		'separator'     => true,
		'choices'       => [
			'stars'   => 'Stars',
			'circles' => 'Circles',
		],
	]
);

// Rating Color
kalium_customize_register_control(
	'shop_single_reviews_rating_color',
	[
		'type'    => 'kalium-color',
		'label'   => 'Rating Color',
		'reset'   => true,
		'default' => '#ffba00',
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Upsell products
kalium_customize_register_control(
	'shop_single_upsells_products',
	[
		'type'          => 'kalium-toggle',
		'heading_title' => 'Related Products & Upsells',
		'label'         => 'Upsell Products',
		'separator'     => true,
		'default'       => true,
	]
);

// Related products
kalium_customize_register_control(
	'shop_single_related_products',
	[
		'type'         => 'kalium-toggle',
		'label'        => 'Related Products',
		'default'      => true,
		'section_link' => kalium()->customize->section_id( 'related_products' ),
	]
);

/**
 * Subsection: Sidebar.
 */

// Subsection: Sidebar
kalium_customize_register_section(
	'sidebar',
	[
		'title' => 'Sidebar',
	]
);

// Sidebar align
kalium_customize_register_control(
	'shop_single_sidebar_align',
	[
		'type'          => 'kalium-radio-image',
		'heading_title' => 'Sidebar Alignment',
		'choices'       => [
			'left'  => [
				'label' => 'Left',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/sidebar-left.svg' ),
			],
			'right' => [
				'label' => 'Right',
				'image' => kalium()->assets_url( 'admin/images/theme-options/woocommerce/sidebar-right.svg' ),
			],
		],
		'default'       => 'right',
	]
);

// Full height sidebar
kalium_customize_register_control(
	'shop_single_sidebar_full_height',
	[
		'type'    => 'kalium-toggle',
		'label'   => 'Full Height',
		'default' => true,
	]
);

// Sidebar Widgets
kalium_customize_register_control(
	'_kalium_shop_single_sidebar_widgets',
	[
		'type'         => 'kalium-section-link',
		'label'        => 'Sidebar Widgets',
		'section_link' => 'widgets',
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Breadcrumb.
 */

// Subsection: Breadcrumb
kalium_customize_register_section(
	'breadcrumb',
	[
		'title' => 'Breadcrumb',
	]
);

// Breadcrumbs position
kalium_customize_register_control(
	'shop_single_breadcrumb_position',
	[
		'type'       => 'kalium-select',
		'label'      => 'Position',
		'choices'    => [
			'below-header' => 'Below Header',
			'above-title'  => 'Above Title',
		],
		'dependency' => [
			'shop_single_breadcrumb' => true,
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Product Navigation.
 */

// Subsection: Product Navigation
kalium_customize_register_section(
	'product_navigation',
	[
		'title' => 'Product Navigation',
	]
);

// Product Navigation settings
kalium()->customize->register_post_navigation_settings(
	'product_navigation',
	[
		'post_type' => 'product',
		'defaults'  => [
			'align_horizontal'      => 'end',
			'show_info'             => true,
			'taxonomy'              => 'product_cat',
			'subtitle_content_type' => 'product_price',
			'subtitle_taxonomy'     => 'product_cat',
			'subtitle_position'     => 'below',
			'archive'               => true,
			'archive_taxonomy'      => 'product_cat',
		],
		'choices'   => [
			'subtitle_content_type' => [
				'product_price' => 'Product Price',
			],
		],
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Subsection: Social share.
 */

// Subsection: Social Share
kalium_customize_register_section(
	'social_share',
	[
		'title' => 'Social Sharing',
	]
);

// Layout
kalium_customize_register_control(
	'shop_single_social_share_style',
	[
		'type'    => 'kalium-radio-button',
		'label'   => 'Style',
		'choices' => [
			'plain' => 'Labels',
			'icons' => 'Icons',
		],
		'default' => 'icons',
	]
);

// Share Networks
kalium_customize_register_control(
	'shop_single_social_share_networks',
	[
		'type'            => 'laborator-builder',
		'label'           => 'Share Networks',
		'separator'       => true,
		'separator_type'  => 3,
		'content_type_id' => 'social_share_networks',
		'default'         => static function () {
			return laborator_builder_get_content_type( 'social_share_networks' )->get_default_content();
		},
	]
);

// End of current section
kalium_customize_end_section();

/**
 * Related products.
 */

// Subsection: Related Products
kalium_customize_register_section(
	'related_products',
	[
		'title' => 'Related Products',
	]
);

// General tab
kalium_customize_general_tab();

// Products Count
kalium_customize_register_control(
	'shop_single_related_products_limit',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Products Count',
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 10,
		'placeholder' => 4,
	]
);

// Products Columns
kalium_customize_register_control(
	'shop_single_related_products_columns',
	[
		'type'        => 'kalium-quantity',
		'label'       => 'Products Columns',
		'reset'       => true,
		'input_style' => 'width:120px',
		'min'         => 1,
		'max'         => 6,
		'placeholder' => 4,
	]
);

// End of general tab
kalium_customize_end_tab();

// Style tab
kalium_customize_style_tab();

// Background
kalium_customize_register_control(
	'shop_single_related_products_bg',
	[
		'type'    => 'kalium-color',
		'label'   => 'Background',
		'reset'   => true,
		'setting' => [
			'transport' => 'postMessage',
		],
	]
);

// Padding
kalium_customize_register_control(
	'shop_single_related_products_padding',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Padding',
		'reset'      => true,
		'responsive' => true,
		'units'      => kalium_get_default_units( 'box-size' ),
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_single_related_products_bg' => [
				'validate' => 'is_color',
			],
		],
	]
);

// Radius
kalium_customize_register_control(
	'shop_single_related_products_border_radius',
	[
		'type'       => 'kalium-multi-numeric',
		'label'      => 'Border Radius',
		'reset'      => true,
		'responsive' => true,
		'units'      => kalium_get_default_units( 'length-percentage' ),
		'setting'    => [
			'transport' => 'postMessage',
		],
		'dependency' => [
			'shop_single_related_products_bg' => [
				'validate' => 'is_color',
			],
		],
	]
);

// End of style tab
kalium_customize_end_tab();

// End of current section
kalium_customize_end_section();

// End of parent section (kalium_woocommerce_product_page)
kalium_customize_end_section();

/**
 * Update options in preview.
 */

// Rating color
kalium_customize_register_preview_update(
	[
		'type'    => 'css',
		'vars'    => [
			'shop_single_reviews_rating_color',
			'shop_single_related_products_bg',
			'shop_single_related_products_padding',
			'shop_single_related_products_border_radius',
		],
		'content' => <<<EOD
	{{{ data.api.printInlineStyle( { selector: ':root', varName: 'woocommerce-rating-color', value: data.shop_single_reviews_rating_color } ) }}}
	{{{ data.api.printInlineStyle( { selector: '.related.products', varName: 'related-products-bg', value: data.shop_single_related_products_bg } ) }}}
	{{{ data.api.printInlineStyle( { selector: '.related.products', varName: 'related-products-padding', value: data.shop_single_related_products_padding, parser: 'length' } ) }}}
	{{{ data.api.printInlineStyle( { selector: '.related.products', varName: 'related-products-border-radius', value: data.shop_single_related_products_border_radius, parser: 'length' } ) }}}
EOD,
	]
);
