<?php
/**
 * Kalium WordPress Theme
 *
 * Necessary upgrade functions.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Init upgrader data.
 */
function kalium_init_upgrader_data() {
	add_option( 'kalium_upgrader_data', [ 'first_run' => time() ], '', false );
}

/**
 * Set upgrader data.
 *
 * @param string $name
 * @param mixed  $value
 */
function kalium_set_upgrader_data( $name, $value ) {
	update_option(
		'kalium_upgrader_data',
		array_merge(
			kalium_get_upgrader_data(),
			[
				$name => [
					'value'   => $value,
					'version' => kalium()->get_version(),
					'time'    => time(),
				],
			]
		)
	);
}

/**
 * Get upgrader data.
 *
 * @param string $name
 * @param mixed  $default
 *
 * @return mixed
 */
function kalium_get_upgrader_data( $name = '', $default = null ) {
	$data = get_option( 'kalium_upgrader_data', null );

	if ( ! is_array( $data ) ) {
		kalium_init_upgrader_data();
		$data = kalium_get_upgrader_data();
	}

	if ( ! $name ) {
		return $data;
	}

	return isset( $data[ $name ] ) ? $data[ $name ]['value'] : $default;
}

/**
 * Legacy SMOF options list that are used during upgrade to version 4 of Kalium.
 *
 * @return array
 * @since 4.0
 */
function kalium_get_smof_options() {
	$of_options = [];

	$common_sidebar_options = [
		'hide'  => 'Hide sidebar',
		'right' => 'Show sidebar on right',
		'left'  => 'Show sidebar on left',
	];
	$common_endless_options = [
		'_1' => 'Spinning loader',
		'_2' => 'Pulsating loader',
	];
	$common_skin_options    = [
		'menu-skin-main'  => 'Default (Primary Theme Color)',
		'menu-skin-dark'  => 'Dark (Black)',
		'menu-skin-light' => 'Light (White)',
	];
	$common_loaders_options = [
		'top-left'      => 'Top Left',
		'top-center'    => 'Top Center',
		'top-right'     => 'Top Right',
		'center-left'   => 'Center Left',
		'center'        => 'Centered',
		'center-right'  => 'Center Right',
		'bottom-left'   => 'Bottom Left',
		'bottom-center' => 'Bottom Center',
		'bottom-right'  => 'Bottom Right',
	];
	$common_menus_list      = [
		'default' => '- Main Menu (Default) -',
	];
	$common_pixels          = array_map( 'kalium_smof_filter_add_px_unit', range( 1, 100 ) );

	foreach ( wp_get_nav_menus() as $item ) {
		$common_menus_list[ "menu-{$item->term_id}" ] = $item->name;
	}

	$of_options[] = [
		'id'   => 'smof_init',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'backups',
		'type' => 'other',
	];

	$of_options[] = [
		'id'   => 'logo_text',
		'std'  => get_bloginfo( 'title' ),
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'use_uploaded_logo',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'custom_logo_image',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'custom_logo_max_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'custom_logo_mobile_max_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'favicon_image',
		'type' => 'media',
	];

	$of_options[] = [
		'id'   => 'apple_touch_icon',
		'type' => 'media',
	];

	$of_options[] = [
		'id'   => 'google_theme_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'header_position',
		'std'     => 'static',
		'options' => [
			'static'   => 'Content Below (Static)',
			'absolute' => 'Over the Content (Absolute)',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'header_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'header_vpadding_top',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'header_vpadding_bottom',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'header_fullwidth',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'header_background_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'header_bottom_border',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'header_bottom_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'menu_hamburger_custom_label',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'menu_hamburger_custom_label_text',
		'std'  => 'MENU',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'menu_hamburger_custom_label_close_text',
		'std'  => 'CLOSE',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'menu_hamburger_custom_icon_position',
		'std'     => 'hide',
		'type'    => 'select',
		'options' => [
			'hide'  => 'Hide Icon',
			'left'  => 'Left',
			'right' => 'Right',
		],
	];

	$of_options[] = [
		'id'   => 'header_search_field',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'header_search_field_icon_animation',
		'std'     => 'scale',
		'type'    => 'select',
		'options' => [
			'shift' => 'Shift search loop on the left',
			'scale' => 'Scale to a smaller search loop',
			'none'  => 'None',
		],
	];

	$of_options[] = [
		'id'   => 'fullscreen_menu_bg',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'fullscreen_menu_bg_image',
		'type' => 'media',
	];

	$of_options[] = [
		'id'   => 'fullscreen_menu_bg_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'fullscreen_menu_bg_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => [
			'top-left'      => 'Top Left',
			'top-center'    => 'Top Center',
			'top-right'     => 'Top Right',
			'center-left'   => 'Center Left',
			'center'        => 'Centered',
			'center-right'  => 'Center Right',
			'bottom-left'   => 'Bottom Left',
			'bottom-center' => 'Bottom Center',
			'bottom-right'  => 'Bottom Right',
		],
	];

	$of_options[] = [
		'id'      => 'fullscreen_menu_bg_repat',
		'std'     => 'no-repeat',
		'type'    => 'select',
		'options' => [
			'repeat'    => 'Repeat',
			'repeat-x'  => 'Repeat X',
			'repeat-y'  => 'Repeat Y',
			'no-repeat' => 'No Repeat',
		],
	];

	$of_options[] = [
		'id'   => 'fullscreen_menu_bg_size',
		'std'  => 'cover',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'header_wpml_language_switcher',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'header_wpml_language_trigger',
		'std'     => 'hover',
		'type'    => 'select',
		'options' => [
			'hover' => 'Show on hover',
			'click' => 'Show on click',
		],
	];

	$of_options[] = [
		'id'      => 'header_wpml_language_flag_position',
		'std'     => 'left',
		'type'    => 'select',
		'options' => [
			'left'  => 'Left',
			'right' => 'Right',
			'hide'  => 'Hide',
		],
	];

	$of_options[] = [
		'id'      => 'header_wpml_language_switcher_text_display_type',
		'std'     => 'flag-name',
		'type'    => 'select',
		'options' => [
			'translated'      => 'Translated name',
			'initials'        => 'Initials',
			'name-translated' => 'Native name + (translated name)',
			'translated-name' => 'Translated name + (native name)',
			'hide'            => 'Hide text',
		],
	];

	$of_options[] = [
		'id'   => 'menu_mobile_type',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'menu_mobile_search_field',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'menu_mobile_breakpoint',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'main_menu_type',
		'std'     => 'standard-menu',
		'options' => [
			'standard-menu' => kalium()->assets_url( 'admin/images/theme-options/header-type-1.svg' ),
			'top-menu'      => kalium()->assets_url( 'admin/images/theme-options/header-type-2.svg' ),
			'full-bg-menu'  => kalium()->assets_url( 'admin/images/theme-options/header-type-3.svg' ),
			'sidebar-menu'  => kalium()->assets_url( 'admin/images/theme-options/header-type-4.svg' ),
			'custom-header' => kalium()->assets_url( 'admin/images/theme-options/header-type-5.svg' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'   => 'menu_full_bg_search_field',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'menu_full_bg_footer_block',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'menu_full_bg_opacity',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'menu_full_bg_alignment',
		'type'    => 'select',
		'options' => [
			'left'                => 'Left',
			'centered'            => 'Centered',
			'centered-horizontal' => 'Centered (Horizontal)',
		],
	];

	$of_options[] = [
		'id'      => 'menu_full_bg_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'   => 'menu_standard_menu_bar_visible',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'menu_standard_menu_bar_effect',
		'type'    => 'select',
		'options' => [
			'reveal-from-top'    => 'Slide from Top',
			'reveal-from-right'  => 'Slide from Right',
			'reveal-from-left'   => 'Slide from Left',
			'reveal-from-bottom' => 'Slide from Bottom',
			'reveal-fade'        => 'Fade Only',
		],
	];

	$of_options[] = [
		'id'      => 'menu_standard_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'      => 'custom_header_type',
		'type'    => 'select',
		'options' => [
			'standard'      => 'Standard Header',
			'logo-centered' => 'Centered Logo Header',
		],
	];

	$of_options[] = [
		'id'   => 'custom_header_content_left',
		'type' => 'content_builder',
	];

	$of_options[] = [
		'id'   => 'custom_header_content_right',
		'type' => 'content_builder',
	];

	$of_options[] = [
		'id'   => 'custom_header_content',
		'type' => 'content_builder',
	];

	$of_options[] = [
		'id'      => 'custom_header_default_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'   => 'menu_top_show_widgets',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'menu_top_nav_links_center',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'menu_top_menu_id',
		'std'     => 'default',
		'type'    => 'select',
		'options' => $common_menus_list,
	];

	$of_options[] = [
		'id'      => 'menu_top_items_per_row',
		'std'     => 'items-3',
		'type'    => 'select',
		'options' => [
			'items-1' => '1 Menu Item per Row',
			'items-2' => '2 Menu Items per Row',
			'items-3' => '3 Menu Items per Row',
			'items-4' => '4 Menu Items per Row',
			'items-5' => '5 Menu Items per Row',
			'items-6' => '6 Menu Items per Row',
			'items-7' => '7 Menu Items per Row',
			'items-8' => '8 Menu Items per Row',
		],
	];

	$of_options[] = [
		'id'      => 'menu_top_widgets_container_width',
		'std'     => 'col-6',
		'type'    => 'select',
		'options' => [
			'col-3' => '25% of row width',
			'col-4' => '33% of row width',
			'col-5' => '40% of row width',
			'col-6' => '50% of row width',
			'col-7' => '60% of row width',
			'col-8' => '65% of row width',
		],
	];

	$of_options[] = [
		'id'      => 'menu_top_widgets_per_row',
		'type'    => 'select',
		'options' => [
			'six'   => '2 Widgets per Row',
			'four'  => '3 Widgets per Row',
			'three' => '4 Widgets per Row',
		],
	];

	$of_options[] = [
		'id'      => 'menu_top_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'   => 'menu_top_force_include',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'menu_sidebar_show_widgets',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'menu_sidebar_menu_id',
		'std'     => 'default',
		'type'    => 'select',
		'options' => $common_menus_list,
	];

	$of_options[] = [
		'id'      => 'menu_sidebar_alignment',
		'std'     => 'right',
		'type'    => 'select',
		'options' => [
			'left'  => 'Left',
			'right' => 'Right',
		],
	];

	$of_options[] = [
		'id'      => 'menu_sidebar_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'   => 'menu_sidebar_force_include',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'submenu_dropdown_indicator',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'top_header_bar',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_content_left',
		'type' => 'content_builder',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_content_right',
		'type' => 'content_builder',
	];

	$of_options[] = [
		'id'      => 'top_header_bar_default_skin',
		'type'    => 'select',
		'options' => $common_skin_options,
	];

	$of_options[] = [
		'id'      => 'top_header_bar_skin',
		'type'    => 'select',
		'options' => [
			'none'  => 'None',
			'light' => 'Light',
			'dark'  => 'Dark',
		],
	];

	$of_options[] = [
		'id'   => 'top_header_bar_background_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_border_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_separator_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_support_desktop',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_support_tablet',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'top_header_bar_support_mobile',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header_background_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'sticky_header_vertical_padding',
		'std'     => '10',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'sticky_header_skin',
		'type'    => 'select',
		'options' => array_merge( [ '' => 'Do not change menu skin' ], $common_skin_options ),
	];

	$of_options[] = [
		'id'   => 'sticky_header_border',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header_border_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'sticky_header_border_width',
		'std'     => '1px',
		'type'    => 'select',
		'options' => $common_pixels,
	];

	$of_options[] = [
		'id'   => 'sticky_header_shadow_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'sticky_header_shadow_width',
		'type'    => 'select',
		'options' => $common_pixels,
	];

	$of_options[] = [
		'id'      => 'sticky_header_shadow_blur',
		'type'    => 'select',
		'options' => $common_pixels,
	];

	$of_options[] = [
		'id'   => 'sticky_header_autohide',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'sticky_header_autohide_duration',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'sticky_header_autohide_animation_type',
		'std'     => 'slide',
		'type'    => 'select',
		'options' => [
			'fade'              => 'Fade only',
			'slide'             => 'Slide from top',
			'fade-slide-top'    => 'Fade and slide from top',
			'fade-slide-bottom' => 'Fade and slide from bottom',
		],
	];

	$of_options[] = [
		'id'   => 'sticky_header_logo',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'sticky_header_logo_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'sticky_header_animate_duration',
		'std'     => 0,
		'type'    => 'switch',
		'reverse' => true, // Reverse switch

	];

	$of_options[] = [
		'id'      => 'header_sticky_duration',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'header_sticky_initial_offset',
		'std'     => '10',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'sticky_header_animation_chaining',
		'std'     => 'all',
		'type'    => 'select',
		'options' => [
			'all'             => 'All at once',
			'padding-bg_logo' => 'Padding -> Background, Logo',
			'bg_logo-padding' => 'Background, Logo -> Padding',
			'logo_padding-bg' => 'Logo, Padding -> Background',
			'bg-logo_padding' => 'Background -> Logo, Padding',
			'padding-bg-logo' => 'Padding -> Background -> Logo',
			'bg-logo-padding' => 'Background -> Logo -> Padding',
			'logo-bg-padding' => 'Logo -> Background -> Padding',
			'bg-padding-logo' => 'Background -> Padding -> Logo',
		],
	];

	$of_options[] = [
		'id'   => 'sticky_header_tween_changes',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header_support_desktop',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header_support_tablet',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'sticky_header_support_mobile',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'footer_visibility',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'footer_bg',
		'std'  => '#eeeeee',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'footer_fixed',
		'type'    => 'select',
		'options' => [
			''            => 'Normal',
			'fixed'       => 'Fixed to Bottom (No animations)',
			'fixed-fade'  => 'Fixed to Bottom with Fade Animation',
			'fixed-slide' => 'Fixed to Bottom with Slide Animation',
		],
	];

	$of_options[] = [
		'id'      => 'footer_style',
		'type'    => 'select',
		'options' => [
			''         => 'Default (Based on Current Skin)',
			'inverted' => 'White',
		],
	];

	$of_options[] = [
		'id'   => 'footer_fullwidth',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'footer_bottom_style',
		'std'     => 'horizontal',
		'type'    => 'images',
		'options' => [
			'horizontal' => kalium()->assets_url( 'admin/images/theme-options/footer-style-horizontal.svg' ),
			'vertical'   => kalium()->assets_url( 'admin/images/theme-options/footer-style-vertical.svg' ),
		],
	];

	$of_options[] = [
		'id'   => 'footer_bottom_visible',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'footer_text',
		'std'  => '&copy; Copyright ' . date( 'Y' ) . '. All Rights Reserved',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'footer_text_right',
		'std'  => '[lab_social_networks]',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'footer_widgets',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'footer_widgets_columns',
		'std'     => 'three',
		'type'    => 'select',
		'options' => [
			'one'   => '1 widget per row', // (1/1)",
			'two'   => '2 widgets per row', // (1/2)",
			'three' => '3 widgets per row', // (1/3)",
			'four'  => '4 widgets per row', // (1/4)",
			'five'  => '5 widgets per row', // (1/4)",
			'six'   => '6 widgets per row', // (1/6)"
		],
	];

	$of_options[] = [
		'id'   => 'footer_collapse_mobile',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'blog_show_header_title',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'blog_title',
		'std'  => 'Blog',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'blog_description',
		'std'  => 'Our everyday thoughts are presented here' . PHP_EOL . 'Music, video presentations, photo-shootings and more',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'      => 'blog_template',
		'std'     => 'blog-squared',
		'options' => [
			'blog-squared' => kalium()->assets_url( 'admin/images/theme-options/blog-layout-list.svg' ),
			'blog-rounded' => kalium()->assets_url( 'admin/images/theme-options/blog-template-rounded.svg' ),
			'blog-masonry' => kalium()->assets_url( 'admin/images/theme-options/blog-layout-grid.svg' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'      => 'blog_sidebar_position',
		'std'     => 'right',
		'type'    => 'select',
		'options' => $common_sidebar_options,
	];

	$of_options[] = [
		'id'   => 'blog_thumbnails',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_thumbnails_placeholder',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_type_icon',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_formats',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_title',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_excerpt',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_date',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_category',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_loop_proportional_thumbnails',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'blog_columns',
		'std'     => '_3',
		'options' => [
			'_1' => '1 post per row',
			'_2' => '2 posts per row',
			'_3' => '3 posts per row',
			'_4' => '4 posts per row',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_masonry_layout_mode',
		'std'     => 'packery',
		'options' => [
			'packery'  => 'Masonry',
			'fit-rows' => 'Fit Rows',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_masonry_borders',
		'std'     => 'yes',
		'options' => [
			'yes' => 'Yes',
			'no'  => 'No',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_masonry_columns_gap',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'blog_thumbnail_hover_effect',
		'std'     => 'full-cover',
		'options' => [
			''                      => 'No hover effect',
			'distanced'             => 'Distanced cover (semi-transparent)',
			'distanced-no-opacity'  => 'Distanced cover',
			'full-cover'            => 'Full cover (semi-transparent)',
			'full-cover-no-opacity' => 'Full cover',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_post_hover_layer_icon',
		'std'     => kalium_get_theme_option( 'blog_post_hover_animatd_eye' ) ? 'animated-eye' : 'static-eye',
		'type'    => 'select',
		'options' => [
			'none'         => 'None',
			'static-eye'   => 'Static Eye Icon',
			'animated-eye' => 'Animated Eye Icon',
			'custom'       => 'Custom Icon',
		],
	];

	$of_options[] = [
		'id'   => 'blog_post_hover_layer_icon_custom',
		'type' => 'media',
	];

	$of_options[] = [
		'id'   => 'blog_post_hover_layer_icon_custom_width',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'blog_pagination_type',
		'std'     => 'normal',
		'type'    => 'select',
		'options' => [
			'normal'         => 'Normal Pagination',
			'endless'        => 'Infinite Scroll',
			'endless-reveal' => 'Infinite Scroll + Auto Reveal',
		],
	];

	$of_options[] = [
		'id'      => 'blog_endless_pagination_style',
		'std'     => '_1',
		'type'    => 'select',
		'options' => $common_endless_options,
	];

	$of_options[] = [
		'id'      => 'blog_pagination_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => [
			'left'      => 'Left',
			'center'    => 'Center',
			'right'     => 'Right',
			'stretched' => 'Stretched',
		],
	];

	$of_options[] = [
		'id'   => 'blog_single_thumbnails',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_single_title',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_author_info',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_date_single',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_category_single',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_tags',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'blog_post_prev_next',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'blog_featured_image_placement',
		'std'     => 'container',
		'options' => [
			'container'  => 'Boxed (within container)',
			'full-width' => 'Full-width',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_featured_image_size_type',
		'std'     => 'default',
		'options' => [
			'default' => 'Default thumbnail size',
			'full'    => 'Original image size',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_author_info_placement',
		'std'     => 'left',
		'options' => [
			'left'   => 'Left',
			'right'  => 'Right',
			'bottom' => 'Below',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_comments',
		'std'     => 'show',
		'options' => [
			'show' => 'Show comments',
			'hide' => 'Hide comments',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_thumbnail_height',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'blog_gallery_autoswitch',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'blog_related_posts',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'       => 'blog_related_posts_columns',
		'std'      => 3,
		'options'  => [
			1 => '1 post per row',
			2 => '2 posts per row',
			3 => '3 posts per row',
			4 => '4 posts per row',
		],
		'numindex' => true,
		'type'     => 'select',
	];

	$of_options[] = [
		'id'       => 'blog_related_posts_per_page',
		'std'      => 3,
		'options'  => [
			1  => '1 post',
			2  => '2 posts',
			3  => '3 posts',
			4  => '4 posts',
			5  => '5 posts',
			6  => '6 posts',
			7  => '7 posts',
			8  => '8 posts',
			9  => '9 posts',
			10 => '10 posts',
		],
		'numindex' => true,
		'type'     => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_related_posts_details',
		'std'     => 'no',
		'options' => [
			'yes' => 'Show post excerpt and post meta',
			'no'  => 'Hide post excerpt and post meta',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'blog_single_sidebar_position',
		'std'     => 'hide',
		'type'    => 'select',
		'options' => $common_sidebar_options,
	];

	$of_options[] = [
		'id'   => 'blog_share_story',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'blog_share_story_networks',
		'std'  => [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter X',
				'lin'     => 'LinkedIn',
				'tlr'     => 'Tumblr',
			],
			'hidden'  => [
				'placebo' => 'placebo',
				'pi'      => 'Pinterest',
				'em'      => 'Email',
				'vk'      => 'VKontakte',
				'wa'      => 'WhatsApp',
				'te'      => 'Telegram',
			],
		],
		'type' => 'sorter',
	];

	$of_options[] = [
		'id'   => 'blog_share_story_rounded_icons',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_type',
		'std'     => 'type-1',
		'type'    => 'images',
		'options' => [
			'type-1' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-1.svg' ),
			'type-2' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-2.svg' ),
			'type-3' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-3.svg' ),
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_type_1_dynamic_height',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_columns_count',
		'std'     => '4',
		'type'    => 'select',
		'options' => [
			'1' => '1 Item per Row',
			'2' => '2 Items per Row',
			'3' => '3 Items per Row',
			'4' => '4 Items per Row',
			'5' => '5 Items per Row',
			'6' => '6 Items per Row',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_default_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_items_per_page',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_hover_layer_icon',
		'std'     => kalium_get_theme_option( 'portfolio_type_1_hover_animatd_eye' ) ? 'animated-eye' : 'static-eye',
		'type'    => 'select',
		'options' => [
			'static-eye'   => 'Static Eye Icon',
			'animated-eye' => 'Animated Eye Icon',
			'custom'       => 'Custom Icon',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_type_1_hover_layer_icon_custom',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_hover_layer_icon_custom_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_hover_effect',
		'std'     => 'full',
		'type'    => 'select',
		'options' => [
			'none'      => 'No hover effect',
			'full'      => 'Full background hover',
			'distanced' => 'Distanced background hover',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_hover_transparency',
		'std'     => 'opacity',
		'type'    => 'select',
		'options' => [
			'opacity'    => 'Apply Transparency',
			'no-opacity' => 'No Transparency',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_1_hover_style',
		'std'     => 'primary',
		'type'    => 'select',
		'options' => [
			'primary'        => 'Primary theme color',
			'black'          => 'Black background',
			'white'          => 'White background',
			'dominant-color' => 'Dominant image color',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_type_1_hover_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'portfolio_thumbnail_size_1',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_type_2_likes_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_columns_count',
		'std'     => '4',
		'type'    => 'select',
		'options' => [
			'1' => '1 Item per Row',
			'2' => '2 Items per Row',
			'3' => '3 Items per Row',
			'4' => '4 Items per Row',
			'5' => '5 Items per Row',
			'6' => '6 Items per Row',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_grid_spacing',
		'std'     => 'normal',
		'type'    => 'select',
		'options' => [
			'normal' => 'Default spacing',
			'merged' => 'Merged (no spacing)',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_default_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_items_per_page',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_hover_effect',
		'std'     => 'full',
		'type'    => 'select',
		'options' => [
			'none'      => 'No hover effect',
			'full'      => 'Full background hover',
			'distanced' => 'Distanced background hover',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_hover_text_position',
		'std'     => 'bottom-left',
		'type'    => 'select',
		'options' => [
			'top-left'     => 'Top Left',
			'top-right'    => 'Top Right',
			'center'       => 'Center',
			'bottom-left'  => 'Bottom Left',
			'bottom-right' => 'Bottom Right',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_hover_transparency',
		'std'     => 'opacity',
		'type'    => 'select',
		'options' => [
			'opacity'    => 'Apply Transparency',
			'no-opacity' => 'No Transparency',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_type_2_hover_style',
		'std'     => 'primary',
		'type'    => 'select',
		'options' => [
			'primary'        => 'Primary theme color',
			'black'          => 'Black background',
			'white'          => 'White background',
			'dominant-color' => 'Dominant image color',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_type_2_hover_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'portfolio_thumbnail_size_2',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_full_width',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_full_width_title_filter_container',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_likes',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_category_filter',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_filter_enable_subcategories',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_likes_icon',
		'std'     => 'heart',
		'type'    => 'select',
		'options' => [
			'heart' => 'Heart',
			'thumb' => 'Thumb',
			'star'  => 'Star',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_loop_subtitles',
		'std'     => 'categories',
		'type'    => 'select',
		'options' => [
			'categories'        => 'Show Item Categories',
			'categories-parent' => 'Show Item Parent Categories Only',
			'subtitle'          => 'Show Item Subtitle',
			'hide'              => 'Hide',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_reveal_effect',
		'std'     => 'slidenfade',
		'type'    => 'select',
		'options' => [
			'none'           => 'None',
			'fade'           => 'Fade',
			'slidenfade'     => 'Slide and Fade',
			'zoom'           => 'Zoom In',
			'fade-one'       => 'Fade (one by one)',
			'slidenfade-one' => 'Slide and Fade (one by one)',
			'zoom-one'       => 'Zoom In (one by one)',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_default_filter_category',
		'std'     => 'default',
		'type'    => 'select',
		'options' => [],
	];

	$of_options[] = [
		'id'   => 'portfolio_filter_category_hide_all',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_filter_dynamic_heading_title',
		'std'     => 'description',
		'type'    => 'select',
		'options' => [
			'disable'           => 'Disable',
			'title'             => 'Change only title',
			'description'       => 'Change only description',
			'title-description' => 'Change title and description',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_url_add_prefix',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'portfolio_prefix_url_slug',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_category_prefix_url_slug',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'portfolio_filter_link_type',
		'std'     => 'hash',
		'type'    => 'select',
		'options' => [
			'hash'      => 'Hash (appended in the end of URL)',
			'pushState' => 'Absolute Category Link (pushState)',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_pagination_type',
		'std'     => 'normal',
		'type'    => 'select',
		'options' => [
			'normal'         => 'Normal Pagination',
			'endless'        => 'Infinite Scroll',
			'endless-reveal' => 'Infinite Scroll + Auto Reveal',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_endless_pagination_style',
		'std'     => '_1',
		'type'    => 'select',
		'options' => $common_endless_options,
	];

	$of_options[] = [
		'id'   => 'portfolio_endless_pagination_fetch_count',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'portfolio_pagination_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => [
			'left'   => 'Left',
			'center' => 'Center',
			'right'  => 'Right',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_prev_next',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_prev_next_category',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_prev_next_show_titles',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_disable_lightbox',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_archive_url_category',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_archive_url',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'portfolio_prev_next_type',
		'std'     => 'simple',
		'type'    => 'select',
		'options' => [
			'simple' => 'Simple Next-Prev (in the end of page)',
			'fixed'  => 'Fixed Position Next-Prev',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_prev_next_position',
		'std'     => 'right-side',
		'type'    => 'select',
		'options' => [
			'left-side'  => 'Next-Prev - Left',
			'centered'   => 'Next-Prev - Center',
			'right-side' => 'Next-Prev - Right',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_like_share_layout',
		'std'     => 'default',
		'type'    => 'select',
		'options' => [
			'default' => 'Plain links',
			'rounded' => 'Rounded links (circles)',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_gallery_caption_position',
		'std'     => 'hover',
		'type'    => 'select',
		'options' => [
			'hover' => 'Show on hover',
			'below' => 'Show below image',
			'hide'  => 'Do not show caption',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_navigation_mode',
		'std'     => 'single',
		'type'    => 'select',
		'options' => [
			'single' => 'Single Item',
			'linked' => 'Linked',
		],
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_fullscreen',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_captions',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_download',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_counter',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_draggable',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_hash',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_loop',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_pager',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_skin',
		'std'     => 'default',
		'type'    => 'select',
		'options' => [
			'default'      => 'Default',
			'kalium-dark'  => 'Dark',
			'kalium-light' => 'Light',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_mode',
		'std'     => 'lg-fade',
		'type'    => 'select',
		'options' => [
			'lg-slide'                    => 'Slide',
			'lg-fade'                     => 'Fade',
			'lg-zoom-in'                  => 'Zoom in',
			'lg-zoom-in-big'              => 'Zoom in big',
			'lg-zoom-out'                 => 'Zoom out',
			'lg-zoom-out-big'             => 'Zoom out big',
			'lg-zoom-out-in'              => 'Zoom out in',
			'lg-zoom-in-out'              => 'Zoom in out',
			'lg-soft-zoom'                => 'Soft zoom',
			'lg-scale-up'                 => 'Scale up',
			'lg-slide-circular'           => 'Slide circular',
			'lg-slide-circular-vertical'  => 'Slide circular vertical',
			'lg-slide-vertical'           => 'Slide vertical',
			'lg-slide-vertical-growth'    => 'Slide vertical growth',
			'lg-slide-skew-only'          => 'Slide skew only',
			'lg-slide-skew-only-rev'      => 'Slide skew only reverse',
			'lg-slide-skew-only-y'        => 'Slide skew only y',
			'lg-slide-skew-only-y-rev'    => 'Slide skew only y reverse',
			'lg-slide-skew'               => 'Slide skew',
			'lg-slide-skew-rev'           => 'Slide skew reverse',
			'lg-slide-skew-cross'         => 'Slide skew cross',
			'lg-slide-skew-cross-rev'     => 'Slide skew cross reverse',
			'lg-slide-skew-ver'           => 'Slide skew vertically',
			'lg-slide-skew-ver-rev'       => 'Slide skew vertically reverse',
			'lg-slide-skew-ver-cross'     => 'Slide skew vertically cross',
			'lg-slide-skew-ver-cross-rev' => 'Slide skew vertically cross reverse',
			'lg-lollipop'                 => 'Lollipop',
			'lg-lollipop-rev'             => 'Lollipop reverse',
			'lg-rotate'                   => 'Rotate',
			'lg-rotate-rev'               => 'Rotate reverse',
			'lg-tube'                     => 'Tube',
		],
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_speed',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_hide_bars_delay',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_image_size_large',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_image_size_thumbnail',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_thumbnails',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_thumbnails_animated',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_thumbnails_pullcaptions_up',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_thumbnails_show',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_thumbnails_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_thumbnails_container_height',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_autoplay',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_autoplay_controls',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_autoplay_progressbar',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_autoplay_force_autoplay',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_autoplay_pause',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_zoom',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_zoom_scale',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'portfolio_lb_rotate',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_rotate_left',
		'std'     => 1,
		'type'    => 'checkbox',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_rotate_right',
		'std'     => 1,
		'type'    => 'checkbox',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_flip_horizontal',
		'std'     => 0,
		'type'    => 'checkbox',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'portfolio_lb_flip_vertical',
		'std'     => 0,
		'type'    => 'checkbox',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'portfolio_share_item',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'portfolio_share_item_networks',
		'std'  => [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter X',
				'pr'      => 'Print Page',
			],
			'hidden'  => [
				'placebo' => 'placebo',
				'pi'      => 'Pinterest',
				'em'      => 'Email',
				'tlr'     => 'Tumblr',
				'lin'     => 'LinkedIn',
				'vk'      => 'VKontakte',
				'wa'      => 'WhatsApp',
				'te'      => 'Telegram',
			],
		],
		'type' => 'sorter',
	];

	$of_options[] = [
		'id'   => 'portfolio_show_header_title',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'portfolio_title',
		'std'  => 'Portfolio',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'portfolio_description',
		'std'  => 'Our everyday work is presented here, we do what we love,' . PHP_EOL . 'Case studies, video presentations and photo-shootings below',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'portfolio_enable_tags',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'portfolio_preselected_item_type',
		'std'     => 'default',
		'type'    => 'select',
		'options' => [
			'default' => 'Default',
			'type-1'  => 'Side Portfolio',
			'type-2'  => 'Columned',
			'type-3'  => 'Carousel',
			'type-4'  => 'Zig Zag',
			'type-5'  => 'Fullscreen',
			'type-6'  => 'Lightbox',
			'type-7'  => 'WPBakery Page Builder',
		],
	];

	$of_options[] = [
		'id'      => 'shop_catalog_layout',
		'std'     => 'default',
		'options' => [
			'default'            => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-1.png' ),
			'full-bg'            => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-2.png' ),
			'distanced-centered' => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-3.png' ),
			'transparent-bg'     => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-4.png' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'   => 'shop_title_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_sorting_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_sale_ribbon_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_oos_ribbon_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_featured_ribbon_show',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_product_category_listing',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_product_price_listing',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_add_to_cart_listing',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'shop_loop_masonry_layout_mode',
		'std'     => 'fitRows',
		'type'    => 'select',
		'options' => [
			'masonry' => 'Fit gaps (Masonry)',
			'fitRows' => 'Fit rows',
		],
	];

	$of_options[] = [
		'id'      => 'shop_item_preview_type',
		'std'     => 'fade',
		'type'    => 'select',
		'options' => [
			'fade'    => 'Second Image on Hover',
			'gallery' => 'Product Gallery Slider',
			'none'    => 'None',
		],
	];

	$of_options[] = [
		'id'      => 'shop_product_columns_mobile',
		'std'     => 'one',
		'type'    => 'select',
		'options' => [
			'one' => '1 product per row',
			'two' => '2 products per row',
		],
	];

	$of_options[] = [
		'id'      => 'shop_sidebar',
		'std'     => 'hide',
		'type'    => 'select',
		'options' => $common_sidebar_options,
	];

	$of_options[] = [
		'id'   => 'shop_sidebar_before_products_mobile',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'shop_category_columns',
		'std'     => 'decide',
		'options' => [
			'one'   => '1 product per row',
			'two'   => '2 products per row',
			'three' => '3 products per row',
			'four'  => '4 products per row',
			'five'  => '5 products per row',
			'six'   => '6 products per row',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'   => 'shop_category_image_size',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'shop_pagination_type',
		'std'     => 'normal',
		'type'    => 'select',
		'options' => [
			'normal'         => 'Normal Pagination',
			'endless'        => 'Infinite Scroll',
			'endless-reveal' => 'Infinite Scroll + Auto Reveal',
		],
	];

	$of_options[] = [
		'id'      => 'shop_endless_pagination_style',
		'std'     => '_1',
		'type'    => 'select',
		'options' => $common_endless_options,
	];

	$of_options[] = [
		'id'      => 'shop_pagination_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => [
			'left'   => 'Left',
			'center' => 'Center',
			'right'  => 'Right',
		],
	];

	$of_options[] = [
		'id'   => 'shop_checkout_breadcrumb',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_checkout_product_image',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_catalog_mode',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_catalog_mode_hide_prices',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'shop_single_product_images_layout',
		'std'     => 'default',
		'options' => [
			'default'      => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-default.png' ),
			'plain'        => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-plain.png' ),
			'plain-sticky' => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-plain-sticky.png' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'      => 'shop_single_image_column_size',
		'std'     => 'medium',
		'type'    => 'select',
		'options' => [
			'small'  => 'Small (4/12)',
			'medium' => 'Medium (5/12)',
			'large'  => 'Large (6/12)',
			'xlarge' => 'Extra Large (8/12)',
		],
	];

	$of_options[] = [
		'id'      => 'shop_single_image_alignment',
		'std'     => 'left',
		'type'    => 'select',
		'options' => [
			'left'  => 'Left',
			'right' => 'Right',
		],
	];

	$of_options[] = [
		'id'      => 'shop_single_plain_image_stretch',
		'std'     => 'no',
		'type'    => 'select',
		'options' => [
			'yes' => 'Yes',
			'no'  => 'No',
		],
	];

	$of_options[] = [
		'id'      => 'shop_single_image_carousel_transition_type',
		'std'     => 'slide',
		'type'    => 'select',
		'options' => [
			'slide' => 'Slide',
			'fade'  => 'Fade',
		],
	];

	$of_options[] = [
		'id'      => 'shop_single_auto_rotate_image',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'shop_single_rating_style',
		'std'     => 'circles',
		'type'    => 'select',
		'options' => [
			'stars'      => 'Stars',
			'circles'    => 'Circles',
			'rectangles' => 'Rectangles',
		],
	];

	$of_options[] = [
		'id'      => 'shop_related_products_columns',
		'std'     => 4,
		'type'    => 'select',
		'options' => range( 2, 6 ),
	];

	$of_options[] = [
		'id'      => 'shop_related_products_per_page',
		'std'     => 4,
		'type'    => 'select',
		'options' => range( 12, 0 ),
	];

	$of_options[] = [
		'id'   => 'shop_single_product_sku_visibility',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_single_product_categories_visibility',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_single_product_tags_visibility',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'shop_single_sidebar_position',
		'std'     => 'hide',
		'type'    => 'select',
		'options' => $common_sidebar_options,
	];

	$of_options[] = [
		'id'   => 'shop_single_sidebar_before_products_mobile',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_single_product_image_zoom',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_single_product_image_lightbox',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_single_product_custom_image_size',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'shop_single_product_custom_image_size_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'shop_single_product_custom_image_size_height',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'shop_single_share_product',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_share_product_networks',
		'std'  => [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter X',
				'pi'      => 'Pinterest',
				'em'      => 'Email',
			],
			'hidden'  => [
				'placebo' => 'placebo',
				'lin'     => 'LinkedIn',
				'tlr'     => 'Tumblr',
				'vk'      => 'VKontakte',
				'wa'      => 'WhatsApp',
				'te'      => 'Telegram',
			],
		],
		'type' => 'sorter',
	];

	$of_options[] = [
		'id'   => 'shop_share_product_rounded_icons',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_cart_icon_menu',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_cart_icon_menu_count',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_cart_icon_menu_hide_empty',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'      => 'shop_cart_contents',
		'std'     => 'show-on-click',
		'type'    => 'select',
		'options' => [
			'hide'          => 'Do not show cart contents popup',
			'show-on-click' => 'Show cart contents on click',
			'show-on-hover' => 'Show cart contents on hover',
		],
	];

	$of_options[] = [
		'id'      => 'shop_cart_icon',
		'std'     => 'ecommerce-cart-content',
		'options' => [
			'ecommerce-cart-content' => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-1.png' ),
			'ecommerce-bag'          => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-2.png' ),
			'ecommerce-basket'       => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-3.png' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'   => 'shop_search_add_to_cart',
		'std'  => 1,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'shop_myaccount_form_image',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'shop_myaccount_form_image_id',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'shop_myaccount_form_image_align',
		'std'     => 'right',
		'options' => [
			'left'  => 'Left',
			'right' => 'Right',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'   => 'use_custom_skin',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'custom_skin_bg_color',
		'std'  => '#FFF',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'custom_skin_link_color',
		'std'  => '#F6364D',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'custom_skin_headings_color',
		'std'  => '#F6364D',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'custom_skin_paragraph_color',
		'std'  => '#777777',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'custom_skin_footer_bg_color',
		'std'  => '#FAFAFA',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'custom_skin_borders_color',
		'std'  => '#EEEEEE',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'theme_borders',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'theme_borders_animation',
		'std'     => 'fade',
		'options' => [
			'none'  => 'No Animations',
			'fade'  => 'Fade In',
			'slide' => 'Slide In',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'theme_borders_animation_duration',
		'std'     => '1',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'theme_borders_animation_delay',
		'std'     => '0.2',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'theme_borders_thickness',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'theme_borders_color',
		'std'  => '#f3f3ef',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'grid_container_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'grid_container_fullwidth',
		'std'  => 0,
		'type' => 'checkbox',
	];

	$of_options[] = [
		'id'   => 'footer_go_to_top',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'footer_go_to_top_activate',
		'std'  => 'footer',
		'type' => 'text',
	];

	$of_options[] = [
		'id'      => 'footer_go_to_top_type',
		'std'     => 'circle',
		'type'    => 'select',
		'options' => [
			'square' => 'Square',
			'circle' => 'Circle',
		],
	];

	$of_options[] = [
		'id'      => 'footer_go_to_top_position',
		'std'     => 'bottom-right',
		'type'    => 'select',
		'options' => [
			'bottom-right'  => 'Bottom Right',
			'bottom-left'   => 'Bottom Left',
			'bottom-center' => 'Bottom Center',
			'top-right'     => 'Top Right',
			'top-left'      => 'Top Left',
			'top-center'    => 'Top Center',
		],
	];

	$of_options[] = [
		'id'      => 'sidebar_skin',
		'std'     => 'plain',
		'type'    => 'select',
		'options' => [
			'plain'           => 'Plain',
			'bordered'        => 'Bordered',
			'background-fill' => 'Background fill',
		],
	];

	$of_options[] = [
		'id'   => 'google_maps_api',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'user_custom_js_head',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'user_custom_js',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'breadcrumbs',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_background_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_text_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_border_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'breadcrumb_border_type',
		'options' => [
			''                  => 'No border',
			'border'            => 'Full Border',
			'border-horizontal' => 'Horizontal Border',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'breadcrumb_alignment',
		'std'     => 'minimal',
		'options' => [
			'left'   => 'Left',
			'center' => 'Center',
			'right'  => 'Right',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'breadcrumb_border_radius',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'breadcrumb_margin_top',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'breadcrumb_margin_bottom',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_homepage',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_search',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_404',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_absolute_header',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_portfolio',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_visibility_blog',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_support_desktop',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_support_tablet',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'breadcrumb_support_mobile',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'search_thumbnails',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'exclude_search_post_types',
		'type' => 'multicheck',
	];

	$of_options[] = [
		'id'      => 'videojs_player_skin',
		'std'     => 'minimal',
		'options' => [
			'standard' => 'Standard Skin',
			'minimal'  => 'Minimal Skin',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'videojs_player_preload',
		'std'     => 'auto',
		'options' => [
			'auto'     => 'Auto',
			'none'     => 'None',
			'metadata' => 'Preload only meta data',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'videojs_player_autoplay',
		'std'     => 'no',
		'options' => [
			'no'          => 'Disable',
			'yes'         => 'Enable',
			'on-viewport' => 'Auto-play on viewport',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'videojs_player_loop',
		'std'     => 'no',
		'options' => [
			'no'  => 'Disable',
			'yes' => 'Enable',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'videojs_share',
		'std'     => 'no',
		'options' => [
			'yes' => 'Enable',
			'no'  => 'Disable',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'youtube_player',
		'std'     => 'videojs',
		'options' => [
			'videojs' => 'VideoJS YouTube Player',
			'native'  => 'Native YouTube Player',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_type',
		'std'     => 'static-color',
		'options' => [
			'static-color' => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-color.png' ),
			'preselected'  => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-preloaders.png' ),
			'custom'       => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-custom.png' ),
		],
		'type'    => 'images',
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_bg',
		'std'  => '#eeeeee',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_use_gradient',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_dominant_color',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_gradient_type',
		'std'     => 'linear',
		'options' => [
			'linear' => 'Linear',
			'radial' => 'Radial',
		],
		'type'    => 'select',
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_gradient_bg',
		'std'  => '#8d8d8d',
		'type' => 'color',
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_preselected_loader',
		'type'    => 'select',
		'options' => [
			'double-circle-rotate',
			'modern-circular',
			'circle-pulse',
			'ball-clip-rotate',
			'ball-scale',
			'ball-scale-multiple',
			'ball-scale-ripple',
			'ball-scale-ripple-multiple',
			'ball-scale-random',
			'ball-clip-rotate-pulse',
			'ball-clip-rotate-multiple',
			'line-scale',
			'line-scale-party',
			'line-scale-pulse-out',
			'line-scale-pulse-out-rapid',
			'ball-pulse-sync',
			'ball-pulse',
			'ball-beat',
			'ball-rotate',
			'ball-spin-fade-loader',
			'line-spin-fade-loader',
			'ball-grid-pulse',
			'ball-grid-beat',
			'triangle-skew-spin',
			'pacman',
			'semi-circle-spin',
			'square-spin',
			'ball-pulse-rise',
			'cube-transition',
			'ball-zig-zag',
			'ball-zig-zag-deflect',
			'ball-triangle-path',
		],
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_preselected_loader_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => $common_loaders_options,
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_preselected_size',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_preselected_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_preselected_loader_color',
		'std'  => '#ffffff',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'image_loading_placeholder_custom_image',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_custom_image_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_custom_loader_position',
		'std'     => 'center',
		'type'    => 'select',
		'options' => $common_loaders_options,
	];

	$of_options[] = [
		'id'      => 'image_loading_placeholder_custom_spacing',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'performance_kalium_lazyloading',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_enqueue_style_css',
		'std'  => ! get_theme_mod( 'do_not_enqueue_style_css' ),
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_preload_font_awesome',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_preload_font_awesome_brands',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_preload_flaticons',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_preload_linea',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_gutenberg_library_css',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_jquery_migrate',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_wp_emoji',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'performance_wp_embed',
		'std'  => 1,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'      => 'performance_jpeg_quality',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'social_order',
		'std'  => [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter X',
				'ig'      => 'Instagram',
				'vm'      => 'Vimeo',
				'be'      => 'Behance',
				'fs'      => 'Foursquare',
				'custom'  => 'Custom Link',
			],
			'hidden'  => [
				'placebo' => 'placebo',
				'lin'     => 'LinkedIn',
				'yt'      => 'YouTube',
				'drb'     => 'Dribbble',
				'pi'      => 'Pinterest',
				'vk'      => 'VKontakte',
				'da'      => 'DeviantArt',
				'fl'      => 'Flickr',
				'tu'      => 'Tumblr',
				'sk'      => 'Skype',
				'gh'      => 'GitHub',
				'sc'      => 'SoundCloud',
				'hz'      => 'Houzz',
				'px'      => '500px',
				'xi'      => 'Xing',
				'sp'      => 'Spotify',
				'sn'      => 'Snapchat',
				'em'      => 'Email',
				'yp'      => 'Yelp',
				'ta'      => 'TripAdvisor',
				'tc'      => 'Twitch',
				'tt'      => 'TikTok',
				'wa'      => 'WhatsApp',
				'ph'      => 'Phone',
			],
		],
		'type' => 'sorter',
	];

	$of_options[] = [
		'id'      => 'social_networks_target_attr',
		'std'     => '_blank',
		'type'    => 'select',
		'options' => [
			'_self'  => 'Same Window',
			'_blank' => 'New Window',
		],
	];

	$of_options[] = [
		'id'   => 'social_network_link_fb',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_tw',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_lin',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_yt',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_vm',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_drb',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_ig',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_pi',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_vk',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_da',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_tu',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_be',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_fl',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_fs',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_sk',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_gh',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_sc',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_hz',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_px',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_xi',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_sp',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_sn',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_yp',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_ta',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_tc',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_tt',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_wa',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_em',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_em_subject',
		'std'  => 'Hello!',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_link_ph',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_custom_link_title',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_custom_link_link',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'social_network_custom_link_icon',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_title',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_description',
		'std'  => 'We are currently working on the back-end,
our team is working hard and we’ll be back within the time',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_social_networks',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_countdown',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_date',
		'std'  => date( 'Y-m-d', strtotime( '+3 months' ) ) . ' 18:00:00',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_custom_bg',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_custom_bg_id',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'coming_soon_mode_custom_bg_size',
		'std'     => 'cover',
		'type'    => 'select',
		'options' => [
			'cover'   => 'Cover',
			'contain' => 'Contain',
		],
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_custom_bg_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_custom_txt_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_use_uploaded_logo',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'coming_soon_mode_custom_logo_image',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'coming_soon_mode_custom_logo_max_width',
		'type'    => 'text',
		'numeric' => true,
	];

	$of_options[] = [
		'id'   => 'maintenance_mode',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_title',
		'type' => 'text',
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_description',
		'std'  => 'We are currently working on the back-end,
our team is working hard and we’ll be back within the time',
		'type' => 'textarea',
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_custom_bg',
		'std'  => 0,
		'type' => 'switch',
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_custom_bg_id',
		'type' => 'media',
	];

	$of_options[] = [
		'id'      => 'maintenance_mode_custom_bg_size',
		'std'     => 'cover',
		'type'    => 'select',
		'options' => [
			'cover'   => 'Cover',
			'contain' => 'Contain',
		],
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_custom_bg_color',
		'type' => 'color',
	];

	$of_options[] = [
		'id'   => 'maintenance_mode_custom_txt_color',
		'type' => 'color',
	];

	return $of_options;
}

/**
 * SMOF backups option name.
 *
 * @return string
 * @since 4.0
 */
function kalium_get_smof_backups_option_name() {
	return '_kalium_smof_backup-' . get_stylesheet();
}

/**
 * Save backup of current SMOF options.
 *
 * @return bool
 * @since 4.0
 */
function kalium_backup_smof_options() {
	$option_name = kalium_get_smof_backups_option_name();
	$of_options  = kalium_get_smof_options();
	$theme_mods  = get_theme_mods();
	$backup      = [];

	// Copy legacy options
	foreach ( $of_options as $option ) {
		$id = $option['id'];

		if ( ! isset( $theme_mods[ $id ] ) ) {
			continue;
		}

		$backup[ $id ] = $theme_mods[ $id ];
	}

	// Store options
	if ( add_option( $option_name, $backup, '', false ) ) {

		// Remove existing SMOF options
		kalium_remove_smof_options();

		return true;
	}

	return false;
}

/**
 * Deletes all registered options from SMOF in current active theme.
 *
 * @since 4.0
 */
function kalium_remove_smof_options() {
	$of_options = kalium_get_smof_options();

	foreach ( $of_options as $option ) {
		remove_theme_mod( $option['id'] );
	}
}

/**
 * Get processed SMOF option.
 *
 * @return array<array<string, mixed>>
 * @since 4.0
 */
function kalium_get_smof_values() {
	$options = kalium_get_smof_options();
	$values  = get_option( kalium_get_smof_backups_option_name(), [] );
	$parsed  = [];

	$normalize_crlf = function ( $content ) {
		if ( is_null( $content ) ) {
			return $content;
		}

		return str_replace( [ "\r\n", "\r", "\n" ], "\n", $content );
	};

	foreach ( $options as $option ) {
		$id     = $option['id'];
		$type   = $option['type'];
		$value  = $values[ $id ] ?? null;
		$exists = array_key_exists( $id, $values ) && ! is_null( $value );

		switch ( $type ) {
			case 'text':
			case 'textarea':
				$current_value = $normalize_crlf( $value );

				if ( ! empty( $option['numeric'] ) ) {
					$current_value = is_numeric( $current_value ) ? $current_value + 0 : '';
				}

				$parsed[ $id ] = [
					'type'  => $type,
					'value' => $current_value,
				];
				break;

			case 'switch':
			case 'checkbox':
				$current_value = wp_validate_boolean( $value );

				$parsed[ $id ] = [
					'type'  => $type,
					'value' => $current_value,
				];
				break;

			case 'color':
			case 'media':
				$current_value = $value;

				if ( 'media' === $type && is_numeric( $current_value ) ) {
					$current_value = absint( $current_value );
				}

				$parsed[ $id ] = [
					'type'  => $type,
					'value' => $current_value,
				];
				break;

			case 'select':
			case 'images':
			case 'multicheck':
				$select_options = $option['options'] ?? [];
				$default_value  = $option['std'] ?? reset( $select_options );
				$current_value  = $value;

				if ( ! $current_value ) {
					$current_value = $default_value;
				}

				$parsed[ $id ] = [
					'type'  => $type,
					'value' => $current_value,
				];
				break;

			case 'sorter':
			case 'content_builder':
			case 'other':
				$current_value = $value;

				$parsed[ $id ] = [
					'type'  => $type,
					'value' => $current_value,
				];
				break;
		}

		if ( ! empty( $parsed[ $id ] ) ) {
			$parsed[ $id ]['exists'] = $exists;
		}
	}

	return $parsed;
}

/**
 * Migrate theme option.
 *
 * @param array $args
 *
 * @return bool
 * @since 4.1.12
 */
function kalium_migrate_theme_option( $args ) {

	$args = wp_parse_args(
		$args,
		[
			/**
			 * Option ID to migrate.
			 *
			 * @type string
			 */
			'id'             => null,

			/**
			 * New option ID.
			 *
			 * @type string
			 */
			'id_new'         => null,

			/**
			 * Map values.
			 *
			 * @type array
			 */
			'map_values'     => null,

			/**
			 * Filter value before saving.
			 *
			 * @type callable
			 */
			'filter'         => null,

			/**
			 * Validate value.
			 *
			 * @type callable
			 */
			'validate'       => null,

			/**
			 * Overwrite existing value on new option migrate.
			 *
			 * @type bool
			 */
			'overwrite'      => false,

			/**
			 * Ignore default values.
			 *
			 * @type bool
			 */
			'ignore_default' => true,

			/**
			 * Dry run, will not update the value in the database.
			 *
			 * @type bool
			 */
			'dry'            => false,

			/**
			 * Execute a callback.
			 *
			 * @type callable
			 */
			'callback'       => null,

			/**
			 * Remove old option.
			 *
			 * @type bool
			 */
			'remove_old'     => true,
		]
	);

	// Callback
	if ( is_callable( $args['callback'] ) ) {
		return (bool) call_user_func( $args['callback'], $args );
	}

	// Source
	$source      = explode( ':', $args['id'] );
	$source_type = 2 === count( $source ) && 'option' === $source[0] ? $source[0] : 'theme_mod';
	$source_id   = $source[1] ?? $source[0];

	// Destination
	$destination      = explode( ':', $args['id_new'] ?? $args['id'] );
	$destination_type = 2 === count( $destination ) && 'option' === $destination[0] ? $destination[0] : 'theme_mod';
	$destination_id   = $destination[1] ?? $destination[0];

	// Value
	if ( 'option' === $source_type ) {
		$value = get_option( $source_id, null );

		// Ignore default value
		if ( is_null( $value ) && $args['ignore_default'] ) {
			return false;
		}
	} else {
		$value = get_theme_mod( $source_id, null );
	}

	// Overwriting
	if ( false === $args['overwrite'] ) {
		if ( 'option' === $destination_type && ! is_null( get_option( $destination_id, null ) ) ) {
			return false;
		} elseif ( 'theme_mod' === $destination_type && ! is_null( get_theme_mod( $destination_id, null ) ) ) {
			return false;
		}
	}

	// Process value
	if ( is_array( $args['map_values'] ) && is_scalar( $value ) ) {
		if ( isset( $args['map_values'][ $value ] ) ) {
			$value = $args['map_values'][ $value ];
		} else {
			$value = null;
		}
	}

	if ( is_callable( $args['filter'] ) ) {
		$value = call_user_func( $args['filter'], $value, $args );
	}

	// Validate value
	if ( is_callable( $args['validate'] ) && ! call_user_func( $args['validate'], $value, $args ) ) {
		return false;
	}

	// NULL values will not be migrated
	if ( is_null( $value ) ) {
		return false;
	}

	// Get existing theme option
	if ( 'theme_mod' === $destination_type ) {
		$theme_option_args = kalium()->theme_options->get_option_args( $destination_id );
		$default_value     = kalium()->theme_options->get_default( $destination_type );

		// Responsive option
		if ( ! empty( $theme_option_args['responsive'] ) ) {
			$value = kalium_parse_responsive_value( $value );
		}

		// Ignore default value
		if ( $args['ignore_default'] && ! is_null( $default_value ) ) {
			if ( is_array( $default_value ) && $default_value == $value ) { // phpcs:ignore Universal.Operators.StrictComparisons.LooseEqual
				return false;
			} elseif ( $default_value === $value ) {
				return false;
			}
		}
	}

	// Update value
	if ( ! $args['dry'] && ! is_null( $value ) ) {
		if ( 'option' === $destination_type ) {
			update_option( $destination_id, $value );
		} else {
			set_theme_mod( $destination_id, $value );
		}
	}

	// Remove old option
	if ( $args['remove_old'] && ( $source_id !== $destination_id || $source_type !== $destination_type ) ) {
		if ( 'option' === $destination_type ) {
			delete_option( $source_id );
		} else {
			remove_theme_mod( $source_id );
		}
	}

	return true;
}

/**
 * Migrate batch of theme options.
 *
 * @param array $options
 *
 * @return array
 * @since 4.1.12
 */
function kalium_migrate_theme_options_batch( $migrations_list ) {
	$migrated = [];

	foreach ( $migrations_list as $option ) {
		if ( ! is_array( $option ) ) {
			continue;
		}

		if ( kalium_migrate_theme_option( $option ) ) {
			$migrated[] = $option;
		}
	}

	return $migrated;
}

/**
 * Migrate SMOF option.
 *
 * @param array $args
 *
 * @return bool
 */
function kalium_migrate_smof_option( $args ) {
	static $smof_values;

	$args = wp_parse_args(
		$args,
		[
			/**
			 * Option ID to migrate.
			 *
			 * @type string
			 */
			'id'             => null,

			/**
			 * New option ID.
			 *
			 * @type string
			 */
			'id_new'         => null,

			/**
			 * Map values.
			 *
			 * @type array
			 */
			'map_values'     => null,

			/**
			 * Filter value before saving.
			 *
			 * @type callable
			 */
			'filter'         => null,

			/**
			 * Validate value.
			 *
			 * @type callable
			 */
			'validate'       => null,

			/**
			 * Overwrite existing value on new option migrate.
			 *
			 * @type bool
			 */
			'overwrite'      => false,

			/**
			 * Ignore default values.
			 *
			 * @type bool
			 */
			'ignore_default' => true,

			/**
			 * Dry run, will not update the value in the database.
			 *
			 * @type bool
			 */
			'dry'            => false,

			/**
			 * Execute a callback.
			 *
			 * @type callable
			 */
			'callback'       => null,
		]
	);

	// Init SMOF values
	if ( is_null( $smof_values ) ) {
		$smof_values = kalium_get_smof_values();
	}

	// Callback
	if ( is_callable( $args['callback'] ) ) {
		return (bool) call_user_func( $args['callback'], $smof_values, $args );
	}

	// Source
	$source      = explode( ':', $args['id'] );
	$source_type = 2 === count( $source ) && 'option' === $source[0] ? $source[0] : 'theme_mod';
	$source_id   = $source[1] ?? $source[0];

	// Destination
	$destination      = explode( ':', $args['id_new'] ?? $args['id'] );
	$destination_type = 2 === count( $destination ) && 'option' === $destination[0] ? $destination[0] : 'theme_mod';
	$destination_id   = $destination[1] ?? $destination[0];

	// Value
	if ( 'option' === $source_type ) {
		$value = get_option( $source_id, null );

		// Ignore default value
		if ( is_null( $value ) && $args['ignore_default'] ) {
			return false;
		}
	} else {
		// Theme mod does not exist
		if ( ! isset( $smof_values[ $source_id ] ) ) {
			return false;
		}

		$smof_option = $smof_values[ $source_id ];
		$value       = $smof_option['value'];

		if ( ! $smof_option['exists'] ) {
			return false;
		}
	}

	// Overwriting
	if ( false === $args['overwrite'] ) {
		if ( 'option' === $destination_type && ! is_null( get_option( $destination_id, null ) ) ) {
			return false;
		} elseif ( 'theme_mod' === $destination_type && ! is_null( get_theme_mod( $destination_id, null ) ) ) {
			return false;
		}
	}

	// Process value
	if ( is_array( $args['map_values'] ) && is_scalar( $value ) ) {
		if ( isset( $args['map_values'][ $value ] ) ) {
			$value = $args['map_values'][ $value ];
		} else {
			$value = null;
		}
	}

	if ( is_callable( $args['filter'] ) ) {
		$value = call_user_func( $args['filter'], $value, $smof_values, $args );
	}

	// Validate value
	if ( is_callable( $args['validate'] ) && ! call_user_func( $args['validate'], $value, $smof_values ) ) {
		return false;
	}

	// NULL values will not be migrated
	if ( is_null( $value ) ) {
		return false;
	}

	// Get existing theme option
	if ( 'theme_mod' === $destination_type ) {
		$theme_option_args = kalium()->theme_options->get_option_args( $destination_id );
		$default_value     = kalium()->theme_options->get_default( $destination_type );

		// Responsive option
		if ( ! empty( $theme_option_args['responsive'] ) ) {
			$value = kalium_parse_responsive_value( $value );
		}

		// Ignore default value
		if ( $args['ignore_default'] && ! is_null( $default_value ) ) {
			if ( is_array( $default_value ) && $default_value == $value ) { // phpcs:ignore Universal.Operators.StrictComparisons.LooseEqual
				return false;
			} elseif ( $default_value === $value ) {
				return false;
			}
		}
	}

	// Update value
	if ( ! $args['dry'] && ! is_null( $value ) ) {
		if ( 'option' === $destination_type ) {
			update_option( $destination_id, $value );
		} else {
			set_theme_mod( $destination_id, $value );
		}
	}

	return true;
}

/**
 * Migrate batch of SMOF options.
 *
 * @param array $options
 *
 * @return array
 */
function kalium_migrate_smof_batch( $migrations_list ) {
	$migrated = [];

	foreach ( $migrations_list as $option ) {
		if ( is_string( $option ) ) {
			$option = [
				'id' => $option,
			];
		}

		if ( kalium_migrate_smof_option( $option ) ) {
			$migrated[] = $option;
		}
	}

	return $migrated;
}

/**
 * Migrate ACF field.
 *
 * @param array $args
 *
 * @return bool
 */
function kalium_migrate_acf_field( $args ) {
	global $wpdb;

	$args = wp_parse_args(
		$args,
		[
			/**
			 * Legacy field name.
			 *
			 * @type string
			 */
			'id'          => null,

			/**
			 * New field name.
			 *
			 * @type string
			 */
			'id_new'      => null,

			/**
			 * Before date.
			 *
			 * @type int
			 */
			'before_date' => time(),

			/**
			 * Filter value.
			 *
			 * @type callable
			 */
			'filter'      => null,
		]
	);

	// ACF not active
	if ( ! kalium()->is->acf_active() ) {
		return false;
	}

	$source_id      = $args['id'];
	$destination_id = $args['id_new'] ?? $args['id'];

	// Find post meta
	$post_meta = $wpdb->get_results(
		$wpdb->prepare(
			"SELECT t1.* FROM {$wpdb->postmeta} t1 INNER JOIN {$wpdb->posts} t2 ON t1.post_id = t2.ID WHERE t1.meta_key = %s AND t2.post_type <> %s AND t2.post_date_gmt < %s",
			$source_id,
			'revision',
			date( 'Y-m-d H:i:s', $args['before_date'] )
		),
		ARRAY_A
	);

	// Number of changed entries
	$changed = 0;

	// Updated post meta
	$updated_post_meta = kalium_get_upgrader_data( 'updated_post_meta', [] );

	foreach ( $post_meta as $entry ) {
		$post_id = (int) $entry['post_id'];
		$key     = $entry['meta_key'];
		$value   = $entry['meta_value'];

		// Skip updated meta key
		if ( isset( $updated_post_meta[ $key ] ) && in_array( $post_id, $updated_post_meta[ $key ] ) ) {
			// continue;
		} else {
			$updated_post_meta[ $key ][] = $post_id;
		}

		// Filter value
		if ( is_callable( $args['filter'] ) ) {
			$value = call_user_func( $args['filter'], $value, $post_id );
		}

		// Skip null values
		if ( is_null( $value ) ) {
			continue;
		}

		// Update field
		update_field( $destination_id, $value, $post_id );

		// Increase changed fields number
		++$changed;
	}

	// Update post meta tracker array
	kalium_set_upgrader_data( 'updated_post_meta', $updated_post_meta );

	return $changed > 0;
}

/**
 * Migrate batch of ACF fields.
 *
 * @param array $migrations_list
 *
 * @return array
 */
function kalium_migrate_acf_batch( $migrations_list ) {
	$migrated = [];

	foreach ( $migrations_list as $field ) {
		if ( kalium_migrate_acf_field( $field ) ) {
			$migrated[] = $field;
		}
	}

	return $migrated;
}

/**
 * Make sure the theme option does not exists.
 *
 * @param string $option_name
 *
 * @return bool
 */
function kalium_can_override_theme_option( $option_name ) {
	return null === get_theme_mod( $option_name, null );
}

/**
 * Handles media type option.
 *
 * @param int $id
 *
 * @return array|null
 */
function kalium_smof_media_type_option( $id ) {
	if ( is_numeric( $id ) ) {
		return wp_prepare_attachment_for_js( $id );
	}

	return null;
}

/**
 * Add PX unit to numeric values.
 *
 * @param int|string $value
 *
 * @return string
 */
function kalium_smof_filter_add_px_unit( $value ) {
	if ( is_numeric( $value ) ) {
		return $value .= 'px';
	}

	return $value;
}

/**
 * Social networks convert filter.
 *
 * @param array $value
 * @param array $smof_values
 *
 * @return array
 */
function kalium_smof_filter_social_networks( $value, $smof_values ) {
	$social_networks_mapping = [
		'fb'  => 'kalium_social_icon_facebook',
		'tw'  => 'kalium_social_icon_twitter_x',
		'ig'  => 'kalium_social_icon_instagram',
		'vm'  => 'kalium_social_icon_vimeo',
		'be'  => 'kalium_social_icon_behance',
		'fs'  => 'kalium_social_icon_foursquare',
		'lin' => 'kalium_social_icon_linkedin',
		'yt'  => 'kalium_social_icon_youtube',
		'drb' => 'kalium_social_icon_dribbble',
		'pi'  => 'kalium_social_icon_pinterest',
		'vk'  => 'kalium_social_icon_vkontakte',
		'da'  => 'kalium_social_icon_deviant_art',
		'fl'  => 'kalium_social_icon_flickr',
		'tu'  => 'kalium_social_icon_tumblr',
		'sk'  => 'kalium_social_icon_skype',
		'gh'  => 'kalium_social_icon_github',
		'sc'  => 'kalium_social_icon_soundcloud',
		'hz'  => 'kalium_social_icon_houzz',
		'px'  => 'kalium_social_icon_500px',
		'xi'  => 'kalium_social_icon_xing',
		'sp'  => 'kalium_social_icon_spotify',
		'sn'  => 'kalium_social_icon_snapchat',
		'em'  => 'kalium_social_icon_email',
		'yp'  => 'kalium_social_icon_yelp',
		'ta'  => 'kalium_social_icon_tripadvisor',
		'tc'  => 'kalium_social_icon_twitch',
		'tt'  => 'kalium_social_icon_tiktok',
		'wa'  => 'kalium_social_icon_whatsapp',
		'ph'  => 'kalium_social_icon_phone',
	];

	if ( isset( $value['visible'] ) ) {
		$social_order_visible = $value['visible'];
		$social_icons         = [
			'elements' => [],
		];

		// Remove placebo
		unset( $social_order_visible['placebo'] );

		foreach ( $social_order_visible as $network => $element_name ) {

			// Custom
			if ( 'custom' === $network ) {
				$social_icons['elements'][] = [
					'name'       => 'kalium_social_icon_custom',
					'attributes' => [
						[
							'name'  => 'label',
							'value' => kalium_get_array_key( $smof_values, 'social_network_custom_link_title/value' ),
						],
						[
							'name'  => 'link',
							'value' => kalium_get_array_key( $smof_values, 'social_network_custom_link_link/value' ),
						],
						[
							'name'  => 'icon_type',
							'value' => 'inline-html',
						],
						[
							'name'  => 'icon_inline_html',
							'value' => sprintf( '<i class="%s"></i>', esc_attr( kalium_get_array_key( $smof_values, 'social_network_custom_link_icon/value' ) ) ),
						],
					],
				];
			} elseif ( isset( $social_networks_mapping[ $network ] ) ) {
				$social_icons['elements'][] = [
					'name'       => $social_networks_mapping[ $network ],
					'attributes' => [
						[
							'name'  => 'link',
							'value' => kalium_get_array_key( $smof_values, 'social_network_link_' . $network . '/value' ),
						],
					],
				];
			}
		}

		return $social_icons;
	}
}

/**
 * Share to social networks filter.
 *
 * @param array $value
 *
 * @return array
 */
function kalium_smof_filter_share_networks( $value ) {
	// Social share networks
	$social_share_networks = [
		'fb'  => 'social_share_link_facebook',
		'tw'  => 'social_share_link_twitter',
		'lin' => 'social_share_link_linkedin',
		'tlr' => 'social_share_link_tumblr',
		'pi'  => 'social_share_link_pinterest',
		'em'  => 'social_share_link_email',
		'vk'  => 'social_share_link_vkontakte',
		'wa'  => 'social_share_link_whatsapp',
		'te'  => 'social_share_link_telegram',
		'pr'  => 'social_share_link_print',
	];

	if ( isset( $value['visible'] ) ) {
		$blog_share_story_networks_content = [];

		foreach ( $value['visible'] as $network_id => $network_title ) {
			if ( isset( $social_share_networks[ $network_id ] ) ) {
				$blog_share_story_networks_content[] = [
					'name'       => $social_share_networks[ $network_id ],
					'attributes' => [],
				];
			}
		}

		return [
			'elements' => $blog_share_story_networks_content,
		];
	}
}

/**
 * Menu ID filter.
 *
 * @param string $value
 *
 * @return string
 */
function kalium_smof_filter_menu_id( $value ) {
	$menu_choices = wp_list_pluck( wp_get_nav_menus(), 'slug', 'term_id' );
	$value        = str_replace( 'menu-', '', $value );

	if ( isset( $menu_choices[ $value ] ) ) {
		return $menu_choices[ $value ];
	} elseif ( '-' === $value ) {
		return $value;
	}
}

/**
 * Converter from legacy content builder to new Laborator Builder.
 *
 * @param string $json
 *
 * @return array
 */
function kalium_smof_convert_legacy_header_builder_content( $json ) {
	$data     = json_decode( $json, true );
	$elements = [];
	$align    = null;

	if ( $data ) {
		$align        = $data['alignment'] ?? null;
		$legacy_items = $data['entries'] ?? null;

		if ( is_array( $legacy_items ) ) {
			foreach ( $legacy_items as $item ) {
				$element    = null;
				$options    = kalium_get_array_key( $item, 'options' );
				$hide_on    = kalium_get_array_key( $options, 'hide_on', [] );
				$visible_on = [
					'name'  => 'visible_on',
					'value' => null,
				];

				if ( ! empty( $hide_on ) ) {
					foreach ( [ 'desktop', 'tablet', 'mobile' ] as $device ) {
						if ( ! in_array( $device, $hide_on ) ) {
							if ( ! is_array( $visible_on['value'] ) ) {
								$visible_on['value'] = [];
							}

							$visible_on['value'][] = $device;
						}
					}
				}

				switch ( $item['contentType'] ) {

					// Raw Text
					case 'raw-text':
						$element = [
							'name'       => 'legacy_header_raw_text',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'content',
										'value' => kalium_get_array_key( $options, 'text' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// Date Time
					case 'date-time':
						$element = [
							'name'       => 'legacy_header_date_time',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'date_format',
										'value' => kalium_get_array_key( $options, 'date_format' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// Search Field
					case 'search-field':
						$element = [
							'name'       => 'legacy_header_search_field',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'align',
										'value' => kalium_get_array_key( $options, 'align' ),
									],
									[
										'name'  => 'input_visibility',
										'value' => kalium_get_array_key( $options, 'input_visibility' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// Social Networks
					case 'social-networks':
						$attributes = [];

						$display_structure = kalium_get_array_key( $options, 'display_structure' );

						// Icon
						$attributes[] = [
							'name'  => 'icon',
							'value' => in_array( $display_structure, [ 'icon', 'icon-title' ] ),
						];

						// Label
						$attributes[] = [
							'name'  => 'label',
							'value' => in_array( $display_structure, [ 'title', 'icon-title' ] ),
						];

						switch ( kalium_get_array_key( $options, 'style' ) ) {

							// Colored
							case 'colored':
								$attributes[] = [
									'name'  => 'color',
									'value' => 'brand',
								];
								break;

							// Colored hover
							case 'colored-hover':
								$attributes[] = [
									'name'  => 'color_hover',
									'value' => 'brand',
								];
								break;

							// Colored background
							case 'colored-bg':
								$attributes[] = [
									'name'  => 'shape_type',
									'value' => 'square',
								];

								$attributes[] = [
									'name'  => 'background',
									'value' => 'brand',
								];
								break;

							// Colored background hover
							case 'colored-bg-hover':
								$attributes[] = [
									'name'  => 'shape_type',
									'value' => 'square',
								];

								$attributes[] = [
									'name'  => 'background_hover',
									'value' => 'brand',
								];
								break;

							// Rounded
							case 'rounded':
								$attributes[] = [
									'name'  => 'shape_type',
									'value' => 'rounded',
								];
								break;

							// Rounded colored
							case 'rounded-colored':
								$attributes[] = [
									'name'  => 'shape_type',
									'value' => 'rounded',
								];

								$attributes[] = [
									'name'  => 'background',
									'value' => 'brand',
								];
								break;

							// Rounded colored hover
							case 'rounded-colored-hover':
								$attributes[] = [
									'name'  => 'shape_type',
									'value' => 'rounded',
								];

								$attributes[] = [
									'name'  => 'background_hover',
									'value' => 'brand',
								];
								break;
						}

						$element = [
							'name'       => 'legacy_header_social_icons',
							'visible'    => true,
							'attributes' => array_merge( $attributes, [ $visible_on ] ),
						];
						break;

					// Breadcrumb
					case 'breadcrumb':
						$element = [
							'name'       => 'legacy_header_breadcrumb',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'separator',
										'value' => kalium_get_array_key( $options, 'separator' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// WPML Language Switcher
					case 'wpml-language-switcher':
						$flag_position       = kalium_get_array_key( $options, 'flag_position' );
						$display_text_format = kalium_get_array_key( $options, 'display_text_format' );

						$element = [
							'name'       => 'legacy_header_wpml_language_switcher',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'show_on',
										'value' => kalium_get_array_key( $options, 'show_on' ),
									],
									[
										'name'  => 'flag',
										'value' => 'hide' !== $flag_position,
									],
									[
										'name'  => 'flag_position',
										'value' => in_array( $flag_position, [ 'left', 'right' ] ) ? $flag_position : null,
									],
									[
										'name'  => 'display_text',
										'value' => 'hide' !== $display_text_format,
									],
									[
										'name'  => 'display_text_format',
										'value' => 'hide' !== $display_text_format ? $display_text_format : null,
									],
									[
										'name'  => 'skip_missing',
										'value' => in_array( 'yes', kalium_get_array_key( $options, 'skip_missing', [] ) ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// WooCommerce mini cart
					case 'woocommerce-mini-cart':
						$element = [
							'name'       => 'legacy_header_woocommerce_mini_cart',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'title',
										'value' => kalium_get_array_key( $options, 'title' ),
									],
									[
										'name'  => 'cart_popup',
										'value' => true,
									],
									[
										'name'  => 'popup_align',
										'value' => kalium_get_array_key( $options, 'align' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// WooCommerce Cart Totals
					case 'woocommerce-cart-totals':
						$element = [
							'name'       => 'legacy_header_woocommerce_cart_totals',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'total_price',
										'value' => kalium_get_array_key( $options, 'total_price' ),
									],
									[
										'name'  => 'text_before',
										'value' => kalium_get_array_key( $options, 'text_before' ),
									],
									[
										'name'  => 'hide_empty',
										'value' => 'yes' === kalium_get_array_key( $options, 'hide_empty' ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// WooCommerce Account Link
					case 'woocommerce-account-link':
						$element = [
							'name'       => 'legacy_header_woocommerce_my_account_link',
							'visible'    => true,
							'attributes' => array_merge(
								[
									[
										'name'  => 'login_text',
										'value' => kalium_get_array_key( $options, 'login_text' ),
									],
									[
										'name'  => 'logged_in_text',
										'value' => kalium_get_array_key( $options, 'logged_in_text' ),
									],
									[
										'name'  => 'link_icon',
										'value' => in_array( 'yes', kalium_get_array_key( $options, 'link_icon', [] ) ),
									],
								],
								[ $visible_on ]
							),
						];
						break;

					// Standard menu toggle
					case 'open-standard-menu':
						$menu_id = kalium_get_array_key( $options, 'menu_id' );

						if ( 0 === strpos( $menu_id, 'menu-' ) ) {
							$menu_id = (int) str_replace( 'menu-', '', $menu_id );
						}

						$attributes = [
							[
								'name'  => 'menu_id',
								'value' => $menu_id,
							],
							[
								'name'  => 'standard_menu_position',
								'value' => str_replace( 'beginning', 'start', kalium_get_array_key( $options, 'menu_position' ) ),
							],
							[
								'name'  => 'standard_menu_animation',
								'value' => kalium_get_array_key( $options, 'toggle_effect' ),
							],
							[
								'name'  => 'standard_menu_animation_direction',
								'value' => kalium_get_array_key( $options, 'stagger_direction' ),
							],
							[
								'name'  => 'standard_menu_dropdown_caret',
								'value' => 'yes' === kalium_get_array_key( $options, 'submenu_dropdown_caret' ),
							],
						];

						$element = [
							'name'       => 'legacy_header_menu_trigger',
							'visible'    => true,
							'attributes' => array_merge( $attributes, [ $visible_on ] ),
						];
						break;

					// Fullscreen menu toggle
					case 'open-fullscreen-menu':
						$attributes = [
							[
								'name'  => 'trigger_type',
								'value' => 'fullscreen',
							],
							[
								'name'  => 'search_field',
								'value' => in_array( 'yes', kalium_get_array_key( $options, 'search_field', [] ) ),
							],
						];

						$element = [
							'name'       => 'legacy_header_menu_trigger',
							'visible'    => true,
							'attributes' => array_merge( $attributes, [ $visible_on ] ),
						];
						break;

					// Off-canvas side menu toggle
					case 'open-sidebar-menu':
						$attributes = [
							[
								'name'  => 'trigger_type',
								'value' => 'off-canvas-side',
							],
						];

						$element = [
							'name'       => 'legacy_header_menu_trigger',
							'visible'    => true,
							'attributes' => array_merge( $attributes, [ $visible_on ] ),
						];
						break;

					// Off-canvas top menu toggle
					case 'open-top-menu':
						$attributes = [
							[
								'name'  => 'trigger_type',
								'value' => 'off-canvas-top',
							],
						];

						$element = [
							'name'       => 'legacy_header_menu_trigger',
							'visible'    => true,
							'attributes' => array_merge( $attributes, [ $visible_on ] ),
						];
						break;

					// Menu
					default:
						if ( 0 === strpos( $item['contentType'], 'menu-' ) ) {
							$menu_id = (int) str_replace( 'menu-', '', $item['contentType'] );
						} elseif ( 'main-menu' === $item['contentType'] ) {
							$menu_id = 'main-menu';
						}

						if ( ! empty( $menu_id ) ) {
							$legacy_mobile_menu_toggle_position = kalium_get_array_key( $options, 'mobile_menu_toggle_position' );
							$mobile_menu_toggle                 = in_array( $legacy_mobile_menu_toggle_position, [ 'current', 'beginning', 'end' ] );
							$mobile_menu_toggle_position        = 'end';

							if ( 'current' === $legacy_mobile_menu_toggle_position ) {
								$mobile_menu_toggle_position = 'current';
							} elseif ( 'beginning' === $legacy_mobile_menu_toggle_position ) {
								$mobile_menu_toggle_position = 'start';
							}

							$attributes = [
								[
									'name'  => 'menu_id',
									'value' => $menu_id,
								],
								[
									'name'  => 'submenu_dropdown_caret',
									'value' => 'yes' === kalium_get_array_key( $options, 'submenu_dropdown_caret' ),
								],
								[
									'name'  => 'mobile_menu_toggle',
									'value' => $mobile_menu_toggle,
								],
								[
									'name'  => 'mobile_menu_toggle_position',
									'value' => $mobile_menu_toggle_position,
								],
							];

							$element = [
								'name'       => 'legacy_header_menu',
								'visible'    => true,
								'attributes' => array_merge( $attributes, [ $visible_on ] ),
							];
						}
				}

				// Add element
				if ( ! is_null( $element ) ) {
					// Filter attributes
					$element['attributes'] = array_filter(
						$element['attributes'],
						function ( $attribute ) {
							return ! is_null( $attribute['value'] );
						}
					);

					$elements[] = $element;
				}
			}
		}
	}

	return [
		'align'    => $align,
		'elements' => $elements,
	];
}

/**
 * Custom header builder filter.
 *
 * @param string $value
 * @param array  $smof_values
 *
 * @return array
 */
function kalium_smof_filter_custom_header_content( $value, $smof_values ) {
	if ( 'custom-header' !== $value ) {
		return;
	}

	$content_left   = kalium_get_array_key( $smof_values, 'custom_header_content_left/value' );
	$content_right  = kalium_get_array_key( $smof_values, 'custom_header_content_right/value' );
	$content_bottom = kalium_get_array_key( $smof_values, 'custom_header_content/value' );

	$content_parts = array_map(
		'kalium_smof_convert_legacy_header_builder_content',
		[
			'left'   => $content_left,
			'right'  => $content_right,
			'bottom' => $content_bottom,
		]
	);

	try {
		$content_left_align   = @json_decode( $content_left, true )['alignment'];
		$content_right_align  = @json_decode( $content_right, true )['alignment'];
		$content_bottom_align = @json_decode( $content_bottom, true )['alignment'];
	} catch ( Exception $e ) {
	}

	$header_content = [
		'elements' => [

			// Left content
			[
				'name'       => 'legacy_header_content_left',
				'attributes' => [
					[
						'name'  => 'align',
						'value' => $content_left_align ?? 'left',
					],
				],
				'visible'    => 'logo-centered' === kalium_get_array_key( $smof_values, 'custom_header_type/value' ),
				'elements'   => kalium_get_array_key( $content_parts, 'left/elements' ),
			],

			// Right content
			[
				'name'       => 'legacy_header_content_right',
				'attributes' => [
					[
						'name'  => 'align',
						'value' => $content_right_align ?? 'right',
					],
				],
				'visible'    => true,
				'elements'   => kalium_get_array_key( $content_parts, 'right/elements' ),
			],

			// Bottom content
			[
				'name'       => 'legacy_header_content_bottom',
				'attributes' => [
					[
						'name'  => 'align',
						'value' => $content_bottom_align ?? 'left',
					],
				],
				'visible'    => true,
				'elements'   => kalium_get_array_key( $content_parts, 'bottom/elements' ),
			],
		],
	];

	if ( ! empty( $header_content['elements'] ) ) {
		return $header_content;
	}
}

/**
 * Top header bar builder filter.
 *
 * @param string $value
 * @param array  $smof_values
 *
 * @return array
 */
function kalium_smof_filter_top_header_content( $value, $smof_values ) {
	if ( ! $value ) {
		return;
	}

	$content_left  = kalium_get_array_key( $smof_values, 'top_header_bar_content_left/value' );
	$content_right = kalium_get_array_key( $smof_values, 'top_header_bar_content_right/value' );

	try {
		$content_left_align  = @json_decode( $content_left, true )['alignment'];
		$content_right_align = @json_decode( $content_right, true )['alignment'];
	} catch ( Exception $e ) {
	}

	$content_parts = array_map(
		'kalium_smof_convert_legacy_header_builder_content',
		[
			'left'  => $content_left,
			'right' => $content_right,
		]
	);

	$header_content = [
		'elements' => [

			// Left content
			[
				'name'       => 'legacy_header_content_left',
				'attributes' => [
					[
						'name'  => 'align',
						'value' => $content_left_align ?? 'left',
					],
				],
				'visible'    => true,
				'elements'   => kalium_get_array_key( $content_parts, 'left/elements' ),
			],

			// Right content
			[
				'name'       => 'legacy_header_content_right',
				'attributes' => [
					[
						'name'  => 'align',
						'value' => $content_right_align ?? 'right',
					],
				],
				'visible'    => true,
				'elements'   => kalium_get_array_key( $content_parts, 'right/elements' ),
			],
		],
	];

	if ( ! empty( $header_content['elements'] ) ) {
		return $header_content;
	}
}

/**
 * Transform product card to Laborator Builder.
 *
 * @param string $value
 * @param array  $smof_values
 *
 * @return array
 */
function kalium_smof_filter_product_card( $value, $smof_values ) {
	$template = [
		'id'               => 1,
		'name'             => 'Migrated Grid Card',
		'template_content' => [],
		'timestamp'        => time(),
	];

	/**
	 * Clear empty elements.
	 *
	 * @param array $element
	 */
	$clear_empty_elements = function ( &$element ) use ( &$clear_empty_elements ) {
		if ( ! empty( $element['elements'] ) ) {
			$element['elements'] = array_values( array_filter( $element['elements'] ) );

			foreach ( $element['elements'] as & $element ) {
				$clear_empty_elements( $element );
			}
		}
	};

	// Vars
	$gallery_types    = [
		'fade'    => 'second-image-hover',
		'gallery' => 'product-gallery',
		'none'    => 'featured-image',
	];
	$gallery_type     = $gallery_types[ kalium_get_array_key( $smof_values, 'shop_item_preview_type/value' ) ] ?? $gallery_types['none'];
	$show_category    = kalium_get_array_key( $smof_values, 'shop_product_category_listing/value' );
	$show_add_to_cart = kalium_get_array_key( $smof_values, 'shop_add_to_cart_listing/value' );
	$show_price       = kalium_get_array_key( $smof_values, 'shop_product_price_listing/value' );

	switch ( $value ) {
		// Default
		case 'default':
			$element_category    = [
				'name'       => 'woocommerce_product_category',
				'attributes' => [
					[
						'name'  => 'font_size',
						'value' => [
							'desktop' => '1rem',
							'tablet'  => null,
							'mobile'  => null,
						],
					],
				],
				'visible'    => true,
			];
			$element_add_to_cart = [
				'name'       => 'woocommerce_product_add_to_cart',
				'attributes' => [
					[
						'name'  => 'display_type',
						'value' => 'link',
					],
					[
						'name'  => 'structure',
						'value' => 'text',
					],
					[
						'name'  => 'font_size',
						'value' => [
							'desktop' => '1rem',
							'tablet'  => null,
							'mobile'  => null,
						],
					],
				],
				'visible'    => true,
			];

			if ( $show_category && $show_add_to_cart ) {
				$element_under_title = [
					'name'       => 'woocommerce_product_swap_on_hover',
					'attributes' => [
						[
							'name'  => 'animation_type',
							'value' => 'fade',
						],
					],
					'visible'    => true,
					'elements'   => [
						$element_category,
						$element_add_to_cart,
					],
				];
			} elseif ( $show_category ) {
				$element_under_title = $element_category;
			} elseif ( $show_add_to_cart ) {
				$element_under_title = $element_add_to_cart;
			}

			$template['template_content'] = [
				'elements' => [
					[
						'name'       => 'woocommerce_product_images',
						'attributes' => [
							[
								'name'  => 'gallery_type',
								'value' => $gallery_type,
							],
							[
								'name'  => 'gallery_navigation_arrows',
								'value' => true,
							],
							[
								'name'  => 'gallery_navigation_arrows_visible_on_hover',
								'value' => true,
							],
							[
								'name'  => 'gallery_navigation_arrows_size',
								'value' => 'large',
							],
							[
								'name'  => 'gallery_navigation_arrows_type',
								'value' => 'type-2',
							],
							[
								'name'  => 'gallery_navigation_arrows_style',
								'value' => [
									'background' => null,
									'text'       => 'kalium-color(theme_colors.color-1)',
								],
							],
							[
								'name'  => 'gallery_pagination',
								'value' => false,
							],
							[
								'name'  => 'gallery_navigation_effect',
								'value' => 'fade',
							],
						],
						'visible'    => true,
						'elements'   => [
							[
								'name'       => 'woocommerce_product_sale_badge',
								'attributes' => [
									[
										'name'  => 'badge_style',
										'value' => 'circle',
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'badge_size_fixed',
										'value' => true,
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => -1,
												'right'  => -1,
												'bottom' => null,
												'left'   => null,
												'link'   => false,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'font_size',
										'value' => [
											'desktop' => '0.85rem',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
								],
								'visible'    => true,
							],
						],
					],
					[
						'name'       => 'woocommerce_product_row',
						'attributes' => [],
						'visible'    => true,
						'elements'   => [
							[
								'name'       => 'woocommerce_product_column',
								'attributes' => [],
								'visible'    => true,
								'elements'   => [
									[
										'name'       => 'woocommerce_product_title',
										'attributes' => [
											[
												'name'  => 'margin',
												'value' => [
													'desktop' => [
														'top' => null,
														'right' => null,
														'bottom' => 5,
														'left' => null,
														'link' => false,
														'unit' => 'px',
													],
													'tablet' => null,
													'mobile' => null,
												],
											],
										],
										'visible'    => true,
									],
									$element_under_title ?? null,
								],
							],
							$show_price ? [
								'name'       => 'woocommerce_product_column',
								'attributes' => [
									[
										'name'  => 'columns',
										'value' => [
											'desktop' => 'auto',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
								],
								'visible'    => true,
								'elements'   => [
									[
										'name'       => 'woocommerce_product_price',
										'attributes' => [],
										'visible'    => true,
									],
								],
							] : null,
						],
					],
				],
			];
			break;

		// Full background
		case 'full-bg':
			$template['template_content'] = [
				'elements' => [
					[
						'name'       => 'woocommerce_product_images',
						'attributes' => [],
						'visible'    => true,
						'elements'   => [
							[
								'name'       => 'woocommerce_product_sale_badge',
								'attributes' => [
									[
										'name'  => 'badge_style',
										'value' => 'circle',
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'badge_size_fixed',
										'value' => true,
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => -1,
												'right'  => -1,
												'bottom' => null,
												'left'   => null,
												'link'   => false,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'z_index',
										'value' => 10,
									],
								],
								'visible'    => true,
							],
							[
								'name'       => 'woocommerce_product_row',
								'attributes' => [
									[
										'name'  => 'margin',
										'value' => [
											'desktop' => [
												'top'    => 0,
												'right'  => 0,
												'bottom' => 0,
												'left'   => 0,
												'link'   => true,
												'unit'   => 'px',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'background_color',
										'value' => 'kalium-color(theme_colors.color-1, 0.95)',
									],
									[
										'name'  => 'padding',
										'value' => [
											'desktop' => [
												'top'    => 0,
												'right'  => 0,
												'bottom' => 0,
												'left'   => 0,
												'link'   => true,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => 0,
												'right'  => 0,
												'bottom' => 0,
												'left'   => 0,
												'link'   => true,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'link_color',
										'value' => 'kalium-color(theme_colors.color-7)',
									],
									[
										'name'  => 'link_color_hover',
										'value' => 'kalium-color(theme_colors.color-8)',
									],
									[
										'name'  => 'width',
										'value' => [
											'desktop' => [
												'size' => 100,
												'unit' => '%',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'height',
										'value' => [
											'desktop' => [
												'size' => 100,
												'unit' => '%',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'visibility',
										'value' => [
											'desktop' => 'hover',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'hover_animation',
										'value' => 'fade',
									],
								],
								'visible'    => true,
								'elements'   => [
									[
										'name'       => 'woocommerce_product_column',
										'attributes' => [
											[
												'name'  => 'padding',
												'value' => [
													'desktop' => [
														'top'    => 1.5,
														'right'  => 1.5,
														'bottom' => 1.5,
														'left'   => 1.5,
														'link'   => true,
														'unit'   => 'rem',
													],
													'tablet'  => null,
													'mobile'  => null,
												],
											],
										],
										'visible'    => true,
										'elements'   => [
											[
												'name'     => 'woocommerce_product_row',
												'attributes' => [],
												'visible'  => true,
												'elements' => [
													[
														'name'       => 'woocommerce_product_column',
														'attributes' => [],
														'visible'    => true,
														'elements'   => [
															[
																'name'       => 'woocommerce_product_title',
																'attributes' => [
																	[
																		'name'  => 'margin',
																		'value' => [
																			'desktop' => [
																				'top'    => null,
																				'right'  => null,
																				'bottom' => 0.5,
																				'left'   => null,
																				'link'   => false,
																				'unit'   => 'rem',
																			],
																			'tablet'  => null,
																			'mobile'  => null,
																		],
																	],
																	[
																		'name'  => 'visibility',
																		'value' => [
																			'desktop' => 'hover',
																			'tablet'  => null,
																			'mobile'  => null,
																		],
																	],
																	[
																		'name'  => 'hover_animation',
																		'value' => 'fade-up',
																	],
																	[
																		'name'  => 'hover_animation_delay',
																		'value' => '100',
																	],
																],
																'visible'    => true,
															],
															$show_category ? [
																'name'       => 'woocommerce_product_category',
																'attributes' => [
																	[
																		'name'  => 'visibility',
																		'value' => [
																			'desktop' => 'hover',
																			'tablet'  => null,
																			'mobile'  => null,
																		],
																	],
																	[
																		'name'  => 'hover_animation',
																		'value' => 'fade-up',
																	],
																	[
																		'name'  => 'hover_animation_delay',
																		'value' => '150',
																	],
																],
																'visible'    => true,
															] : null,
														],
													],
												],
											],
											$show_price || $show_add_to_cart ? [
												'name'     => 'woocommerce_product_row',
												'attributes' => [
													[
														'name'  => 'css_position',
														'value' => [
															'desktop' => 'absolute',
															'tablet'  => null,
															'mobile'  => null,
														],
													],
													[
														'name'  => 'position_offset',
														'value' => [
															'desktop' => [
																'top'    => null,
																'right'  => 1.5,
																'bottom' => 1.5,
																'left'   => 1.5,
																'link'   => false,
																'unit'   => 'rem',
															],
															'tablet'  => null,
															'mobile'  => null,
														],
													],
													[
														'name'  => 'visibility',
														'value' => [
															'desktop' => 'hover',
															'tablet'  => null,
															'mobile'  => null,
														],
													],
													[
														'name'  => 'hover_animation',
														'value' => 'fade-up',
													],
													[
														'name'  => 'hover_animation_delay',
														'value' => '200',
													],
												],
												'visible'  => true,
												'elements' => [
													$show_price ? [
														'name'       => 'woocommerce_product_column',
														'attributes' => [
															[
																'name'  => 'margin',
																'value' => [
																	'desktop' => [
																		'top'    => null,
																		'right'  => null,
																		'bottom' => 0,
																		'left'   => null,
																		'link'   => false,
																		'unit'   => 'px',
																	],
																	'tablet'  => null,
																	'mobile'  => null,
																],
															],
														],
														'visible'    => true,
														'elements'   => [
															[
																'name'       => 'woocommerce_product_price',
																'attributes' => [
																	[
																		'name'  => 'margin',
																		'value' => [
																			'desktop' => [
																				'top'    => null,
																				'right'  => null,
																				'bottom' => 0,
																				'left'   => null,
																				'link'   => false,
																				'unit'   => 'px',
																			],
																			'tablet'  => null,
																			'mobile'  => null,
																		],
																	],
																	[
																		'name'  => 'custom_css',
																		'value' => "#self {\n\tcolor: #FFF;\n}",
																	],
																],
																'visible'    => true,
															],
														],
													] : null,
													$show_add_to_cart ? [
														'name'       => 'woocommerce_product_column',
														'attributes' => [
															[
																'name'  => 'horizontal_align',
																'value' => [
																	'desktop' => 'end',
																	'tablet'  => null,
																	'mobile'  => null,
																],
															],
															[
																'name'  => 'columns',
																'value' => [
																	'desktop' => 'auto',
																	'tablet'  => null,
																	'mobile'  => null,
																],
															],
														],
														'visible'    => true,
														'elements'   => [
															[
																'name'       => 'woocommerce_product_add_to_cart',
																'attributes' => [
																	[
																		'name'  => 'display_type',
																		'value' => 'link',
																	],
																	[
																		'name'  => 'structure',
																		'value' => 'icon',
																	],
																	[
																		'name'  => 'tooltip_hover',
																		'value' => true,
																	],
																	[
																		'name'  => 'tooltip_added',
																		'value' => true,
																	],
																	[
																		'name'  => 'tooltip_placement',
																		'value' => $show_price ? 'left' : 'right',
																	],
																	[
																		'name'  => 'button_icon',
																		'value' => 'icon-2',
																	],
																	[
																		'name'  => 'font_size',
																		'value' => [
																			'desktop' => '1.5rem',
																			'tablet'  => null,
																			'mobile'  => null,
																		],
																	],
																],
																'visible'    => true,
															],
														],
													] : null,
												],
											] : null,
										],
									],
								],
							],
						],
					],
				],
			];
			break;

		// Distanced centered
		case 'distanced-centered':
			$template['template_content'] = [
				'elements' => [
					[
						'name'       => 'woocommerce_product_images',
						'attributes' => [],
						'visible'    => true,
						'elements'   => [
							[
								'name'       => 'woocommerce_product_row',
								'attributes' => [
									[
										'name'  => 'horizontal_align',
										'value' => [
											'desktop' => 'center',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'margin',
										'value' => [
											'desktop' => [
												'top'    => 0,
												'right'  => 0,
												'bottom' => 0,
												'left'   => 0,
												'link'   => true,
												'unit'   => 'px',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'vertical_align',
										'value' => [
											'desktop' => 'center',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'background_color',
										'value' => 'kalium-color(theme_colors.color-7, 0.8)',
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => 2,
												'right'  => 2,
												'bottom' => 2,
												'left'   => 2,
												'link'   => true,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'text_align',
										'value' => [
											'desktop' => 'center',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'visibility',
										'value' => [
											'desktop' => 'hover',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'hover_animation',
										'value' => 'fade',
									],
								],
								'visible'    => true,
								'elements'   => [
									[
										'name'       => 'woocommerce_product_column',
										'attributes' => [
											[
												'name'  => 'visibility',
												'value' => [
													'desktop' => 'hover',
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'hover_animation',
												'value' => 'fade-up',
											],
										],
										'visible'    => true,
										'elements'   => [
											[
												'name'    => 'woocommerce_product_title',
												'attributes' => [],
												'visible' => true,
											],
											$show_price ? [
												'name'    => 'woocommerce_product_price',
												'attributes' => [],
												'visible' => true,
											] : null,
										],
									],
									[
										'name'       => 'woocommerce_product_column',
										'attributes' => [
											[
												'name'  => 'css_position',
												'value' => [
													'desktop' => 'absolute',
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'position_offset',
												'value' => [
													'desktop' => [
														'top' => null,
														'right' => null,
														'bottom' => 15,
														'left' => null,
														'link' => false,
														'unit' => 'px',
													],
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'visibility',
												'value' => [
													'desktop' => 'hover',
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'hover_animation',
												'value' => 'fade-up',
											],
											[
												'name'  => 'hover_animation_delay',
												'value' => '150',
											],
										],
										'visible'    => true,
										'elements'   => [
											$show_add_to_cart ? [
												'name'    => 'woocommerce_product_add_to_cart',
												'attributes' => [
													[
														'name' => 'display_type',
														'value' => 'link',
													],
													[
														'name' => 'button_text_color',
														'value' => 'kalium-color(theme_colors.color-3)',
													],
													[
														'name' => 'css_position',
														'value' => [
															'desktop' => 'default',
															'tablet' => null,
															'mobile' => null,
														],
													],
													[
														'name' => 'button_text_color_hover',
														'value' => 'kalium-color(theme_colors.color-1)',
													],
												],
												'visible' => true,
											] : null,
										],
									],
								],
							],
							[
								'name'       => 'woocommerce_product_sale_badge',
								'attributes' => [
									[
										'name'  => 'badge_style',
										'value' => 'circle',
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'badge_size_fixed',
										'value' => true,
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => -1,
												'right'  => -1,
												'bottom' => null,
												'left'   => null,
												'link'   => false,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
								],
								'visible'    => true,
							],
						],
					],
				],
			];
			break;

		// Transparent bg
		case 'transparent-bg':
			$template['template_content'] = [
				'elements' => [
					[
						'name'       => 'woocommerce_product_images',
						'attributes' => [],
						'visible'    => true,
						'elements'   => [
							[
								'name'       => 'woocommerce_product_sale_badge',
								'attributes' => [
									[
										'name'  => 'badge_style',
										'value' => 'circle',
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'badge_size_fixed',
										'value' => true,
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => -1,
												'right'  => -1,
												'bottom' => null,
												'left'   => null,
												'link'   => false,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
								],
								'visible'    => true,
							],
							[
								'name'       => 'woocommerce_product_row',
								'attributes' => [
									[
										'name'  => 'margin',
										'value' => [
											'desktop' => [
												'top'    => 0,
												'right'  => 0,
												'bottom' => 0,
												'left'   => 0,
												'link'   => true,
												'unit'   => 'px',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'css_position',
										'value' => [
											'desktop' => 'absolute',
											'tablet'  => null,
											'mobile'  => null,
										],
									],
									[
										'name'  => 'position_offset',
										'value' => [
											'desktop' => [
												'top'    => 2,
												'right'  => 2,
												'bottom' => 2,
												'left'   => 2,
												'link'   => true,
												'unit'   => 'rem',
											],
											'tablet'  => null,
											'mobile'  => null,
										],
									],
								],
								'visible'    => true,
								'elements'   => [
									[
										'name'       => 'woocommerce_product_column',
										'attributes' => [
											[
												'name'  => 'padding',
												'value' => [
													'desktop' => [
														'top' => 0,
														'right' => 0,
														'bottom' => 0,
														'left' => 0,
														'link' => true,
														'unit' => 'px',
													],
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'hover_animation',
												'value' => 'none',
											],
										],
										'visible'    => true,
										'elements'   => [
											[
												'name'    => 'woocommerce_product_title',
												'attributes' => [
													[
														'name' => 'margin',
														'value' => [
															'desktop' => [
																'top' => null,
																'right' => null,
																'bottom' => 5,
																'left' => null,
																'link' => false,
																'unit' => 'px',
															],
															'tablet' => null,
															'mobile' => null,
														],
													],
													[
														'name' => 'visibility',
														'value' => [
															'desktop' => 'hover',
															'tablet' => null,
															'mobile' => null,
														],
													],
													[
														'name' => 'hover_animation',
														'value' => 'slide-up',
													],
												],
												'visible' => true,
											],
											$show_category ? [
												'name'    => 'woocommerce_product_category',
												'attributes' => [
													[
														'name' => 'visibility',
														'value' => [
															'desktop' => 'hover',
															'tablet' => null,
															'mobile' => null,
														],
													],
													[
														'name' => 'hover_animation',
														'value' => 'fade-up',
													],
												],
												'visible' => true,
											] : null,
										],
									],
									$show_price || $show_add_to_cart ? [
										'name'       => 'woocommerce_product_column',
										'attributes' => [
											[
												'name'  => 'css_position',
												'value' => [
													'desktop' => 'absolute',
													'tablet' => null,
													'mobile' => null,
												],
											],
											[
												'name'  => 'position_offset',
												'value' => [
													'desktop' => [
														'top' => null,
														'right' => 0,
														'bottom' => 0,
														'left' => 0,
														'link' => false,
														'unit' => 'px',
													],
													'tablet' => null,
													'mobile' => null,
												],
											],
										],
										'visible'    => true,
										'elements'   => [
											[
												'name'     => 'woocommerce_product_row',
												'attributes' => [
													[
														'name' => 'visibility',
														'value' => [
															'desktop' => 'hover',
															'tablet' => null,
															'mobile' => null,
														],
													],
													[
														'name' => 'hover_animation',
														'value' => 'fade-up',
													],
													[
														'name' => 'hover_animation_delay',
														'value' => '100',
													],
												],
												'visible'  => true,
												'elements' => [
													[
														'name' => 'woocommerce_product_column',
														'attributes' => [],
														'visible' => true,
														'elements' => [
															$show_price ? [
																'name' => 'woocommerce_product_price',
																'attributes' => [],
																'visible' => true,
															] : null,
														],
													],
													[
														'name' => 'woocommerce_product_column',
														'attributes' => [
															[
																'name' => 'columns',
																'value' => [
																	'desktop' => 'auto',
																	'tablet' => null,
																	'mobile' => null,
																],
															],
														],
														'visible' => true,
														'elements' => [
															$show_add_to_cart ? [
																'name' => 'woocommerce_product_add_to_cart',
																'attributes' => [
																	[
																		'name' => 'display_type',
																		'value' => 'link',
																	],
																	[
																		'name' => 'structure',
																		'value' => 'icon',
																	],
																	[
																		'name' => 'tooltip_hover',
																		'value' => true,
																	],
																	[
																		'name' => 'button_text_color',
																		'value' => 'kalium-color(theme_colors.color-4)',
																	],
																	[
																		'name' => 'tooltip_added',
																		'value' => true,
																	],
																	[
																		'name' => 'tooltip_placement',
																		'value' => 'left',
																	],
																	[
																		'name' => 'button_icon',
																		'value' => 'icon-2',
																	],
																	[
																		'name' => 'font_size',
																		'value' => [
																			'desktop' => '1.5rem',
																			'tablet' => null,
																			'mobile' => null,
																		],
																	],
																],
																'visible' => true,
															] : null,
														],
													],
												],
											],
										],
									] : null,
								],
							],
						],
					],
				],
			];
			break;
	}

	// Set loop card template
	if ( ! empty( $template['template_content'] ) && kalium_can_override_theme_option( 'product_loop_card' ) ) {
		$clear_empty_elements( $template['template_content'] );

		set_theme_mod(
			'product_loop_card',
			[
				'content_source'  => 'user-templates',
				'template_id'     => $template['id'],
				'preview_content' => null,
				'user_templates'  => [
					$template,
				],
				'id_index'        => $template['id'] + 1,
			]
		);
	}
}

/**
 * Get ACF header style value.
 *
 * @param int $post_id
 *
 * @return array
 */
function kalium_get_acf_header_style_value( $post_id ) {
	return wp_parse_args(
		kalium_get_field( 'header_style', $post_id ),
		[
			'container_background'     => '',
			'container_border_color'   => '',
			'container_padding'        =>
				[
					'top'    => '',
					'bottom' => '',
				],
			'container_bottom_spacing' => '',
			'links'                    =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'hamburger_menu'           =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'text'                     => '',
			'pill_background'          =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'pill_color'               =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'submenu_background'       => '',
			'submenu_links'            =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'submenu_pill_background'  =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'submenu_border_color'     => '',
		]
	);
}

/**
 * Get ACF sticky header style value.
 *
 * @param int $post_id
 *
 * @return array
 */
function kalium_get_acf_sticky_header_style_value( $post_id ) {
	return wp_parse_args(
		kalium_get_field( 'sticky_header_style', $post_id ),
		[
			'container_background'    => '',
			'container_bottom_border' =>
				[
					'color' => '',
					'style' => '',
					'width' => '',
				],
			'container_shadow'        =>
				[
					'color'         => '',
					'offset_x'      => '',
					'offset_y'      => '',
					'blur_radius'   => '',
					'spread_radius' => '',
				],
			'container_padding'       =>
				[
					'top'    => '',
					'bottom' => '',
				],
			'links'                   =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'text'                    => '',
			'pill_background'         =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
			'pill_color'              =>
				[
					'normal' => '',
					'hover'  => '',
					'active' => '',
				],
		]
	);
}

/**
 * Checks if current installation is imported demo content.
 *
 * @return bool
 */
function kalium_is_imported_demo_content() {
	$import_instances = get_option( 'kalium_demos_import_instances', [] );

	if ( is_array( $import_instances ) ) {
		$installed = wp_list_filter( $import_instances, [ 'installed' => 1 ] );

		return 0 < count( $installed );
	}

	return false;
}

/**
 * Returns the name of imported demo content.
 *
 * @return string|null
 */
function kalium_get_imported_demo_content() {
	if ( kalium_is_imported_demo_content() ) {
		$content_packs = get_option( 'kalium_demos_import_instances', [] );
		$installed     = wp_list_filter( $content_packs, [ 'installed' => 1 ] );

		// Choose the one that has more imported parts
		if ( 1 < count( $installed ) ) {
			foreach ( $installed as & $content_pack ) {
				$content_pack['success_imports'] = 0;

				foreach ( $content_pack['imports'] as $import ) {
					$content_pack['success_imports'] += count( wp_list_filter( $import['tasks'], [ 'success' => true ] ) );
				}
			}

			uasort(
				$installed,
				function ( $a, $b ) {
					return $a['success_imports'] < $b['success_imports'];
				}
			);
		}

		return kalium_get_array_first( $installed, true );
	}

	return null;
}

/**
 * A function that migrates the style.css to style-backup.css
 *
 * @return bool
 */
function kalium_migrate_stylesheet_file() {
	$stylesheet  = get_stylesheet_directory() . '/style.css';
	$backup_path = get_stylesheet_directory() . '/style-backup.css';

	// Style.css is already migrated
	if ( file_exists( $backup_path ) ) {
		return true;
	}

	// Try to initialize file system
	if ( ! kalium()->filesystem->initialize() ) {
		return false;
	}

	// Style content
	$stylesheet_content = file_get_contents( $stylesheet );

	// Modify existing stylesheet
	$pattern = '/\/\*\s*={10,}\s*\n' .
				'[^\n]* - START\s*\n' .
				'={10,}\s*\*\/\s*\n*' .
				'(.*?)' .
				'\s*\/\*\s*={10,}\s*\n' .
				'[^\n]* - END\s*\n' .
				'={10,}\s*\*\/\s*/s';

	$stylesheet_new_content = preg_replace( $pattern, '', $stylesheet_content );

	if ( $stylesheet_content !== $stylesheet_new_content ) {

		// Backup current style.css to style-backup.css
		kalium()->filesystem->copy( $stylesheet, $backup_path );

		// Save the new content
		kalium()->filesystem->put_contents( $stylesheet, $stylesheet_new_content );
	}

	return true;
}

/**
 * Get demo content extra options that should be applied based on current installed content pack.
 *
 * @param string $site
 *
 * @return array
 */
function kalium_get_complementary_demo_content_options( $site ) {
	$custom_css  = '';
	$custom_code = '';
	$theme_mods  = [];
	$font_sizes  = null;
	$fonts       = null;
	$data_path   = __DIR__ . DIRECTORY_SEPARATOR . 'data' . DIRECTORY_SEPARATOR . $site . DIRECTORY_SEPARATOR;

	$files = [
		'theme_options' => $data_path . 'theme-options.json',
		'custom_css'    => $data_path . 'custom-css.txt',
		'custom_code'   => $data_path . 'custom-code.txt',
		'typography'    => $data_path . 'typography.json',
	];

	$json_flags = JSON_NUMERIC_CHECK | JSON_OBJECT_AS_ARRAY;

	// Theme options
	if ( file_exists( $files['theme_options'] ) ) {
		$theme_mods = kalium()->helpers->json_decode( file_get_contents( $files['theme_options'] ), true, 512, $json_flags );
	}

	// Custom CSS
	if ( file_exists( $files['custom_css'] ) ) {
		$custom_css = file_get_contents( $files['custom_css'] );
	}

	// Custom code
	if ( file_exists( $files['custom_code'] ) ) {
		$custom_code = file_get_contents( $files['custom_code'] );
	}

	// Typography
	if ( file_exists( $files['typography'] ) ) {
		$typography = kalium()->helpers->json_decode( file_get_contents( $files['typography'] ), true, 512, $json_flags );

		// Font sizes
		if ( ! empty( $typography['font_appearance'] ) ) {
			$font_sizes = TypoLab::get_option( 'font_appearance' );

			foreach ( $typography['font_appearance'] as $font_size_entry ) {
				$group_id = kalium_get_array_key( $font_size_entry, 'group_id' );
				$id       = kalium_get_array_key( $font_size_entry, 'id' );

				foreach ( [ 'font_size', 'line_height', 'letter_spacing', 'text_transform' ] as $value_prop ) {
					$value = kalium_get_array_key( $font_size_entry, $value_prop );

					if ( ! is_array( $value ) || empty( array_filter( array_values( $value ) ) ) ) {
						continue;
					}

					$font_sizes[ $group_id ][ $id ][ $value_prop ] = kalium_array_deep_diff( $value, kalium_get_array_key( $font_sizes, "{$group_id}/{$id}", [] ) );
				}
			}
		}

		// Custom font sizes selectors
		if ( ! empty( $typography['registered_fonts'] ) ) {
			$fonts = TypoLab::get_option( 'registered_fonts' );

			if ( ! empty( $fonts ) ) {
				$fonts = array_map(
					function ( $font_entry ) use ( &$typography ) {
						if ( empty( $font_entry['active'] ) ) {
							return $font_entry;
						}

						$source = kalium_get_array_key( $font_entry, 'source' );
						$family = kalium_get_array_key( $font_entry, 'family' );

						$migrated_selectors_start = [
							'type'           => 'custom-selector',
							'id'             => 'custom-selector-99999999',
							'selectors'      => [
								'ADDED_SELECTORS_AFTER_MIGRATION_START',
							],
							'variant'        => null,
							'include'        => false,
							'font_size'      => [],
							'text_transform' => [],
							'line_height'    => [],
							'letter_spacing' => [],
						];
						$migrated_selectors_end   = array_merge(
							$migrated_selectors_start,
							[
								'selectors' => [
									'ADDED_SELECTORS_AFTER_MIGRATION_END',
								],
							]
						);

						foreach ( $typography['registered_fonts'] as $font_data ) {
							// Match font
							if ( $font_data['source'] !== $source || $font_data['family'] !== $family ) {
								continue;
							}

							$font_entry['base_selectors'] = array_merge(
								kalium_get_array_key( $font_entry, 'base_selectors', [] ),
								$font_data['base_selectors']
							);

							$font_entry['custom_selectors'][] = $migrated_selectors_start;

							$selector_counter = 1000;

							foreach ( $font_data['custom_selectors'] as $custom_selector ) {
								$font_entry['custom_selectors'][] = array_merge(
									$custom_selector,
									[
										'id' => 'custom-selector-' . $selector_counter++,
									]
								);
							}

							$font_entry['custom_selectors'][] = $migrated_selectors_end;

							break;
						}

						return $font_entry;
					},
					$fonts
				);
			}
		}
	}

	return [
		'theme_mods'  => $theme_mods,
		'custom_css'  => $custom_css,
		'custom_code' => $custom_code,
		'font_sizes'  => $font_sizes,
		'fonts'       => $fonts,
	];
}

/**
 * Performs a deep diff between two arrays, including sub-arrays.
 *
 * @param array $array1
 * @param array $array2
 *
 * @return array
 */
function kalium_array_deep_diff( $array1, $array2 ) {
	$diff = [];

	// Compare items in $array1 that are not in $array2
	foreach ( $array1 as $key => $value ) {
		if ( array_key_exists( $key, $array2 ) ) {
			if ( is_array( $value ) && is_array( $array2[ $key ] ) ) {
				$recursive_diff = kalium_array_deep_diff( $value, $array2[ $key ] );
				if ( ! empty( $recursive_diff ) ) {
					$diff[ $key ] = $recursive_diff;
				}
			} elseif ( $value != $array2[ $key ] ) {
				$diff[ $key ] = $value;
			}
		} else {
			$diff[ $key ] = $value;
		}
	}

	// Compare items in $array2 that are not in $array1
	foreach ( $array2 as $key => $value ) {
		if ( ! array_key_exists( $key, $array1 ) ) {
			$diff[ $key ] = $value;
		}
	}

	return $diff;
}
