<?php
/**
 * Kalium WordPress Theme
 *
 * Version 4.3 upgrade tasks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return [
	/**
	 * Ditch the old Custom CSS module in favor of the Customizer Custom CSS feature.
	 */
	static function () {
		$custom_css_entries = array_filter(
			array_map(
				'trim',
				array_map(
					'get_option',
					[
						'main' => Kalium_Legacy_Custom_CSS::OPTION_NAME,
						'lg'   => Kalium_Legacy_Custom_CSS::OPTION_NAME . '_lg',
						'md'   => Kalium_Legacy_Custom_CSS::OPTION_NAME . '_md',
						'sm'   => Kalium_Legacy_Custom_CSS::OPTION_NAME . '_sm',
						'xs'   => Kalium_Legacy_Custom_CSS::OPTION_NAME . '_xs',
					]
				)
			)
		);

		$custom_css = [];

		foreach ( $custom_css_entries as $screen => $css ) {
			$media = '';

			switch ( $screen ) {
				case 'xs':
					$media = '@media screen and (max-width: 768px)';
					break;

				case 'sm':
					$media = '@media screen and (min-width: 768px)';
					break;

				case 'md':
					$media = '@media screen and (min-width: 992px)';
					break;

				case 'lg':
					$media = '@media screen and (min-width: 1200px)';
					break;
			}

			// Add CSS comment for current screen
			$comment = '/* Laborator Custom CSS (' . strtoupper( $screen ) . ') - migrated styles */';

			$custom_css[] = $comment;

			if ( $media ) {
				$custom_css[] = $media . ' {' . PHP_EOL . "\t" . str_replace( PHP_EOL, PHP_EOL . "\t", $css ) . PHP_EOL . '}';
			} else {
				$custom_css[] = $css;
			}

			$custom_css[] = PHP_EOL;
		}

		$css_final = trim( implode( PHP_EOL, $custom_css ) );

		if ( $css_final ) {
			$current_custom_css = wp_get_custom_css();

			if ( $current_custom_css ) {
				$current_custom_css .= PHP_EOL . PHP_EOL;
			}

			$current_custom_css .= $css_final;

			wp_update_custom_css_post( $current_custom_css );
		}

		return true;
	},
];
