<?php
/**
 * Kalium WordPress Theme
 *
 * Version 4.4 upgrade tasks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

return [
	/**
	 * Migrate old sticky header options to the new ones.
	 */
	static function () {
		$old_options = array_map(
			'kalium_get_theme_option',
			[
				'use_custom_logo'      => 'sticky_header_custom_logo',
				'custom_logo'          => 'sticky_header_logo',
				'logo_width'           => 'sticky_header_logo_width',
				'is_autohide'          => 'sticky_header_autohide',
				'autohide_effect'      => 'sticky_header_autohide_animation_type',
				'autohide_duration'    => 'sticky_header_autohide_duration',
				'progress_with_scroll' => 'sticky_header_animate_duration',
				'animate_duration'     => 'sticky_header_duration',
			]
		);

		$new_options = [
			'sticky_header_mode' => $old_options['is_autohide'] ? 'autohide' : 'standard',
		];

		// Autohide sticky
		if ( $old_options['is_autohide'] ) {
			$new_options['sticky_header_effect'] = kalium_enum_value(
				$old_options['autohide_effect'],
				[
					'slide'             => 'slide',
					'fade'              => 'fade',
					'fade-slide-top'    => 'slide-fade',
					'fade-slide-bottom' => 'slide-fade-up',
				],
			);

			if ( is_numeric( $old_options['autohide_duration'] ) ) {
				$new_options['sticky_header_animation_duration'] = $old_options['autohide_duration'];
			}
		}
		// Standard sticky
		else {
			$new_options['sticky_header_progress_with_scroll'] = $old_options['progress_with_scroll'];

			if ( is_numeric( $old_options['animate_duration'] ) ) {
				$new_options['sticky_header_animation_duration'] = $old_options['animate_duration'];
			}
		}

		// Custom logo
		$new_options['sticky_header_custom_logo']       = $old_options['use_custom_logo'];
		$new_options['sticky_header_custom_logo_image'] = $old_options['custom_logo'];

		// Shrink logo
		$site_logo = wp_get_attachment_image_src( kalium_get_attachment_id_from_theme_option( 'custom_logo_image' ), 'full' );

		if ( is_numeric( $old_options['logo_width'] ) && is_array( $site_logo ) ) {
			$custom_logo_width = kalium_get_responsive_value( kalium_get_theme_option( 'custom_logo_max_width' ) ) ?: $site_logo[1];
			$site_logo_width   = $site_logo[1];
			$site_logo_height  = $site_logo[2];

			if ( is_numeric( $custom_logo_width ) ) {
				list( $site_logo_width, $site_logo_height ) = kalium()->helpers->resize_by_width( $site_logo_width, $site_logo_height, $custom_logo_width );
			}

			list( $resized_logo_width ) = kalium()->helpers->resize_by_width( $site_logo_width, $site_logo_height, $old_options['logo_width'] );

			$new_options['sticky_header_shrink_logo'] = round( $resized_logo_width / $site_logo_width * 100 );
		}

		// Update new options
		foreach ( $new_options as $key => $value ) {
			set_theme_mod( $key, $value );
		}

		return true;
	},

	/**
	 * Keep Always Include jQuery option on by default for older installations to prevent breaking changes.
	 */
	static function () {
		set_theme_mod( 'performance_force_jquery', true );

		return true;
	},
];
