<?php
/**
 * Kalium WordPress Theme
 *
 * Content Section widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'kalium_section',
		'name'        => 'Content Section',
		'description' => 'Template Part Section',
		'category'    => 'Laborator',
		'icon'        => plugins_url( 'js_composer/assets/vc/vc-element-icons/element-icon-section.svg' ),
		'params'      => [
			[
				'type'        => 'dropdown',
				'heading'     => 'Display Section',
				'param_name'  => 'id',
				'value'       => array_merge(
					[
						'Select section' => '',
					],
					wp_list_pluck( kalium()->template_parts->get_template_parts( [ 'type' => 'section' ] ), 'id', 'title' )
				),
				'std'         => '',
				'admin_label' => true,
				'description' => 'Select a template part section to display.',
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Check Display Conditions',
				'param_name'  => 'check_conditions',
				'value'       => [ 'Yes' => 'yes' ],
				'description' => 'Check if this section should be visible based on its Display Conditions.',
			],
		],
	]
);
