<?php
/**
 * Kalium WordPress Theme
 *
 * Blog Posts widgets.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_blog_posts',
		'name'        => 'Blog Posts',
		'description' => 'Show blog posts',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/blog-posts.svg' ),
		'params'      => [
			[
				'type'        => 'loop',
				'heading'     => 'Blog Query',
				'param_name'  => 'blog_query',
				'settings'    => [
					'size'      => [
						'hidden' => false,
						'value'  => 3,
					],
					'order_by'  => [ 'value' => 'date' ],
					'post_type' => [
						'value'  => 'post',
						'hidden' => false,
					],
				],
				'description' => 'Create WordPress loop, to populate only blog posts from your site.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Columns',
				'param_name'  => 'columns',
				'std'         => '3',
				'admin_label' => true,
				'value'       => [
					'1 Column'  => '1',
					'2 Columns' => '2',
					'3 Columns' => '3',
					'4 Columns' => '4',
					'5 Columns' => '5',
					'6 Columns' => '6',
				],
				'description' => 'Set number of columns to separate blog posts.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Layout',
				'param_name'  => 'layout',
				'std'         => 'top',
				'admin_label' => true,
				'value'       => [
					'Inherit from Theme Options' => 'inherit',
					'Image on Top'               => 'top',
					'Image on Top (no borders)'  => 'top-borderless',
					'Image on Left'              => 'left',
					'Image on Left (no borders)' => 'left-borderless',
					'No Image'                   => 'no-image',
				],
				'description' => 'Set posts layout to show blog posts.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Image Column Width',
				'param_name'  => 'image_column_size',
				'description' => 'Set column width for the image, unit is percentage.',
				'dependency'  => [
					'element' => 'layout',
					'value'   => [ 'left', 'left-borderless' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Image Size',
				'param_name'  => 'image_size',
				'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)). Default is: 400x320',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Masonry',
				'param_name'  => 'masonry',
				'std'         => 'plain',
				'value'       => [
					'inherit' => 'Inherit from Theme Options',
					'No'      => 'plain',
					'Yes'     => 'masonry',
				],
				'description' => 'Set grid render for blog posts.',
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Blog Post Toggles',
				'param_name'  => 'blog_posts_options',
				'std'         => 'excerpt',
				'value'       => [
					'Show Post Date<br>'     => 'date',
					'Show Post Category<br>' => 'category',
					'Show Post Excerpt'      => 'excerpt',
					// 'Animated Eye on Hover<br />' => 'animated-eye-hover',
				],
				'description' => 'Toggle blog post options.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Hover Layer Icon',
				'param_name'  => 'hover_layer_icon',
				'std'         => 'plain',
				'value'       => [
					'Inherit from Theme Options' => 'inherit',
					'Static'                     => 'static',
					'Animated Eye'               => 'animated-eye',
					'Custom Icon (Used from Theme Options)' => 'custom',
				],
				'description' => 'Select icon type to show inside hover layer of blog post thumbnails.',
			],
			[
				'type'        => 'vc_link',
				'heading'     => 'More Link',
				'param_name'  => 'more_link',
				'value'       => '',
				'description' => 'This will show "More" button in the end of blog items.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Blog_Posts extends WPBakeryShortCode {

	/**
	 * Shortcode content.
	 *
	 * @param array  $atts
	 * @param string $content
	 *
	 * @return string
	 */
	public function content( $atts, $content = '' ) {
		static $instance_id = 0;

		$atts = vc_map_get_attributes( $this->getShortcode(), $atts );

		$container_id = 'blog-posts-wpb-' . ++$instance_id;
		$css_vars     = [];

		$query_vars = array_merge(
			[
				'post_type' => 'post',
			],
			kalium_wpb_build_query_args( $atts['blog_query'] )
		);

		// Query posts
		query_posts( $query_vars );

		// Loop options
		$custom_loop_options = [
			'layout' => 'grid',
		];

		// Columns
		if ( is_numeric( $atts['columns'] ) ) {
			$custom_loop_options['loop']['columns'] = kalium_parse_responsive_value(
				[
					'desktop' => absint( $atts['columns'] ),
					'mobile'  => 1,
				]
			);
		}

		// Masonry mode
		if ( 'inherit' !== $atts['masonry'] ) {
			$custom_loop_options['loop']['masonry_mode'] = 'masonry' === $atts['masonry'];
		}

		// Image size
		if ( $image_size = $atts['image_size'] ) {
			if ( preg_match( '/^(\d+)x(\d+)$/', $image_size, $matches ) ) {
				$image_size = [ $matches[1], $matches[2] ];
			}

			$custom_loop_options['loop']['post_thumbnail']['size'] = $image_size;
		}

		// Layout
		if ( in_array( $atts['layout'], [ 'left', 'top' ] ) ) {
			$custom_loop_options = array_replace_recursive(
				$custom_loop_options,
				[
					'loop' => [
						'post_thumbnail' => [
							'boundless' => true,
						],
					],
				]
			);

			if ( ! kalium_has_border( kalium_get_responsive_value( kalium_get_theme_option( 'blog_post_style_border' ) ) ) ) {
				$css_vars['post-item-border-width'] = '1px';
				$css_vars['post-item-border-style'] = 'solid';
				$css_vars['post-item-border-color'] = kalium_css_var_reference( 'color-8' );
			}

			if ( ! kalium_has_multi_numeric_value( kalium_get_responsive_value( kalium_get_theme_option( 'blog_post_style_padding' ) ) ) ) {
				$css_vars['post-item-padding'] = kalium_css_var_reference( 'content-spacing-2' );
			}
		} elseif ( in_array( $atts['layout'], [ 'top-borderless', 'left-borderless' ] ) ) {
			$css_vars['post-item-border-width'] = $css_vars['post-item-padding'] = '0';
		}

		if ( in_array( $atts['layout'], [ 'left', 'left-borderless' ] ) ) {
			$custom_loop_options['layout']             = 'list';
			$custom_loop_options['force_grid_columns'] = true;

			if ( is_numeric( $image_column_size = $atts['image_column_size'] ) ) {
				$css_vars['post-item-image-width'] = kalium_parse_responsive_value(
					[
						'desktop' => $image_column_size . '%',
						'mobile'  => '100%',
					]
				);
			}
		}

		if ( 'no-image' === $atts['layout'] ) {
			$custom_loop_options['loop']['post_thumbnail']['visible'] = false;
		}

		// Meta
		$post_meta = explode( ',', $atts['blog_posts_options'] );

		$custom_loop_options = array_replace_recursive(
			$custom_loop_options,
			[
				'loop' => [
					'post_excerpt' => in_array( 'excerpt', $post_meta ),
					'post_meta'    => [
						'post_date'     => in_array( 'date', $post_meta ),
						'post_category' => in_array( 'category', $post_meta ),
					],
				],
			]
		);

		// Hover layer icon
		switch ( $atts['hover_layer_icon'] ) {
			case 'static':
			case 'animated-eye':
				$custom_loop_options = array_replace_recursive(
					$custom_loop_options,
					[
						'loop' => [
							'post_thumbnail' => [
								'hover' => [
									'icon'     => 'eye',
									'eye_icon' => 'animated-eye' === $atts['hover_layer_icon'] ? 'animated' : 'eye',
								],
							],
						],
					]
				);
				break;

			case 'custom':
				$custom_loop_options['loop']['post_thumbnail']['hover']['icon'] = 'custom';
				break;
		}

		// Pagination
		$more_link = vc_build_link( $atts['more_link'] );

		if ( ! empty( $more_link['url'] ) && ! empty( $more_link['title'] ) ) {
			$custom_loop_options = array_replace_recursive(
				$custom_loop_options,
				[
					'loop' => [
						'pagination' => [
							'type'      => 'more-link',
							'more_link' => [
								'url'    => $more_link['url'],
								'target' => $more_link['target'],
								'text'   => $more_link['title'],
							],
						],
					],
				]
			);
		} else {
			$custom_loop_options['loop']['pagination']['enabled'] = false;
		}

		// Output template
		ob_start();

		// Print style
		kalium_print_inline_style(
			[
				'selector' => '#' . $container_id,
				'vars'     => $css_vars,
			]
		);

		// Init blog options
		kalium_init_blog_options( 'wpb-' . $instance_id, $custom_loop_options );

		// Loop before
		kalium_blog_loop_before();

		// Show blog posts
		kalium_blog_posts_loop();

		// Pagination
		kalium_blog_archive_posts_pagination();

		// Loop after
		kalium_blog_loop_after();

		// Reset
		kalium_reset_blog_options();
		wp_reset_postdata();
		wp_reset_query();

		// CSS class
		$css_class  = 'kalium-wpb-blog-posts';
		$css_class .= $this->getExtraClass( $atts['el_class'] );
		$css_class .= vc_shortcode_custom_css_class( $atts['css'], ' ' );

		return kalium_render_element(
			[
				'tag_name'   => 'div',
				'attributes' => [
					'class' => apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_class, $this->settings['base'], $atts ),
				],
				'content'    => ob_get_clean(),
			],
			false
		);
	}
}
