<?php
/**
 * Kalium WordPress Theme
 *
 * Google Map widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$icon = kalium()->file_url( 'includes/wpbakery/assets/images/map.svg' );

$google_api_warning = '<br><br>
<div class="wpb_element_wrapper">
	<div class="wpb_element_wrapper vc_message_box vc_message_box-square vc_message_box-solid vc_color-info" style="padding: 0.5em;">
		<small>Google maps requires unique API key for each site, click here to learn more about generating <a href="https://documentation.laborator.co/kb/kalium/fix-the-missing-google-maps-api-key/" style="color: #fff !important;" target="_blank">Google API Key</a>.<br>
		API key should be set in Theme Options > Other Settings</small>
	</div>
</div>';

// Map
vc_map(
	[
		'base'                    => 'lab_google_map',
		'name'                    => 'Map',
		'description'             => 'Insert Google Map',
		'category'                => 'Laborator',
		'content_element'         => true,
		'show_settings_on_create' => true,
		'icon'                    => $icon,
		'as_parent'               => [ 'only' => 'lab_google_map_location' ],
		'params'                  => [
			[
				'type'        => 'textfield',
				'heading'     => 'Map Height',
				'param_name'  => 'height',
				'value'       => '400',
				'description' => 'Set map container height.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Map Zoom',
				'param_name'  => 'zoom',
				'value'       => '14',
				'description' => 'Set map zoom level. Leave 0 to automatically fit to bounds.',
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Map Toggles',
				'param_name'  => 'map_options',
				'std'         => 'map-style,scroll-zoom,drop-pins',
				'value'       => [
					'Full width<br />'        => 'fullwidth',
					'Pan by<br />'            => 'pan-by',
					'Map Style<br />'         => 'map-style',
					'Scroll Zoom<br />'       => 'scroll-zoom',
					'Dropping Pins Animation' => 'drop-pins',
				],
				'description' => 'Toggle map options.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Pan-by Params',
				'param_name'  => 'map_panby',
				'description' => 'Enter panBy params: x:number, y:number. Example: <strong>50,25</strong> or <strong>50</strong> to move just X-axis',
				'dependency'  => [
					'element' => 'map_options',
					'value'   => [ 'pan-by' ],
				],
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Map Controls',
				'param_name'  => 'map_controls',
				'std'         => 'panControl,zoomControl,mapTypeControl,scaleControl,fullscreenControl',
				'value'       => [
					'Pan Control<br />'          => 'panControl',
					'Zoom Control<br />'         => 'zoomControl',
					'Map Type Control<br />'     => 'mapTypeControl',
					'Scale Control<br />'        => 'scaleControl',
					'Street View Control<br />'  => 'streetViewControl',
					'Overview Map Control<br />' => 'overviewMapControl',
					'Plus Minus Zoom<br />'      => 'plusMinusZoom',
					'Full Screen Control<br />'  => 'fullscreenControl',
				],
				'description' => 'Toggle map options.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Map Type',
				'param_name'  => 'map_type',
				'std'         => 'roadmap',
				'value'       => [
					'Roadmap'   => 'roadmap',
					'Satellite' => 'satellite',
					'Hybrid'    => 'hybrid',
				],
				'description' => 'Choose map style.',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Map Tilt',
				'param_name'  => 'map_tilt',
				'std'         => '0',
				'value'       => [
					'Normal'   => '0',
					'Tilt 45°' => '45',
				],
				'description' => 'This map type supports 45&deg; map tilt.',
				'dependency'  => [
					'element' => 'map_type',
					'value'   => [ 'satellite', 'hybrid' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Map Heading',
				'param_name'  => 'map_heading',
				'description' => 'Set the degree of rotation (0-360) for map tilt.',
				'dependency'  => [
					'element' => 'map_tilt',
					'value'   => [ '45' ],
				],
			],
			[
				'type'        => 'textarea_safe',
				// 'holder' => 'div',
				'heading'     => 'Map Style',
				'param_name'  => 'map_style',
				'value'       => '',
				'description' => 'Paste the style code here. Browse map styles in <a href="https://snazzymaps.com/" target="_blank">SnazzyMaps</a>',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
		'js_view'                 => 'VcColumnView',
	]
);

// Map Location (child of map)
vc_map(
	[
		'base'            => 'lab_google_map_location',
		'name'            => 'Map Location',
		'description'     => 'Add map marker',
		'category'        => 'Laborator',
		'content_element' => true,
		'icon'            => $icon,
		'as_child'        => [ 'only' => 'lab_google_map' ],
		'params'          => [
			[
				'type'        => 'attach_image',
				'heading'     => 'Marker Image',
				'param_name'  => 'marker_image',
				'value'       => '',
				'description' => 'Add your Custom marker image or use default one.',
			],
			[
				'type'        => 'checkbox',
				'heading'     => 'Retina Marker',
				'param_name'  => 'retina_marker',
				'std'         => '',
				'value'       => [
					'Yes' => 'yes',
				],
				'description' => 'Enabling this option will reduce the size of marker for 50%, example if marker is 32x32 it will be 16x16.' . $google_api_warning,
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Latitude',
				'admin_label' => true,
				'param_name'  => 'latitude',
				'value'       => '',
				'description' => 'Enter latitude coordinate. To select map coordinates <a href="http://www.latlong.net/convert-address-to-lat-long.html" target="_blank">click here</a>.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Longitude',
				'admin_label' => true,
				'param_name'  => 'longitude',
				'value'       => '',
				'description' => 'Enter longitude coordinate.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Marker Title',
				'admin_label' => true,
				'param_name'  => 'marker_title',
				'value'       => '',
			],
			[
				'type'       => 'textarea_safe',
				'heading'    => 'Marker Description',
				'param_name' => 'marker_description',
				'value'      => '',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Google_Map extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Lab_Google_Map_Location extends WPBakeryShortCode {}
