<?php
/**
 * Kalium WordPress Theme
 *
 * Scroll Box widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_scroll_box',
		'name'        => 'Scroll Box',
		'description' => 'Content with scrollbar',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/scrollbox.svg' ),
		'params'      => [
			[
				'type'        => 'textfield',
				'heading'     => 'Height',
				'param_name'  => 'scroll_height',
				'description' => 'Set the maximum height of content box, scrollbar will be visible when there is more text. Set "auto" to use the column height.',
				'admin_label' => true,
				'value'       => '450',
			],
			[
				'type'       => 'textarea_html',
				'heading'    => 'Content',
				'param_name' => 'content',
				'value'      => '',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Scroll_Box extends WPBakeryShortCode {}
