<?php
/**
 * Kalium WordPress Theme
 *
 * Auto Type widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

vc_map(
	[
		'base'        => 'lab_text_autotype',
		'name'        => 'Auto Type',
		'description' => 'Animated text typing',
		'category'    => 'Laborator',
		'icon'        => kalium()->file_url( 'includes/wpbakery/assets/images/typing.svg' ),
		'params'      => [
			[
				'type'        => 'textarea_safe',
				'heading'     => 'Content',
				'param_name'  => 'typed_text',
				'value'       => '<h2>Hi there! *This is ' . kalium_get_theme_name() . ' Theme;Developed by ' . kalium_get_name() . ';Do you like it?*</h2>',
				'description' => '
			Enter the content to display with typing text. You can apply HTML markup too.
			<br />
			<small>Text within <u>*</u> will be animated, example: <strong>*Sample text*</strong>.
			<br />
			Text separator is ; (semicolon), example: <strong>*First sentence; second sentence*</strong>
			<br />
			Pausing inside texts: <u>^1000</u> in milliseconds unit, example: <strong>*Hey, ^800 how are you?;Well, ^2000 I am Fine!*</strong>
			</small>',
			],
			[
				'type'        => 'dropdown',
				'heading'     => 'Show more options',
				'param_name'  => 'typed_show_options',
				'std'         => 'no',
				'value'       => [
					'Yes' => 'yes',
					'No'  => 'no',
				],
				'description' => 'Configure animation options.',
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Character for cursor',
				'value'       => '|',
				'description' => 'Leave empty to remove the blinking cursor.',
				'param_name'  => 'typed_options_cursorchar',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Iteration loop',
				'value'       => '',
				'description' => 'Leave empty for single loop only. Set -1 for infinite loop.',
				'param_name'  => 'typed_options_loopcount',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Type speed',
				'value'       => '10',
				'description' => 'Type of speed when entering the text. (Unit is milliseconds)',
				'param_name'  => 'typed_options_typespeed',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Back speed',
				'value'       => '20',
				'description' => 'Back speed when deleting the text. (Unit is milliseconds)',
				'param_name'  => 'typed_options_backspeed',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Start delay',
				'value'       => '0',
				'description' => 'Set delay before starting text typing. (Unit is milliseconds)',
				'param_name'  => 'typed_options_startdelay',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Back delay',
				'value'       => '500',
				'description' => 'Set back delay after text is typed. (Unit is milliseconds)',
				'param_name'  => 'typed_options_backdelay',
				'dependency'  => [
					'element' => 'typed_show_options',
					'value'   => [ 'yes' ],
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => 'Extra class name',
				'param_name'  => 'el_class',
				'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
			],
			[
				'type'       => 'css_editor',
				'heading'    => 'Css',
				'param_name' => 'css',
				'group'      => 'Design options',
			],
		],
	]
);

class WPBakeryShortCode_Lab_Text_Autotype extends WPBakeryShortCode {

	/**
	 * Process entry.
	 *
	 * @param string $typed_syntax
	 * @param array  $typed_options
	 *
	 * @return array
	 */
	public static function process_entry( $typed_syntax = '', $typed_options = [] ) {
		$typed_element = '';

		if ( in_array( '*', [ substr( $typed_syntax, 0, 1 ), substr( $typed_syntax, -1, 1 ) ] ) ) {
			$typed_options = wp_parse_args(
				$typed_options,
				[
					'cursorChar'  => '|',
					'contentType' => 'html',
					'loop'        => false,
					'loopCount'   => false,
					'typeSpeed'   => 40,
					'backSpeed'   => 0,
					'startDelay'  => 0,
					'backDelay'   => 500,
				]
			);

			// Text Split and Map
			$element_id = 'el_' . kalium_generate_unique_string();

			$typed_syntax = substr( $typed_syntax, 1, -1 );

			// Escape <script inject
			$typed_syntax = wp_kses_post( $typed_syntax );

			// Ampersand replacement
			$ampersand_replacement = '__AMPERSAND__';
			$typed_syntax          = str_replace( [ '&amp;', '&' ], $ampersand_replacement, $typed_syntax );
			$animate_entries       = array_map( 'trim', explode( ';', $typed_syntax ) );

			// Set strings
			$typed_options['strings'] = $animate_entries;

			// Text
			$typed_element = sprintf( '<div class="lab-autotype-text-entry" id="%s"></div>', esc_attr( $element_id ) );

			// Initialize Typed
			kalium_add_inline_script(
				'typed',
				kalium()->helpers->capture_output(
					static function () use ( $element_id, $typed_options, $ampersand_replacement ) {
						$json_data = wp_json_encode( $typed_options );

						// Ampersand replacement
						$json_data = str_replace( $ampersand_replacement, '＆', $json_data ); // @todo Fix in Typed.js new 2.0.12

						$script = <<<'EOD'
							jQuery( document ).ready( function( $ ) {
								jQuery( "#%s" ).typed( %s );
							} );
						EOD;

						printf( $script, esc_attr( $element_id ), $json_data );
					}
				)
			);
		}

		return $typed_element;
	}
}
