<?php
/**
 * Kalium WordPress Theme
 *
 * Index.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme header.
 */
get_header();

/**
 * Show page if exists.
 */
if ( have_posts() ) :
	while ( have_posts() ) :
		the_post();

		/**
		 * Hook: kalium_page_before_content.
		 *
		 * @hooked kalium_page_content_wrapper_start - 10
		 */
		do_action( 'kalium_page_before_content' );

		/**
		 * Hook: kalium_page_content.
		 *
		 * @hooked kalium_the_content - 10
		 */
		do_action( 'kalium_page_content' );

		/**
		 * Hook: kalium_page_after_content.
		 *
		 * @hooked kalium_page_content_wrapper_end - 100
		 */
		do_action( 'kalium_page_after_content' );

	endwhile;
endif;

/**
 * Theme footer.
 */
get_footer();
