<?php
/**
 * Kalium WordPress Theme
 *
 * Single portfolio.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme header.
 */
get_header();

/**
 * Hook: kalium_portfolio_single_content_before_content.
 *
 * @hooked kalium_portfolio_single_wrapper_start - 10
 */
do_action( 'kalium_portfolio_single_content_before_content' );

/**
 * Show single portfolio.
 */
if ( have_posts() ) :

	while ( have_posts() ) :
		the_post();

		/**
		 * Single portfolio content.
		 *
		 * @hooked kalium_content_wrapper_main_content_start - 10
		 * @hooked kalium_portfolio_single_item_default_template - 20
		 * @hooked kalium_content_wrapper_main_content_end - 999
		 */
		do_action( 'kalium_portfolio_single_content' );

	endwhile;

endif;

/**
 * Hook: kalium_portfolio_single_content_after_content.
 *
 * @hooked kalium_portfolio_single_wrapper_end - 100
 */
do_action( 'kalium_portfolio_single_content_after_content' );

/**
 * Theme footer.
 */
get_footer();
