<?php
/**
 * Kalium WordPress Theme
 *
 * Post thumbnail template.
 *
 * @var string $thumbnail_size
 * @var array $post_format_content
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0.4
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="post-thumbnail">
	
	<?php
		/**
		 * Before post thumbnail.
		 */
		do_action( 'kalium_blog_loop_before_post_thumbnail' );
	?>

	<?php
		// Show post format content if it contains
	if ( ! empty( $post_format_content ) ) :

		kalium_show_post_format_content( $post_format_content );

		else :

			?>
			<a href="<?php the_permalink(); ?>" target="<?php echo esc_attr( kalium_get_post_link_target() ); ?>" aria-label="<?php echo esc_attr( get_the_title() ); ?>">
				<?php
				// Show featured image
				if ( has_post_thumbnail() ) :

					echo kalium_get_attachment_image( get_post_thumbnail_id(), $thumbnail_size, kalium_get_featured_image_attrs() );

					// Show image placeholder
				elseif ( apply_filters( 'kalium_blog_loop_show_image_placeholder', true ) ) :
					$placeholder = '<span class="image-placeholder"></span>';

					if ( $placeholder_image = kalium_get_blog_option( 'loop/post_thumbnail/placeholder/image' ) ) {
						$placeholder = kalium_get_attachment_image( $placeholder_image, 'full', kalium_get_featured_image_attrs() );
					}

					printf( '<div class="blank-image">%s</div>', $placeholder );
				endif;
				?>
			</a>
			<?php

		endif;
		?>
	
	<?php
		/**
		 * After post thumbnail.
		 *
		 * @hooked kalium_blog_post_hover_layer - 10
		 * @hooked kalium_blog_post_format_icon - 20
		 */
		do_action( 'kalium_blog_loop_after_post_thumbnail' );
	?>
	
</div>
