<?php
/**
 * Kalium WordPress Theme
 *
 * Posts loop.
 *
 * @var array $attributes
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<ul <?php kalium_render_attributes( $attributes ); ?>>
	
	<?php
	/**
	 * Blog posts loop.
	 */
	if ( have_posts() ) :

		while ( have_posts() ) :
			the_post();

			?>
			<li id="post-<?php the_ID(); ?>" <?php post_class( 'post' ); ?>>

				<?php
				/**
				 * Post item template.
				 */
				kalium_blog_loop_post_template();
				?>

			</li>
			<?php

		endwhile;

	else :

		/**
		 * No posts to show.
		 *
		 * @hooked kalium_blog_no_posts_found_message - 10
		 */
		do_action( 'kalium_blog_no_posts_found' );

	endif;
	?>
	
</ul>
