<?php
/**
 * Kalium WordPress Theme
 *
 * Single post image template.
 *
 * @var WP_Post $post
 * @var array $attributes
 * @var array $post_format_content
 * @var string $thumbnail_size
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_render_attributes( $attributes ); ?>>

	<?php
	/**
	 * Before post image hook.
	 */
	do_action( 'kalium_blog_single_before_post_image' );
	?>

	<?php
	// Show post format content if it contains
	if ( ! empty( $post_format_content ) ) :

		kalium_show_post_format_content( $post_format_content );

	else :

		// Show featured image
		if ( has_post_thumbnail() ) :

			?>
			<a href="<?php echo esc_url( kalium_get_post_image_link( $post ) ); ?>" class="featured-image">
				<?php echo kalium_get_attachment_image_eager( get_post_thumbnail_id(), $thumbnail_size ); ?>
			</a>
			<?php

		endif;

	endif;
	?>

	<?php
	/**
	 * After post image hook.
	 */
	do_action( 'kalium_blog_single_after_post_image' );
	?>

</div>
