<?php
/**
 * Kalium WordPress Theme
 *
 * Load more pagination button.
 *
 * @var array $attributes
 * @var string $view_more_text
 * @var string $last_page_text
 * @var string $loading_spinner
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_render_attributes( $attributes ); ?>>
	<div class="load-more__content">
		<div class="load-more__status">
			<div class="infinite-scroll-request"><i class="<?php echo esc_attr( $loading_spinner ); ?>"></i></div>
			<div class="infinite-scroll-last"><?php echo esc_html( $last_page_text ); ?></div>
		</div>
		<button type="button" class="load-more__view-more"><?php echo esc_html( $view_more_text ); ?></button>
	</div>
</div>
