<?php
/**
 * Kalium WordPress Theme
 *
 * Logo element template.
 *
 * @var array $attributes
 * @var string $link
 * @var string $logo_name
 * @var array $logo_image
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Before logo.
 */
do_action( 'kalium_before_logo' );

?>
<a <?php kalium_render_attributes( $attributes ); ?>>
	<?php if ( ! empty( $logo_image ) ) : ?>
		<img src="<?php echo esc_url( $logo_image['src'] ); ?>" class="main-logo" width="<?php echo esc_attr( $logo_image['width'] ); ?>" height="<?php echo esc_attr( $logo_image['height'] ); ?>" alt="<?php echo esc_attr( $logo_name ); ?>" fetchpriority="high" decoding="async"/>
	<?php else : ?>
		<span class="logo-text"><?php echo esc_html( $logo_name ); ?></span>
	<?php endif; ?>
</a>
<?php

/**
 * After logo.
 */
do_action( 'kalium_after_logo' );
