<?php
/**
 * Kalium WordPress Theme
 *
 * Product Add to Cart element.
 *
 * @var string $display_type
 * @var string $structure
 * @var bool $tooltip_hover
 * @var bool $tooltip_added
 * @var string $tooltip_placement
 * @var string $button_icon
 * @var number $button_icon_svg
 * @var number $button_icon_svg_size
 * @var bool $button_block
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $product;

// Button icon
switch ( $button_icon ) {

	// Plus icon
	case 'icon-1':
		$button_icon = 'kalium-icon-plus';
		break;

	// Shopping bag icon
	case 'icon-2':
		$button_icon = 'kalium-icon-shopping-bag';
		break;

	// Shopping cart icon
	case 'icon-3':
		$button_icon = 'kalium-icon-shopping-cart';
		break;

	// Shopping basket icon
	case 'icon-4':
		$button_icon = 'kalium-icon-shopping-basket';
		break;
}

// Show add to cart button
kalium_woocommerce_loop_add_to_cart(
	[
		'button'        => 'button' === $display_type,
		'button_block'  => $button_block,
		'show_icon'     => in_array( $structure, [ 'icon', 'icon-text' ] ),
		'show_text'     => in_array( $structure, [ 'text', 'icon-text' ] ),
		'icon'          => $button_icon,

		// Custom icon
		'icon_svg'      => $button_icon_svg,
		'icon_svg_size' => $button_icon_svg_size,

		// Tooltip
		'tooltip'       => [
			'hover'     => $tooltip_hover,
			'added'     => $tooltip_added,
			'placement' => $tooltip_placement,
		],
	]
);
