<?php
/**
 * Kalium WordPress Theme
 *
 * Product attribute.
 *
 * @var Element $element
 * @var string $attribute_name
 * @var string $custom_attribute_name
 * @var bool $show_label
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$selected_attribute = $element->get_selected_attribute( $attribute_name, $custom_attribute_name );

// Show attribute
if ( ! empty( $selected_attribute ) ) {
	?>
	<div class="product-attribute">
		<?php if ( $show_label ) : ?>
			<div class="product-attribute__column product-attribute__label"><?php echo wp_kses_post( $selected_attribute['label'] ); ?></div>
		<?php endif; ?>
		<div class="product-attribute__column product-attribute__value">
			<?php echo wp_kses_post( $selected_attribute['value'] ); ?>
		</div>
	</div>
	<?php
}
