<?php
/**
 * Kalium WordPress Theme
 *
 * Product Category element.
 *
 * @var string $taxonomy
 * @var string $separator
 * @var string $text_before
 * @var string $text_after
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
global $product;

// Default value
if ( empty( $separator ) ) {
	$separator = ', ';
}

// Tags
if ( 'tag' === $taxonomy ) {
	$product_terms = wc_get_product_tag_list( $product->get_id(), $separator, $text_before, $text_after );
} else { // Categories
	$product_terms = wc_get_product_category_list( $product->get_id(), $separator, $text_before, $text_after );
}

// Print product categories/tags
if ( ! empty( $product_terms ) ) {
	printf(
		'<div class="%s">%s</div>',
		kalium_tokenize_list(
			[
				'product-terms',
				kalium_get_link_text_class(),
				kalium_get_link_style_class_by_context( 'product-category', kalium_get_link_plain_class() ),
			]
		),
		$product_terms
	);
}
