<?php
/**
 * Kalium WordPress Theme
 *
 * WooCommerce Product Images element template.
 *
 * @var string $gallery_type
 * @var bool $link_to_product
 * @var int $gallery_max_images
 * @var string $gallery_navigation_type
 * @var bool $gallery_navigation_arrows
 * @var bool $gallery_navigation_arrows_visible_on_hover
 * @var string $gallery_navigation_arrows_size
 * @var string $gallery_navigation_arrows_type
 * @var array $gallery_navigation_arrows_style
 * @var array $gallery_navigation_arrows_style_hover
 * @var string $gallery_navigation_arrows_border_radius
 * @var bool $gallery_pagination
 * @var string $gallery_pagination_style
 * @var bool $gallery_pagination_visible_on_hover
 * @var string $gallery_pagination_hover_animation
 * @var string $gallery_navigation_effect
 * @var bool $gallery_navigation_loop
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Gallery args
$gallery_args = [
	'link' => $link_to_product,
];

switch ( $gallery_type ) {

	// Second image on hover
	case 'second-image-hover':
		kalium_woocommerce_loop_product_second_image_on_hover( $gallery_args );
		break;

	// Product gallery
	case 'product-gallery':
		$gallery_args = array_merge(
			$gallery_args,
			[

				// Applied to Slider navigation type only
				'navigation'                  => $gallery_navigation_arrows,
				'navigation_visible_on_hover' => $gallery_navigation_arrows_visible_on_hover,
				'navigation_size'             => $gallery_navigation_arrows_size,
				'navigation_type'             => $gallery_navigation_arrows_type,
				'navigation_style'            => $gallery_navigation_arrows_style,
				'navigation_style_hover'      => $gallery_navigation_arrows_style_hover,
				'navigation_border_radius'    => $gallery_navigation_arrows_border_radius,

				// Applied to both navigation types (slider and hover)
				'max_images'                  => $gallery_max_images,
				'pagination'                  => $gallery_pagination,
				'pagination_style'            => $gallery_pagination_style,
				'pagination_hover'            => $gallery_pagination_visible_on_hover,
				'pagination_hover_animation'  => $gallery_pagination_hover_animation,

				// Other slider settings
				'effect'                      => $gallery_navigation_effect,
				'loop'                        => $gallery_navigation_loop,
			]
		);

		if ( 'hover' === $gallery_navigation_type ) {
			kalium_woocommerce_loop_product_gallery_on_hover( $gallery_args );
		} else {
			kalium_woocommerce_loop_product_gallery_slider( $gallery_args );
		}
		break;

	// Featured image
	default:
		kalium_woocommerce_loop_product_image( $gallery_args );
}
