<?php
/**
 * Kalium WordPress Theme
 *
 * Product Sale Badge element.
 *
 * @var bool $badge_outline
 * @var string $badge_style
 * @var int $triangle_rotation
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $product;

$args = [];

// Custom badge style
if ( in_array( $badge_style, [ 'badge', 'circle', 'triangle' ] ) ) {
	$args['style']   = $badge_style;
	$args['outline'] = $badge_outline;

	if ( 'triangle' === $badge_style ) {
		$args['rotation'] = $triangle_rotation;
	}
}

// Show badge
kalium_woocommerce_product_badge( $product, $args );
