<?php
/**
 * Kalium WordPress Theme
 *
 * Wishlist element.
 *
 * @var string $display_type
 * @var string $structure
 * @var bool $button_block
 * @var bool $tooltip_hover
 * @var bool $tooltip_added
 * @var string $tooltip_placement
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Show add to wishlist button
kalium_woocommerce_loop_add_to_wishlist(
	[
		'button'       => 'button' === $display_type,
		'button_block' => $button_block,
		'show_icon'    => in_array( $structure, [ 'icon', 'icon-text' ] ),
		'show_text'    => in_array( $structure, [ 'text', 'icon-text' ] ),

		// Tooltip
		'tooltip'      => [
			'hover'     => $tooltip_hover,
			'added'     => $tooltip_added,
			'placement' => $tooltip_placement,
		],
	]
);
