<?php
/**
 * Kalium WordPress Theme
 *
 * Title and subtitle.
 *
 * @var array $attributes
 * @var string $tag_name
 * @var string $title
 * @var string $subtitle
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div <?php kalium_render_attributes( $attributes ); ?>>

	<?php
	/**
	 * Item title.
	 */
	kalium_render_element(
		[
			'tag_name' => $tag_name,
			'content'  => $title,
		]
	);
	?>

	<?php
	/**
	 * Item subtitle.
	 */
	if ( ! empty( $subtitle ) ) {
		kalium_render_element(
			[
				'tag_name'   => 'div',
				'attributes' => [
					'class' => 'single-portfolio__title__subtitle',
				],
				'content'    => $subtitle,
			]
		);
	}
	?>
</div>
