<?php
/**
 * Kalium WordPress Theme
 *
 * Add to wishlist link (loop).
 *
 * @var array $args
 * @var string $wishlist_url
 * @var string $wishlist_label
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $product;

// Loading indicator
$loading_indicator = '<span class="link-button__loading"></span>';

// Link content
$content = [];

// Show icon
if ( $args['show_icon'] ) {
	$icon  = '<i class="kalium-icon-add-to-wishlist"></i>';
	$icon .= '<i class="kalium-icon-added-to-wishlist"></i>';

	$content[] = sprintf( '<span class="link-button__content link-button__content--icon"><span class="button-icon">%1$s</span>%2$s</span>', $icon, $loading_indicator );
} else {
	$content[] = $loading_indicator;
}

// Show text
if ( $args['show_text'] ) {
	$content[] = sprintf( '<span class="link-button__content link-button__content--text">%s</span>', esc_html( $wishlist_label ) );
}

echo apply_filters(
	'kalium_woocommerce_yith_add_to_wishlist',
	sprintf(
		'<a href="%s" class="%s" %s>%s</a>',
		esc_url( $wishlist_url ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		implode( '', $content )
	),
	$product,
	$args
);
