<?php
/**
 * Kalium WordPress Theme
 *
 * Mini cart drawer template.
 *
 * @var array $attributes
 * @var bool $is_empty
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 * @version 4.2
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<form <?php kalium_render_attributes( $attributes ); ?>>

	<?php if ( $is_empty ) : ?>

		<div class="mini-cart-drawer__empty">
			<?php
			/**
			 * Mini cart empty.
			 */
			do_action( 'kalium_woocommerce_mini_cart_empty' );
			?>
		</div>

	<?php else : ?>

		<div class="mini-cart-drawer__header">
			<?php
			/**
			 * Mini cart header.
			 */
			do_action( 'kalium_woocommerce_mini_cart_header' );
			?>
		</div>
		<div class="mini-cart-drawer__contents">
			<?php
			/**
			 * Mini cart contents.
			 */
			do_action( 'kalium_woocommerce_mini_cart_contents' );
			?>
		</div>
		<div class="mini-cart-drawer__footer">
			<?php
			/**
			 * Mini cart footer.
			 */
			do_action( 'kalium_woocommerce_mini_cart_footer' );
			?>
		</div>

	<?php endif; ?>

</form>
