<?php
/**
 * Kalium WordPress Theme
 *
 * Button widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Instance ID
$instance_id = 'button-' . kalium_generate_unique_string();

// Link
$link = vc_build_link( $link );

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'laborator-btn',
	'button',
	'btn',
	'btn-type-' . $type,
	$instance_id,
	$size,
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

if ( 'outlined-bg' === $type || 'fliphover' === $type ) {
	$classes[] = 'btn-type-outlined';
}

if ( 'custom' !== $button_bg ) {
	$classes[] = $button_bg;
}

// Custom Button Color
if ( 'custom' === $button_bg ) {
	switch ( $type ) {
		case 'outlined':
		case 'outlined-bg':
			if ( $button_bg_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "border-color: {$button_bg_custom} !important;" );

				if ( $type == 'outlined-bg' ) {
					kalium_append_custom_css( ".{$instance_id}:hover", "background: {$button_bg_custom} !important;" );
				}
			}

			if ( $button_txt_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "color: {$button_txt_custom} !important;" );
			}

			if ( $button_txt_hover_custom ) {
				kalium_append_custom_css( ".{$instance_id}:hover", "color: {$button_txt_hover_custom} !important;" );
				kalium_append_custom_css( ".{$instance_id}:hover", "border-color: {$button_txt_hover_custom} !important;" ); // May not be appropriate
			}
			break;

		case 'fliphover':
			if ( $button_bg_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "border-color: {$button_bg_custom} !important;" );
				kalium_append_custom_css( ".{$instance_id}:hover:before", "background-color: {$button_bg_custom} !important;" );
			}

			if ( $button_txt_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "color: {$button_txt_custom} !important;" );
			}

			if ( $button_txt_hover_custom ) {
				kalium_append_custom_css( ".{$instance_id}:hover", "color: {$button_txt_hover_custom} !important;" );
			}
			break;

		default:
			if ( $button_bg_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "background: {$button_bg_custom} !important;" );
			}

			if ( $button_txt_custom ) {
				kalium_append_custom_css( ".{$instance_id}", "color: {$button_txt_custom} !important;" );
			}

			if ( $button_txt_hover_custom ) {
				kalium_append_custom_css( ".{$instance_id}:hover", "color: {$button_txt_hover_custom} !important;" );
			}
	}
}

// Button element
kalium_render_element(
	[
		'tag_name'   => 'a',
		'attributes' => [
			'class'  => $classes,
			'href'   => $link['url'],
			'title'  => $link['title'],
			'target' => $link['target'],
		],
		'content'    => wp_kses_post( $title ),
	]
);

// Print white space
echo PHP_EOL;
