<?php
/**
 * Kalium WordPress Theme
 *
 * Client logos widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $parent_attrs;

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Parent attributes
$parent_attrs = $atts;

// Extract attributes
extract( $atts );

$instance_id = 'client-logos-' . kalium_generate_unique_string();
$custom_css  = [];

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$clients_classes = [
	'lab-client-logos',
	'client-logos',
	'grid',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

// Columns
$columns_prefix = 'columns';
$columns_count  = intval( $parent_attrs['columns_count'] );
$grid_columns   = kalium_parse_responsive_value( $columns_count );

if ( 5 < $columns_count ) {
	$grid_columns['tablet'] = 4;
} elseif ( 4 === $columns_count ) {
	$grid_columns['tablet'] = 3;
}

$grid_columns['mobile'] = 1;

$clients_classes = array_merge( $clients_classes, kalium_responsive_classname_infix( $grid_columns, $columns_prefix ) );

// Column spacing
if ( ! kalium_validate_boolean( $column_spacing ) ) {
	$clients_classes[] = 'client-logos--no-gap';
}

// Image borders
if ( kalium_validate_boolean( $image_borders ) ) {
	$clients_classes[] = 'client-logos--has-borders';
}

// Hover effect 1
if ( 'hover-opacity' === $hover_style ) {
	$clients_classes[] = 'client-logos--hover-effect-1';
}

// Max height / Aspect Ratio
if ( is_numeric( $height ) ) {
	$custom_css[] = [
		'selector' => '#' . $instance_id,
		'vars'     => [
			'logos-max-height' => $height . 'px',
		],
	];
} elseif ( $height && preg_match( '/^(\d+(?:\.\d+)?)\s*(?::|\/)\s*(\d+(?:\.\d+)?)$/', trim( $height ), $matches ) ) {
	$custom_css[] = [
		'selector' => '#' . $instance_id,
		'vars'     => [
			'logos-ratio' => $matches[1] . ' / ' . $matches[2],
		],
	];
}

// Style
$custom_css[] = [
	'selector' => '#' . $instance_id,
	'vars'     => [
		'logos-border-color'  => $border_color,
		'logos-overlay-bg'    => $hover_bg,
		'logos-overlay-color' => $hover_txt,
	],
];

// Print styles
kalium_print_inline_style(
	[
		'styles' => $custom_css,
	]
);

?>
<div id="<?php echo esc_attr( $instance_id ); ?>" <?php kalium_class_attr( $clients_classes ); ?>>
	<?php echo wpb_js_remove_wpautop( $content ); ?>
</div>
