<?php
/**
 * Kalium WordPress Theme
 *
 * Client logo entry.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $parent_attrs;

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

extract( $atts );

// If no image return empty
if ( ! $image ) {
	return;
}

// Image
$image = wpb_getImageBySize(
	[
		'attach_id'  => $image,
		'thumb_size' => $parent_attrs['img_size'],
	]
);

$link = vc_build_link( $link );

// Item attributes
$item_attributes = [
	'class' => [
		'client-logos__entry',
	],
];

// Hover layer attributes
$hover_layer_attributes = [
	'class' => [
		'hover-state',
	],
];

// Reveal effect
if ( $parent_attrs['reveal_effect'] ) {
	$item_attributes = array_merge(
		$item_attributes,
		kalium_animate_on_viewport(
			kalium_parse_legacy_wow_args(
				$parent_attrs['reveal_effect']
			)
		)
	);
}

// Thumbnail
$thumbnail = kalium_get_array_key( $image, 'thumbnail' );

// Add loading="lazy"
if ( $parent_attrs['lazy_load'] ) {
	$thumbnail = kalium()->helpers->add_element_attribute( $thumbnail, 'img', 'loading', 'lazy' );
}

if ( $link['url'] ) {
	$thumbnail = sprintf(
		'<a href="%s" target="%s">%s</a>',
		esc_url( $link['url'] ),
		esc_attr( $link['target'] ),
		$thumbnail
	);

	$hover_layer_attributes['data-href']   = $link['url'];
	$hover_layer_attributes['data-target'] = $link['target'];
}

// Title
$title = esc_html( $title );

if ( $link['url'] ) {
	$title = sprintf(
		'<a href="%s" target="%s">%s</a>',
		esc_url( $link['url'] ),
		esc_attr( $link['target'] ),
		$title
	);
}

if ( 'distanced' === $parent_attrs['hover_style'] ) {
	$hover_layer_attributes['class'][] = 'with-spacing';
}

?>
<div <?php kalium_render_attributes( $item_attributes ); ?>>
	<?php echo $thumbnail; ?>

	<?php if ( in_array( $parent_attrs['hover_style'], [ 'full', 'distanced' ] ) ) : ?>
		<div <?php kalium_render_attributes( $hover_layer_attributes ); ?>>
			<div class="hover-state__content">
				<h3><?php echo $title; ?></h3>

				<?php if ( $description ) : ?>
					<div class="description">
						<?php echo wp_kses_post( wpautop( $description ) ); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	<?php endif; ?>
</div>
