<?php
/**
 * Kalium WordPress Theme
 *
 * Heading widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Element Class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$container_attributes = [
	'id'    => $el_id ?: false,
	'class' => [
		'lab-heading',
		'section-title',
		$css_class,
		vc_shortcode_custom_css_class( $css ),
	],
];
?>
<div <?php kalium_render_attributes( $container_attributes ); ?>>
	<?php
	kalium_render_element(
		[
			'tag_name' => $title_tag,
			'content'  => esc_html( $title ),
		]
	);

	if ( $content ) {
		echo wp_kses_post( wpautop( $content ) );
	}
	?>
</div>
