<?php
/**
 * Kalium WordPress Theme
 *
 * Scrollable container widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Unique element id
$instance_id = 'scrollbox-' . kalium_generate_unique_string();

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-scroll-box',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

$content_attributes = [
	'class' => [
		'lab-scroll-box-content',
	],
];

if ( is_numeric( $scroll_height ) ) {
	$content_attributes['style'] = sprintf( 'max-height: %dpx;', $scroll_height );
} elseif ( 'auto' === $scroll_height ) {
	$classes[] = 'lab-scroll-box--auto-height';
}

?>
<div id="<?php echo esc_attr( $instance_id ); ?>" <?php kalium_class_attr( $classes ); ?>>
	<div <?php kalium_render_attributes( $content_attributes ); ?>>
		<?php echo kalium_format_content( $content ); ?>
	</div>
</div>
