<?php
/**
 * Kalium WordPress Theme
 *
 * Team members widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $parent_attrs;

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Store parent attributes
$parent_attrs = $atts;

// Extract attributes
extract( $atts );

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$classes = [
	'lab-team-members',
	$css_class,
	vc_shortcode_custom_css_class( $css ),
];

// Item class
switch ( $columns_count ) {
	case 1:
		$parent_attrs['item_class'][] = 'col-sm-12';
		break;

	case 2:
		$parent_attrs['item_class'][] = 'col-sm-6';
		break;

	case 3:
		$parent_attrs['item_class'][] = 'col-md-4 col-sm-6';
		break;

	case 4:
		$parent_attrs['item_class'][] = 'col-md-3 col-sm-6';
		break;
}

// Instance ID
$instance_id = 'team-members-' . kalium_generate_unique_string();

// Thumb Size
if ( ! preg_match( '/^[0-9]+x[0-9]+$/', $img_size ) ) {
	$img_size = '460x460';
}

// Styles
$custom_css = [];

if ( $hover_bg ) {
	$custom_css[] = [
		'selector' => "#{$instance_id} .member .hover-state",
		'props'    => [
			'background-color' => $hover_bg,
		],
	];
	$custom_css[] = [
		'selector' => "#{$instance_id} .thumb:hover .hover-state",
		'props'    => [
			'opacity' => 1,
		],
	];
}

if ( $hover_txt ) {
	$custom_css[] = [
		'selector' => "#{$instance_id} .member .hover-state *",
		'props'    => [
			'color' => $hover_txt,
		],
	];
	$custom_css[] = [
		'selector' => "#{$instance_id} .member .hover-state a:after",
		'props'    => [
			'background-color' => $hover_txt,
		],
	];
}

if ( ( $thumb_size = explode( 'x', $img_size ) ) && ! empty( $thumb_size[1] ) ) {
	$custom_css[] = [
		'selector' => "#{$instance_id} .new-member-join .thumb",
		'props'    => [
			'aspect-ratio' => $thumb_size[0] / $thumb_size[1],
		],
	];
}

// Print styles
kalium_print_inline_style(
	[
		'styles' => $custom_css,
	]
);

?>
<div id="<?php echo esc_attr( $instance_id ); ?>" <?php kalium_class_attr( $classes ); ?>>
	<div class="team-holder">
		<div class="row">
			<?php echo wpb_js_remove_wpautop( $content ); ?>
		</div>
	</div>
</div>
