<?php
/**
 * Kalium WordPress Theme
 *
 * Member placeholder entry.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

global $parent_attrs;

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Link
$link = vc_build_link( $link );

// Element Class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

// New member element attributes
$new_member_attrs = array_merge(
	[
		'class' => [
			'new-member-join',
			'layout-' . $parent_attrs['layout_type'],
			$css_class,
		],
	],
	kalium_animate_on_viewport( kalium_parse_legacy_wow_args( $parent_attrs['reveal_effect'] ) )
);

// Member details
ob_start();

?>
<div class="details">
	<h2><?php echo esc_html( $title ); ?></h2>

	<?php if ( $sub_title ) : ?>
	<p class="text">
		<?php if ( $link['url'] ) : ?>
		<a href="<?php echo esc_url( $link['url'] ); ?>" target="<?php echo esc_attr( $link['target'] ); ?>" title="<?php echo esc_attr( $link['title'] ); ?>">
			<?php echo esc_html( $sub_title ); ?>
		</a>
		<?php else : ?>
			<?php echo $sub_title; ?>
		<?php endif; ?>
	</p>
	<?php endif; ?>
</div>
<?php

$member_details = ob_get_clean();
?>
<div <?php kalium_class_attr( $parent_attrs['item_class'] ); ?>>
	<div <?php kalium_render_attributes( $new_member_attrs ); ?>>
		<div class="thumb">
			<div class="hover-state padding">
				<div class="join-us">
					<img class="missing-pic" src="<?php echo kalium()->assets_url( 'images/icons/missing-pic.png' ); ?>" alt="<?php echo esc_attr( $sub_title ); ?>">

					<?php if ( $image_title ) : ?>
						<p class="your-image"><?php echo esc_html( $image_title ); ?></p>
					<?php endif; ?>

					<?php if ( 'visible-titles' !== $parent_attrs['layout_type'] ) : ?>
						<?php echo $member_details; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>

	<?php if ( 'visible-titles' === $parent_attrs['layout_type'] ) : ?>
		<?php echo $member_details; ?>
	<?php endif; ?>
</div>
