<?php
/**
 * Kalium WordPress Theme
 *
 * Auto type widget.
 *
 * @var array $atts
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Attributes
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

// Extract attributes
extract( $atts );

// Enqueue typed.js library
kalium_enqueue( 'typed' );

// Typed Text
$typed_text_safe = vc_value_from_safe( $typed_text );

if ( strpos( $typed_text, '#E-' ) == 0 ) {
	$typed_text = $typed_text_safe;
}

// Fixes shortcode issue that wraps attribute with <p> incorrectly
$typed_text = preg_replace( '/<\/p>(.*)<p>$/s', '$1', $typed_text );

// Process Text
if ( preg_match_all( '/(\*.*?\*)/is', $typed_text, $typed_entries ) ) {
	foreach ( $typed_entries[0] as $typed_entry ) {
		$typed_options = [
			'cursorChar' => $typed_options_cursorchar,
			'showCursor' => $typed_options_cursorchar ? true : false,

			'loop'       => $typed_options_loopcount == -1 || $typed_options_loopcount > 0 ? true : false,
			'loopCount'  => $typed_options_loopcount > 0 ? ( $typed_options_loopcount - 1 ) : 0,

			'typeSpeed'  => absint( $typed_options_typespeed ),
			'backSpeed'  => absint( $typed_options_backspeed ),

			'startDelay' => absint( $typed_options_startdelay ),
			'backDelay'  => absint( $typed_options_backdelay ),
		];

		$typed_processed = WPBakeryShortCode_Lab_Text_Autotype::process_entry( $typed_entry, $typed_options );
		$typed_text      = str_replace( $typed_entry, $typed_processed, $typed_text );
		$typed_text      = preg_replace( '/^\s*<br\s*(\/)?>/i', '', $typed_text );
	}
}

// Element class
$class     = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

// Render element
kalium_render_element(
	[
		'tag_name'   => 'div',
		'attributes' => [
			'class' => [
				'lab-auto-type',
				'auto-type-element',
				$css_class,
				vc_shortcode_custom_css_class( $css ),
			],
		],
		'content'    => $typed_text,
	]
);
