<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.3.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Product card
wc_set_loop_prop( 'products_view', kalium_woocommerce_get_products_view() );

// Classes
$classes = [
	'products',
	'grid',
];

// Extra classes
if ( isset( $extra_classes ) ) {
	array_unshift( $classes, $extra_classes );
}

// Columns
$columns        = wc_get_loop_prop( 'columns' );
$columns_tablet = wc_get_loop_prop( 'columns_tablet', max( 2, ceil( $columns / 2 ) ) );
$columns_mobile = wc_get_loop_prop( 'columns_mobile', ceil( $columns_tablet / 2 ) );

// List view
if ( 'list' === kalium_woocommerce_get_products_view() ) {
	$columns = $columns_tablet = $columns_mobile = 1;
}

// Responsive columns arr
$columns_responsive = [
	'desktop' => $columns,
	'tablet'  => $columns_tablet,
	'mobile'  => $columns_mobile,
];

// Columns classes
$classes = array_merge( $classes, kalium_responsive_classname_infix( $columns_responsive, 'columns' ) );

?>
<ul <?php kalium_class_attr( $classes ); ?>>
